/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.avm;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.RandomizedTC;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.StringBinaryToIntegerExpression;
import org.evosuite.symbolic.expr.bv.StringUnaryToIntegerExpression;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.solver.SolverEmptyQueryException;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.avm.EvoSuiteSolver;
import org.junit.Assert;
import org.junit.Test;

public class TestConstraintSolver1
extends RandomizedTC {
    private static final String INIT_STRING = "abc_e";
    private static final String EXPECTED_STRING = "abcbb";

    public void testMe(String x) {
        if (x.length() == 5 && x.charAt(4) == '_') {
            System.out.println("Juhu");
        }
    }

    private static Collection<Constraint<?>> buildConstraintSystem() {
        StringVariable var0 = new StringVariable("var0", INIT_STRING);
        StringUnaryToIntegerExpression length = new StringUnaryToIntegerExpression((Expression)var0, Operator.LENGTH, Long.valueOf(INIT_STRING.length()));
        IntegerConstant const3 = new IntegerConstant(3L);
        StringBinaryToIntegerExpression charAt3 = new StringBinaryToIntegerExpression((Expression)var0, Operator.CHARAT, (Expression)const3, Long.valueOf(INIT_STRING.charAt(3)));
        IntegerConstant const4 = new IntegerConstant(4L);
        StringBinaryToIntegerExpression charAt4 = new StringBinaryToIntegerExpression((Expression)var0, Operator.CHARAT, (Expression)const4, Long.valueOf(INIT_STRING.charAt(4)));
        IntegerConstant const5 = new IntegerConstant((long)INIT_STRING.length());
        IntegerConstant const95 = new IntegerConstant((long)EXPECTED_STRING.charAt(3));
        IntegerConstant const43 = new IntegerConstant((long)EXPECTED_STRING.charAt(4));
        IntegerConstraint constr1 = new IntegerConstraint((Expression)length, Comparator.EQ, (Expression)const5);
        IntegerConstraint constr2 = new IntegerConstraint((Expression)charAt3, Comparator.EQ, (Expression)const95);
        IntegerConstraint constr3 = new IntegerConstraint((Expression)charAt4, Comparator.EQ, (Expression)const43);
        return Arrays.asList(constr1, constr2, constr3);
    }

    @Test
    public void test() throws SolverEmptyQueryException {
        Properties.LOCAL_SEARCH_BUDGET = 100L;
        Properties.LOCAL_SEARCH_BUDGET_TYPE = Properties.LocalSearchBudgetType.FITNESS_EVALUATIONS;
        Collection<Constraint<?>> constraints = TestConstraintSolver1.buildConstraintSystem();
        System.out.println("Constraints:");
        for (Constraint<?> c : constraints) {
            System.out.println(c.toString());
        }
        EvoSuiteSolver seeker = new EvoSuiteSolver();
        try {
            SolverResult solverResult = seeker.solve(constraints);
            Assert.assertTrue((boolean)solverResult.isSAT());
            Map model = solverResult.getModel();
            System.out.println(model);
            Object var0 = model.get("var0");
            System.out.println("Expected: abcbb");
            System.out.println("Found: " + var0);
            Assert.assertEquals((Object)EXPECTED_STRING, var0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }
}

