/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.avm;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.RandomizedTC;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.StringConstraint;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.StringBinaryComparison;
import org.evosuite.symbolic.expr.bv.StringComparison;
import org.evosuite.symbolic.expr.str.StringConstant;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.solver.SolverEmptyQueryException;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.avm.EvoSuiteSolver;
import org.junit.Assert;
import org.junit.Test;

public class TestConstraintSolver2
extends RandomizedTC {
    private static final String INIT_STRING = "abc_e";
    private static final String EXPECTED_STRING = "abcbb";

    private static Collection<Constraint<?>> buildConstraintSystem() {
        StringVariable var0 = new StringVariable("var0", INIT_STRING);
        StringConstant const0 = new StringConstant(EXPECTED_STRING);
        StringBinaryComparison strEqual = new StringBinaryComparison((Expression)var0, Operator.EQUALS, (Expression)const0, Long.valueOf(0L));
        IntegerConstant const_zero = new IntegerConstant(0L);
        StringConstraint constr1 = new StringConstraint((StringComparison)strEqual, Comparator.NE, const_zero);
        return Arrays.asList(constr1);
    }

    @Test
    public void test() throws SolverEmptyQueryException {
        Properties.LOCAL_SEARCH_BUDGET = 100L;
        Properties.LOCAL_SEARCH_BUDGET_TYPE = Properties.LocalSearchBudgetType.FITNESS_EVALUATIONS;
        Collection<Constraint<?>> constraints = TestConstraintSolver2.buildConstraintSystem();
        System.out.println("Constraints:");
        for (Constraint<?> c : constraints) {
            System.out.println(c.toString());
        }
        System.out.println("");
        System.out.println("Initial: abc_e");
        EvoSuiteSolver solver = new EvoSuiteSolver();
        try {
            SolverResult solverResult = solver.solve(constraints);
            Assert.assertTrue((boolean)solverResult.isSAT());
            Map model = solverResult.getModel();
            Assert.assertNotNull((Object)model);
            Object var0 = model.get("var0");
            System.out.println("Expected: abcbb");
            System.out.println("Found: " + var0);
            Assert.assertEquals((Object)EXPECTED_STRING, var0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    public void test2() {
        String l1 = "hello";
        String l2 = "world";
        if (l1.equals(l2)) {
            System.out.println("xx");
        }
    }
}

