/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.avm;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.RandomizedTC;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.IntegerConstraint;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.StringToIntegerCast;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.solver.SolverEmptyQueryException;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.avm.EvoSuiteSolver;
import org.junit.Assert;
import org.junit.Test;

public class TestConstraintSolver3
extends RandomizedTC {
    private static final String INIT_STRING = "125";
    private static final int EXPECTED_INTEGER = 126;

    private static Collection<Constraint<?>> buildConstraintSystem() {
        StringVariable var0 = new StringVariable("var0", INIT_STRING);
        StringToIntegerCast castStr = new StringToIntegerCast((Expression)var0, Long.valueOf(Integer.parseInt(INIT_STRING)));
        IntegerConstant const126 = new IntegerConstant(126L);
        IntegerConstraint constr1 = new IntegerConstraint((Expression)castStr, Comparator.EQ, (Expression)const126);
        return Arrays.asList(constr1);
    }

    @Test
    public void test() throws SolverEmptyQueryException {
        Properties.LOCAL_SEARCH_BUDGET = 100L;
        Properties.LOCAL_SEARCH_BUDGET_TYPE = Properties.LocalSearchBudgetType.FITNESS_EVALUATIONS;
        Collection<Constraint<?>> constraints = TestConstraintSolver3.buildConstraintSystem();
        System.out.println("Constraints:");
        for (Constraint<?> c : constraints) {
            System.out.println(c.toString());
        }
        System.out.println("");
        System.out.println("Initial: 125");
        EvoSuiteSolver solver = new EvoSuiteSolver();
        try {
            SolverResult result = solver.solve(constraints);
            if (result.isUNSAT()) {
                Assert.fail((String)"search was unsuccessfull");
            } else {
                Map model = result.getModel();
                Object var0 = model.get("var0");
                System.out.println("Expected: 126");
                System.out.println("Found: " + var0);
                Assert.assertEquals((Object)String.valueOf(126), var0);
            }
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }
}

