/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.avm;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.evosuite.RandomizedTC;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.StringConstraint;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.StringBinaryComparison;
import org.evosuite.symbolic.expr.bv.StringComparison;
import org.evosuite.symbolic.expr.str.StringConstant;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.solver.SolverEmptyQueryException;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.avm.EvoSuiteSolver;
import org.evosuite.symbolic.vm.ExpressionFactory;
import org.junit.Assert;
import org.junit.Test;

public class TestPatternSearch
extends RandomizedTC {
    @Test
    public void testMatcherMatches() throws SolverEmptyQueryException {
        String input = "random_value";
        String format = "(\\d+)-(\\d\\d)-(\\d)";
        StringVariable var0 = new StringVariable("var0", input);
        StringConstant symb_regex = ExpressionFactory.buildNewStringConstant((String)format);
        StringBinaryComparison strComp = new StringBinaryComparison((Expression)symb_regex, Operator.PATTERNMATCHES, (Expression)var0, Long.valueOf(0L));
        StringConstraint constraint = new StringConstraint((StringComparison)strComp, Comparator.NE, new IntegerConstant(0L));
        List<StringConstraint> constraints = Collections.singletonList(constraint);
        try {
            EvoSuiteSolver solver = new EvoSuiteSolver();
            SolverResult result = solver.solve(constraints);
            Assert.assertTrue((boolean)result.isSAT());
            Map model = result.getModel();
            String var0_value = (String)model.get("var0");
            Pattern pattern = Pattern.compile(format);
            Matcher matcher = pattern.matcher(var0_value);
            Assert.assertTrue((boolean)matcher.matches());
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }
}

