/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.avm;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.RandomizedTC;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.RealConstraint;
import org.evosuite.symbolic.expr.fp.RealConstant;
import org.evosuite.symbolic.expr.fp.RealVariable;
import org.evosuite.symbolic.solver.SolverEmptyQueryException;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.avm.EvoSuiteSolver;
import org.junit.Assert;
import org.junit.Test;

public class TestRealConstraint
extends RandomizedTC {
    private static final double INIT_DOUBLE = 0.0;
    private static final double EXPECTED_DOUBLE = Math.PI;

    private static Collection<Constraint<?>> buildConstraintSystem() {
        RealVariable var0 = new RealVariable("var0", 0.0, Double.MIN_VALUE, Double.MAX_VALUE);
        RealConstant constPi = new RealConstant(Math.PI);
        RealConstraint constr1 = new RealConstraint((Expression)var0, Comparator.EQ, (Expression)constPi);
        return Arrays.asList(constr1);
    }

    @Test
    public void test() throws SolverEmptyQueryException {
        Properties.LOCAL_SEARCH_BUDGET = 100L;
        Properties.LOCAL_SEARCH_BUDGET_TYPE = Properties.LocalSearchBudgetType.FITNESS_EVALUATIONS;
        Collection<Constraint<?>> constraints = TestRealConstraint.buildConstraintSystem();
        System.out.println("Constraints:");
        for (Constraint<?> c : constraints) {
            System.out.println(c.toString());
        }
        System.out.println("");
        System.out.println("Initial: " + String.valueOf(0.0));
        EvoSuiteSolver seeker = new EvoSuiteSolver();
        try {
            SolverResult result = seeker.solve(constraints);
            if (result.isUNSAT()) {
                Assert.fail((String)"search was unsuccessfull");
            } else {
                Map model = result.getModel();
                Object var0 = model.get("var0");
                System.out.println("Expected: 3.141592653589793");
                System.out.println("Found: " + var0);
                Assert.assertEquals((Object)Math.PI, var0);
            }
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }
}

