/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.avm;

import java.util.ArrayList;
import java.util.Map;
import org.evosuite.RandomizedTC;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.RealConstraint;
import org.evosuite.symbolic.expr.fp.RealBinaryExpression;
import org.evosuite.symbolic.expr.fp.RealConstant;
import org.evosuite.symbolic.expr.fp.RealVariable;
import org.evosuite.symbolic.solver.DistanceEstimator;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.TestSolver;
import org.evosuite.symbolic.solver.avm.EvoSuiteSolver;
import org.junit.Assert;
import org.junit.Test;

public class TestRealSearch
extends RandomizedTC {
    @Test
    public void testEQConstant() {
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", 0.675464, (double)1.4E-45f, 3.4028234663852886E38), Comparator.EQ, (Expression)new RealConstant(2.35082)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            Assert.assertNotNull((Object)result.get("test1"));
            Assert.assertTrue((2.35082 == ((Number)result.get("test1")).doubleValue() ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testNEConstant() {
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", 2.35082, -1000000.0, 1000000.0), Comparator.NE, (Expression)new RealConstant(2.35082)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            Assert.assertNotNull((Object)result.get("test1"));
            Assert.assertTrue((2.35082 != ((Number)result.get("test1")).doubleValue() ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testLEConstant() {
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", 5.35086, -1000000.0, 1000000.0), Comparator.LE, (Expression)new RealConstant(2.35082)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            Assert.assertNotNull((Object)result.get("test1"));
            Assert.assertTrue((2.35082 >= ((Number)result.get("test1")).doubleValue() ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testLTConstant() {
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", 5.35086, -1000000.0, 1000000.0), Comparator.LT, (Expression)new RealConstant(2.35082)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            Assert.assertNotNull((Object)result.get("test1"));
            Assert.assertTrue((2.35082 > ((Number)result.get("test1")).doubleValue() ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGEConstant() {
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", 0.0, -1000000.0, 1000000.0), Comparator.GE, (Expression)new RealConstant(2.35082)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            Assert.assertNotNull((Object)result.get("test1"));
            Assert.assertTrue((2.35082 <= ((Number)result.get("test1")).doubleValue() ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGTConstant() {
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", 0.0, -1000000.0, 1000000.0), Comparator.GT, (Expression)new RealConstant(2.35082)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            Assert.assertNotNull((Object)result.get("test1"));
            Assert.assertTrue((2.35082 < ((Number)result.get("test1")).doubleValue() ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEQConstantAfterComma() {
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", 0.0, -1000000.0, 1000000.0), Comparator.EQ, (Expression)new RealConstant(0.35082)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            Assert.assertNotNull((Object)result.get("test1"));
            Assert.assertTrue((0.35082 == ((Number)result.get("test1")).doubleValue() ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testLEConstantAfterComma() {
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", 2.35086, -1000000.0, 1000000.0), Comparator.LE, (Expression)new RealConstant(2.35082)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            Assert.assertNotNull((Object)result.get("test1"));
            Assert.assertTrue((2.35082 >= ((Number)result.get("test1")).doubleValue() ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testLTConstantAfterComma() {
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", 2.35086, -1000000.0, 1000000.0), Comparator.LT, (Expression)new RealConstant(2.35082)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            Assert.assertNotNull((Object)result.get("test1"));
            Assert.assertTrue((2.35082 > ((Number)result.get("test1")).doubleValue() ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGEConstantAfterComma() {
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", 2.0, -1000000.0, 1000000.0), Comparator.GE, (Expression)new RealConstant(2.35082)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            Assert.assertNotNull((Object)result.get("test1"));
            Assert.assertTrue((2.35082 <= ((Number)result.get("test1")).doubleValue() ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGTConstantAfterComma() {
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", 2.0, -1000000.0, 1000000.0), Comparator.GT, (Expression)new RealConstant(2.35082)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            Assert.assertNotNull((Object)result.get("test1"));
            Assert.assertTrue((2.35082 < ((Number)result.get("test1")).doubleValue() ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEQVariable() {
        double var1 = 0.23123;
        double var2 = 1.12321;
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", var1, -1000000.0, 1000000.0), Comparator.EQ, (Expression)new RealVariable("test2", var2, -1000000.0, 1000000.0)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).doubleValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).doubleValue();
            }
            Assert.assertEquals((double)var1, (double)var2, (double)0.001);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testNEVariable() {
        double var1 = 1.5546;
        double var2 = 1.5546;
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", var1, -1000000.0, 1000000.0), Comparator.NE, (Expression)new RealVariable("test2", var2, -1000000.0, 1000000.0)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).doubleValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).doubleValue();
            }
            Assert.assertTrue((var1 != var2 ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testLEVariable() {
        double var1 = 2.6576;
        double var2 = 1.434;
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", var1, -1000000.0, 1000000.0), Comparator.LE, (Expression)new RealVariable("test2", var2, -1000000.0, 1000000.0)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).doubleValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).doubleValue();
            }
            Assert.assertTrue((var1 <= var2 ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testLTVariable() {
        double var1 = 2.6576;
        double var2 = 1.434;
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", var1, -1000000.0, 1000000.0), Comparator.LT, (Expression)new RealVariable("test2", var2, -1000000.0, 1000000.0)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).doubleValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).doubleValue();
            }
            Assert.assertTrue((var1 < var2 ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGEVariable() {
        double var1 = 0.7868;
        double var2 = 1.9765;
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", var1, -1000000.0, 1000000.0), Comparator.GE, (Expression)new RealVariable("test2", var2, -1000000.0, 1000000.0)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).doubleValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).doubleValue();
            }
            Assert.assertTrue((var1 >= var2 ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testGTVariable() {
        double var1 = 0.7868;
        double var2 = 1.9765;
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealVariable("test1", var1, -1000000.0, 1000000.0), Comparator.GT, (Expression)new RealVariable("test2", var2, -1000000.0, 1000000.0)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).doubleValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).doubleValue();
            }
            Assert.assertTrue((var1 > var2 ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEvosuiteExample1() {
        double var1 = 1.0;
        double var2 = 1.0;
        RealVariable realVar1 = new RealVariable("test1", var1, -1000000.0, 1000000.0);
        RealVariable realVar2 = new RealVariable("test2", var2, -1000000.0, 1000000.0);
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)realVar1, Comparator.LE, (Expression)new RealConstant(0.0)));
        constraints.add((Constraint<?>)new RealConstraint((Expression)realVar1, Comparator.LT, (Expression)realVar2));
        constraints.add((Constraint<?>)new RealConstraint((Expression)realVar1, Comparator.GE, (Expression)new RealConstant(0.0)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).doubleValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).doubleValue();
            }
            Assert.assertEquals((double)0.0, (double)var1, (double)1.0E-4);
            Assert.assertTrue((var1 < var2 ? 1 : 0) != 0);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testEvosuiteExample2() {
        double var1 = 355.80758027529504;
        RealVariable realVar = new RealVariable("test1", var1, -1000000.0, 1000000.0);
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)realVar, Comparator.GE, (Expression)new RealConstant(0.0)));
        constraints.add((Constraint<?>)new RealConstraint((Expression)realVar, Comparator.EQ, (Expression)new RealConstant(0.0)));
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).doubleValue();
            }
            Assert.assertEquals((double)0.0, (double)var1, (double)1.0E-4);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    public void testEvosuiteExample3() {
        double var1 = 12.221f;
        double var2 = -45.63354f;
        RealVariable realVar1 = new RealVariable("test1", var1, -1000000.0, 1000000.0);
        RealVariable realVar2 = new RealVariable("test2", var2, -1000000.0, 1000000.0);
        ArrayList constraints = new ArrayList();
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealBinaryExpression((Expression)new RealBinaryExpression((Expression)new RealConstant(1102.5), Operator.PLUS, (Expression)realVar1, Double.valueOf(1.22209997177135E16)), Operator.MUL, (Expression)realVar2, Double.valueOf(-5.57687492989087E32)), Comparator.EQ, (Expression)new RealConstant((double)2.7724E32f)));
        assert (DistanceEstimator.getDistance(constraints) > 0.0);
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).doubleValue();
            }
            if (result.containsKey("test2")) {
                var2 = ((Number)result.get("test2")).doubleValue();
            }
            Assert.assertEquals((double)var1, (double)var2, (double)1.0E-4);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testAddition() {
        double var1 = 1.0;
        RealVariable realVar1 = new RealVariable("test1", var1, Double.MIN_VALUE, Double.MAX_VALUE);
        ArrayList constraints = new ArrayList();
        double doubleValue = 2000.087658834634;
        constraints.add((Constraint<?>)new RealConstraint((Expression)new RealBinaryExpression((Expression)new RealConstant(1102.5), Operator.PLUS, (Expression)realVar1, Double.valueOf(1103.5)), Comparator.EQ, (Expression)new RealConstant(2000.087658834634)));
        assert (DistanceEstimator.getDistance(constraints) > 0.0);
        EvoSuiteSolver skr = new EvoSuiteSolver();
        try {
            Map<String, Object> result = TestSolver.solve((Solver)skr, constraints);
            Assert.assertNotNull(result);
            if (result.containsKey("test1")) {
                var1 = ((Number)result.get("test1")).doubleValue();
            }
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }
}

