/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.avm;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.evosuite.RandomizedTC;
import org.evosuite.symbolic.expr.Comparator;
import org.evosuite.symbolic.expr.Constraint;
import org.evosuite.symbolic.expr.Expression;
import org.evosuite.symbolic.expr.Operator;
import org.evosuite.symbolic.expr.StringConstraint;
import org.evosuite.symbolic.expr.bv.IntegerConstant;
import org.evosuite.symbolic.expr.bv.StringBinaryComparison;
import org.evosuite.symbolic.expr.bv.StringComparison;
import org.evosuite.symbolic.expr.str.StringConstant;
import org.evosuite.symbolic.expr.str.StringVariable;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.TestSolver;
import org.evosuite.symbolic.solver.avm.EvoSuiteSolver;
import org.junit.Assert;
import org.junit.Test;

public class TestStringEqualsIgnoreCase
extends RandomizedTC {
    @Test
    public void testStringEqualsIgnoreCase() throws SecurityException, NoSuchMethodException, SolverTimeoutException {
        IntegerConstant zero = new IntegerConstant(0L);
        StringVariable stringVar0 = new StringVariable("var0", "");
        StringConstant strConst = new StringConstant("bar");
        StringBinaryComparison cmp1 = new StringBinaryComparison((Expression)stringVar0, Operator.EQUALS, (Expression)strConst, Long.valueOf(0L));
        StringConstraint constr1 = new StringConstraint((StringComparison)cmp1, Comparator.EQ, zero);
        StringBinaryComparison cmp2 = new StringBinaryComparison((Expression)stringVar0, Operator.EQUALSIGNORECASE, (Expression)strConst, Long.valueOf(1L));
        StringConstraint constr2 = new StringConstraint((StringComparison)cmp2, Comparator.NE, zero);
        List<Constraint<?>> constraints = Arrays.asList(constr1, constr2);
        EvoSuiteSolver solver = new EvoSuiteSolver();
        Map<String, Object> solution = TestSolver.solve((Solver)solver, constraints);
        Assert.assertNotNull(solution);
        String var0 = (String)solution.get("var0");
        Assert.assertNotNull((Object)var0);
        Assert.assertTrue((!var0.equals("bar") ? 1 : 0) != 0);
        Assert.assertTrue((boolean)var0.equalsIgnoreCase("bar"));
    }
}

