/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.avm;

import com.examples.with.different.packagename.concolic.StringSearch2;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.RandomizedTC;
import org.evosuite.symbolic.BranchCondition;
import org.evosuite.symbolic.ConcolicExecution;
import org.evosuite.symbolic.SymbolicObserverTest;
import org.evosuite.symbolic.TestCaseBuilder;
import org.evosuite.symbolic.solver.Solver;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.TestSolver;
import org.evosuite.symbolic.solver.avm.EvoSuiteSolver;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.variable.VariableReference;
import org.junit.Assert;
import org.junit.Test;

public class TestStringSearch2
extends RandomizedTC {
    @Test
    public void testValidPathURN() {
        String pathURN = "urn:path:/A/B/C/doc.html#gilada";
        StringSearch2.checkPathURN(pathURN);
    }

    @Test
    public void testValidPathURN2() {
        String pathURN = "u:path:/";
        StringSearch2.checkPathURN(pathURN);
    }

    @Test
    public void testInvalidPathURN() {
        try {
            String pathURN = "urn:paxth:/A/B/C/doc.html#gilada";
            StringSearch2.checkPathURN(pathURN);
            Assert.fail();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    @Test
    public void testCreatePathConstraint() throws SecurityException, NoSuchMethodException {
        DefaultTestCase tc = this.buildTestCase("urn:pBth:/A/B/C/doc.html#gilada");
        List<BranchCondition> branch_conditions = this.executeTest(tc);
        Assert.assertEquals((long)11L, (long)branch_conditions.size());
    }

    @Test
    public void testSolvePathConstraint() throws SecurityException, NoSuchMethodException {
        DefaultTestCase tc = this.buildTestCase("urn:pBth:/A/B/C/doc.html#gilada");
        List<BranchCondition> branch_conditions = this.executeTest(tc);
        ArrayList constraints = new ArrayList();
        for (int i = 0; i < branch_conditions.size() - 1; ++i) {
            BranchCondition b = branch_conditions.get(i);
            constraints.addAll(b.getSupportingConstraints());
            constraints.add(b.getConstraint());
        }
        BranchCondition last_branch = branch_conditions.get(branch_conditions.size() - 1);
        constraints.addAll(last_branch.getSupportingConstraints());
        constraints.add(last_branch.getConstraint().negate());
        EvoSuiteSolver solver = new EvoSuiteSolver();
        try {
            Map<String, Object> solution = TestSolver.solve((Solver)solver, constraints);
            Assert.assertNotNull(solution);
            System.out.println(solution);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    @Test
    public void testSolveIndexOfConstant() throws SecurityException, NoSuchMethodException {
        DefaultTestCase tc = this.buildTestCase("V*X-:o%tp");
        List<BranchCondition> branch_conditions = this.executeTest(tc);
        ArrayList constraints = new ArrayList();
        for (int i = 0; i < branch_conditions.size() - 2; ++i) {
            BranchCondition b = branch_conditions.get(i);
            constraints.addAll(b.getSupportingConstraints());
            constraints.add(b.getConstraint());
        }
        BranchCondition last_branch = branch_conditions.get(branch_conditions.size() - 2);
        constraints.addAll(last_branch.getSupportingConstraints());
        constraints.add(last_branch.getConstraint().negate());
        EvoSuiteSolver solver = new EvoSuiteSolver();
        try {
            Map<String, Object> solution = TestSolver.solve((Solver)solver, constraints);
            Assert.assertNotNull(solution);
            System.out.println(solution);
        }
        catch (SolverTimeoutException e) {
            Assert.fail();
        }
    }

    private DefaultTestCase buildTestCase(String stringVal) throws SecurityException, NoSuchMethodException {
        TestCaseBuilder tc = new TestCaseBuilder();
        VariableReference string0 = tc.appendStringPrimitive(stringVal);
        Method method = StringSearch2.class.getMethod("checkPathURN", String.class);
        tc.appendMethod(null, method, string0);
        return tc.getDefaultTestCase();
    }

    private List<BranchCondition> executeTest(DefaultTestCase tc) {
        Properties.CLIENT_ON_THREAD = true;
        Properties.PRINT_TO_SYSTEM = true;
        Properties.TIMEOUT = 5000;
        Properties.CONCOLIC_TIMEOUT = 5000000;
        System.out.println("TestCase=");
        System.out.println(tc.toCode());
        List branch_conditions = ConcolicExecution.executeConcolic((DefaultTestCase)tc);
        SymbolicObserverTest.printConstraints(branch_conditions);
        return branch_conditions;
    }
}

