/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.symbolic.solver.cvc4;

import org.evosuite.symbolic.solver.SolverErrorException;
import org.evosuite.symbolic.solver.SolverParseException;
import org.evosuite.symbolic.solver.SolverResult;
import org.evosuite.symbolic.solver.SolverTimeoutException;
import org.evosuite.symbolic.solver.cvc4.CVC4ResultParser;
import org.junit.Assert;
import org.junit.Test;

public class TestCVC4ResultParser {
    @Test
    public void parseBlankStringSolution() throws SolverParseException, SolverErrorException, SolverTimeoutException {
        StringBuffer buff = new StringBuffer();
        buff.append("sat\n");
        buff.append("(model\n");
        buff.append("(define-fun var8 () String \" \")\n");
        buff.append(")\n");
        String result_str = buff.toString();
        CVC4ResultParser parser = new CVC4ResultParser();
        SolverResult solution = parser.parse(result_str);
        Assert.assertTrue((boolean)solution.isSAT());
        Assert.assertEquals((Object)" ", (Object)solution.getValue("var8"));
    }

    @Test
    public void parseEmptyStringSolution() throws SolverParseException, SolverErrorException, SolverTimeoutException {
        StringBuffer buff = new StringBuffer();
        buff.append("sat\n");
        buff.append("(model\n");
        buff.append("(define-fun var8 () String \"\")\n");
        buff.append(")\n");
        String result_str = buff.toString();
        CVC4ResultParser parser = new CVC4ResultParser();
        SolverResult solution = parser.parse(result_str);
        Assert.assertTrue((boolean)solution.isSAT());
        Assert.assertEquals((Object)"", (Object)solution.getValue("var8"));
    }

    @Test
    public void parseSingleStringSolution() throws SolverParseException, SolverErrorException, SolverTimeoutException {
        StringBuffer buff = new StringBuffer();
        buff.append("sat\n");
        buff.append("(model\n");
        buff.append("(define-fun var8 () String \"Hello\")\n");
        buff.append(")\n");
        String result_str = buff.toString();
        CVC4ResultParser parser = new CVC4ResultParser();
        SolverResult solution = parser.parse(result_str);
        Assert.assertTrue((boolean)solution.isSAT());
        Assert.assertEquals((Object)"Hello", (Object)solution.getValue("var8"));
    }

    @Test
    public void parseSingleLineStringSolution() throws SolverParseException, SolverErrorException, SolverTimeoutException {
        StringBuffer buff = new StringBuffer();
        buff.append("sat\n");
        buff.append("(model\n");
        buff.append("(define-fun var8 () String \"Hello World\")\n");
        buff.append(")\n");
        String result_str = buff.toString();
        CVC4ResultParser parser = new CVC4ResultParser();
        SolverResult solution = parser.parse(result_str);
        Assert.assertTrue((boolean)solution.isSAT());
        Assert.assertEquals((Object)"Hello World", (Object)solution.getValue("var8"));
    }

    @Test
    public void parseMultiLineSolution() throws SolverParseException, SolverErrorException, SolverTimeoutException {
        StringBuffer buff = new StringBuffer();
        buff.append("sat\n");
        buff.append("(model\n");
        buff.append("(define-fun var8 () String \"Hello\nBeautiful\nWorld\")\n");
        buff.append(")\n");
        String result_str = buff.toString();
        CVC4ResultParser parser = new CVC4ResultParser();
        SolverResult solution = parser.parse(result_str);
        Assert.assertTrue((boolean)solution.isSAT());
        Assert.assertEquals((Object)"Hello\nBeautiful\nWorld", (Object)solution.getValue("var8"));
    }
}

