/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.evosuite.Properties;
import org.evosuite.runtime.annotation.BoundInputVariable;
import org.evosuite.runtime.annotation.Constraints;
import org.evosuite.runtime.javaee.injection.Injector;
import org.evosuite.runtime.javaee.javax.servlet.EvoServletConfig;
import org.evosuite.runtime.javaee.javax.servlet.EvoServletState;
import org.evosuite.runtime.javaee.javax.servlet.http.EvoHttpServletRequest;
import org.evosuite.testcase.ConstraintVerifier;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.StringPrimitiveStatement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.generic.GenericAccessibleObject;
import org.evosuite.utils.generic.GenericConstructor;
import org.evosuite.utils.generic.GenericMethod;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ConstraintVerifierTest {
    private static final double defaultPRP = Properties.PRIMITIVE_REUSE_PROBABILITY;
    private static final double defaultORP = Properties.OBJECT_REUSE_PROBABILITY;
    private static final boolean defaultJEE = Properties.JEE;

    @Before
    public void init() {
        Properties.PRIMITIVE_REUSE_PROBABILITY = 1.0;
        Properties.OBJECT_REUSE_PROBABILITY = 1.0;
        Properties.JEE = false;
    }

    @After
    public void tearDown() {
        Properties.PRIMITIVE_REUSE_PROBABILITY = defaultPRP;
        Properties.OBJECT_REUSE_PROBABILITY = defaultORP;
        Properties.JEE = defaultJEE;
    }

    public static HttpServlet getAFakeServletInstance() {
        return new FakeServlet();
    }

    public static void takeServletAsInput(FakeServlet servlet) {
    }

    @Constraints(noNullInputs=true, notMutable=true, noDirectInsertion=true)
    public static void fakeInjection(@BoundInputVariable(initializer=true) Servlet servlet) {
    }

    public static EvoHttpServletRequest getNullEvoHttpServletRequest() {
        return null;
    }

    @Constraints(noDirectInsertion=true)
    public static void noDirect() {
    }

    @Test
    public void testNoDirectInsertion() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        GenericMethod gm = new GenericMethod(ConstraintVerifierTest.class.getDeclaredMethod("noDirect", null), ConstraintVerifierTest.class);
        int pos = ConstraintVerifier.getAValidPositionForInsertion((GenericAccessibleObject)gm, (TestCase)tc.getTestCase(), (int)0);
        Assert.assertTrue((pos < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testPostConstructIssue() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        VariableReference servlet = factory.addConstructor(tc.getTestCase(), new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(Injector.class.getDeclaredMethod("executePostConstruct", Object.class, Class.class), Injector.class), 1, 0);
        Assert.assertEquals((long)3L, (long)tc.size());
        Assert.assertTrue((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
        boolean mutated = tc.deleteStatement(factory, 2);
        Assert.assertFalse((boolean)mutated);
        Assert.assertEquals((long)3L, (long)tc.size());
        Assert.assertFalse((boolean)ConstraintVerifier.canDelete((TestCase)tc.getTestCase(), (int)1));
        mutated = tc.deleteStatement(factory, 1);
        Assert.assertFalse((boolean)mutated);
        Assert.assertEquals((long)3L, (long)tc.size());
        mutated = tc.deleteStatement(factory, 0);
        Assert.assertTrue((boolean)mutated);
        Assert.assertEquals((long)1L, (long)tc.size());
        Assert.assertTrue((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
    }

    @Test
    public void testUniqueConstructors() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        Properties.JEE = true;
        factory.addConstructor(tc.getTestCase(), new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
        try {
            factory.addConstructor(tc.getTestCase(), new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testDeleteAfter() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        VariableReference req = factory.addMethod(tc.getTestCase(), new GenericMethod(ConstraintVerifierTest.class.getDeclaredMethod("getNullEvoHttpServletRequest", new Class[0]), ConstraintVerifierTest.class), 0, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(EvoHttpServletRequest.class.getDeclaredMethod("asPOST", new Class[0]), EvoHttpServletRequest.class), 1, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(EvoHttpServletRequest.class.getDeclaredMethod("asMultipartFormData", new Class[0]), EvoHttpServletRequest.class), 2, 0);
        Assert.assertEquals((long)3L, (long)tc.size());
        Assert.assertTrue((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
        Assert.assertTrue((boolean)ConstraintVerifier.canDelete((TestCase)tc.getTestCase(), (int)2));
        Assert.assertFalse((boolean)ConstraintVerifier.canDelete((TestCase)tc.getTestCase(), (int)1));
        Assert.assertTrue((boolean)ConstraintVerifier.canDelete((TestCase)tc.getTestCase(), (int)0));
        boolean mutated = tc.deleteStatement(factory, 1);
        Assert.assertFalse((boolean)mutated);
        Assert.assertEquals((long)3L, (long)tc.size());
        mutated = tc.deleteStatement(factory, 0);
        Assert.assertTrue((boolean)mutated);
        Assert.assertEquals((long)0L, (long)tc.size());
    }

    @Test
    public void testCanDelete() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        VariableReference servlet = factory.addConstructor(tc.getTestCase(), new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(Injector.class.getDeclaredMethod("executePostConstruct", Object.class), Injector.class), 1, 0);
        Assert.assertEquals((long)2L, (long)tc.size());
        Assert.assertTrue((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
        Assert.assertTrue((boolean)ConstraintVerifier.canDelete((TestCase)tc.getTestCase(), (int)0));
        Assert.assertFalse((boolean)ConstraintVerifier.canDelete((TestCase)tc.getTestCase(), (int)1));
        boolean mutated = tc.deleteStatement(factory, 1);
        Assert.assertFalse((boolean)mutated);
        Assert.assertEquals((long)2L, (long)tc.size());
        mutated = tc.deleteStatement(factory, 0);
        Assert.assertTrue((boolean)mutated);
        Assert.assertEquals((long)0L, (long)tc.size());
    }

    @Test
    public void testDelete_multipleVarsThatCouldBeReused() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        VariableReference servlet = factory.addConstructor(tc.getTestCase(), new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(Injector.class.getDeclaredMethod("executePostConstruct", Object.class), Injector.class), 1, 0);
        VariableReference secondServlet = factory.addConstructor(tc.getTestCase(), new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 2, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(Injector.class.getDeclaredMethod("executePostConstruct", Object.class), Injector.class), 3, 0);
        MethodStatement mt = (MethodStatement)tc.getTestCase().getStatement(3);
        mt.replace(servlet, secondServlet);
        Assert.assertEquals((long)4L, (long)tc.size());
        Assert.assertTrue((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
        Assert.assertTrue((boolean)ConstraintVerifier.canDelete((TestCase)tc.getTestCase(), (int)0));
        Assert.assertFalse((boolean)ConstraintVerifier.canDelete((TestCase)tc.getTestCase(), (int)1));
        Assert.assertTrue((boolean)ConstraintVerifier.canDelete((TestCase)tc.getTestCase(), (int)2));
        Assert.assertFalse((boolean)ConstraintVerifier.canDelete((TestCase)tc.getTestCase(), (int)3));
        boolean mutated = tc.deleteStatement(factory, 2);
        Assert.assertTrue((boolean)mutated);
        Assert.assertTrue((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
        Assert.assertEquals((long)2L, (long)tc.size());
    }

    @Test
    public void testInitializingBoundedVariable_wrong_callingMethodsBeforeInit() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        VariableReference servlet = factory.addConstructor(tc.getTestCase(), new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
        factory.addMethodFor(tc.getTestCase(), servlet, new GenericMethod(FakeServlet.class.getDeclaredMethod("foo", new Class[0]), FakeServlet.class), 1);
        factory.addMethod(tc.getTestCase(), new GenericMethod(Injector.class.getDeclaredMethod("executePostConstruct", Object.class), Injector.class), 2, 0);
        Assert.assertEquals((long)3L, (long)tc.size());
        Assert.assertFalse((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
    }

    @Test
    public void testInitializingBoundedVariable_wrong_inputInOtherMethodBeforeInit() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        VariableReference servlet = factory.addConstructor(tc.getTestCase(), new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(ConstraintVerifierTest.class.getDeclaredMethod("takeServletAsInput", FakeServlet.class), ConstraintVerifierTest.class), 1, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(Injector.class.getDeclaredMethod("executePostConstruct", Object.class), Injector.class), 2, 0);
        Assert.assertEquals((long)3L, (long)tc.size());
        Assert.assertFalse((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
    }

    @Test
    public void testInitializingBoundedVariable_correct() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        VariableReference servlet = factory.addConstructor(tc.getTestCase(), new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(Injector.class.getDeclaredMethod("executePostConstruct", Object.class), Injector.class), 1, 0);
        factory.addMethodFor(tc.getTestCase(), servlet, new GenericMethod(FakeServlet.class.getDeclaredMethod("foo", new Class[0]), FakeServlet.class), 2);
        Assert.assertEquals((long)3L, (long)tc.size());
        Assert.assertTrue((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
    }

    @Test
    public void testInitializingBoundedVariable_correct_severalCalls() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        VariableReference servlet = factory.addConstructor(tc.getTestCase(), new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(ConstraintVerifierTest.class.getDeclaredMethod("fakeInjection", Servlet.class), ConstraintVerifierTest.class), 1, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(Injector.class.getDeclaredMethod("executePostConstruct", Object.class), Injector.class), 2, 0);
        Assert.assertEquals((long)3L, (long)tc.size());
        Assert.assertTrue((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
    }

    @Test
    public void testInitializingBoundedVariable_wrong_atMostOnce() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        VariableReference servlet = factory.addConstructor(tc.getTestCase(), new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(Injector.class.getDeclaredMethod("executePostConstruct", Object.class), Injector.class), 1, 0);
        Assert.assertEquals((long)2L, (long)tc.size());
        Assert.assertTrue((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
        factory.addMethod(tc.getTestCase(), new GenericMethod(Injector.class.getDeclaredMethod("executePostConstruct", Object.class), Injector.class), 2, 0);
        Assert.assertEquals((long)3L, (long)tc.size());
        Assert.assertFalse((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
    }

    @Test
    public void testInitializingBoundedVariable_wrong_noConstructor() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        factory.addMethod(tc.getTestCase(), new GenericMethod(ConstraintVerifierTest.class.getDeclaredMethod("getAFakeServletInstance", new Class[0]), ConstraintVerifierTest.class), 0, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(Injector.class.getDeclaredMethod("executePostConstruct", Object.class), Injector.class), 1, 0);
        Assert.assertEquals((long)2L, (long)tc.size());
        Assert.assertFalse((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
    }

    @Test
    public void testHasAnyOnlyForAssertionMethod() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        VariableReference req = factory.addMethod(tc.getTestCase(), new GenericMethod(EvoServletState.class.getDeclaredMethod("getRequest", new Class[0]), EvoServletState.class), 0, 0);
        Assert.assertEquals((String)tc.getTestCase().toCode(), (long)1L, (long)tc.size());
        Assert.assertFalse((boolean)ConstraintVerifier.hasAnyOnlyForAssertionMethod((TestCase)tc.getTestCase()));
        factory.addMethodFor(tc.getTestCase(), req, new GenericMethod(EvoHttpServletRequest.class.getDeclaredMethod("isAsyncStarted", new Class[0]), EvoHttpServletRequest.class), 1);
        Assert.assertEquals((String)tc.getTestCase().toCode(), (long)2L, (long)tc.size());
        Assert.assertTrue((boolean)ConstraintVerifier.hasAnyOnlyForAssertionMethod((TestCase)tc.getTestCase()));
    }

    @Test
    public void testBaseTest() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        factory.addConstructor(tc.getTestCase(), new GenericConstructor(Object.class.getConstructor(new Class[0]), Object.class), 0, 0);
        Assert.assertEquals((long)1L, (long)tc.size());
        Assert.assertTrue((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
    }

    @Test
    public void testAfter() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        factory.addMethod(tc.getTestCase(), new GenericMethod(EvoServletState.class.getDeclaredMethod("getRequest", new Class[0]), EvoServletState.class), 0, 0);
        Assert.assertEquals((long)1L, (long)tc.size());
        Assert.assertFalse((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
        VariableReference con = factory.addConstructor(tc.getTestCase(), new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(EvoServletState.class.getDeclaredMethod("initServlet", Servlet.class), EvoServletState.class), 1, 0);
        Assert.assertEquals((long)3L, (long)tc.size());
        Assert.assertTrue((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
    }

    @Test
    public void testAtMostOnce() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        VariableReference servlet = factory.addConstructor(tc.getTestCase(), new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(EvoServletState.class.getDeclaredMethod("initServlet", Servlet.class), EvoServletState.class), 1, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(EvoServletState.class.getDeclaredMethod("getRequest", new Class[0]), EvoServletState.class), 2, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(EvoServletState.class.getDeclaredMethod("getResponse", new Class[0]), EvoServletState.class), 3, 0);
        Assert.assertEquals((long)4L, (long)tc.size());
        Assert.assertTrue((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
        factory.addMethod(tc.getTestCase(), new GenericMethod(EvoServletState.class.getDeclaredMethod("getResponse", new Class[0]), EvoServletState.class), 4, 0);
        Assert.assertEquals((long)5L, (long)tc.size());
        Assert.assertFalse((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
    }

    @Test
    public void testNoNullInputs_notNull() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        VariableReference servlet = factory.addConstructor(tc.getTestCase(), new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(EvoServletState.class.getDeclaredMethod("initServlet", Servlet.class), EvoServletState.class), 1, 0);
        StringPrimitiveStatement foo = new StringPrimitiveStatement(tc.getTestCase(), "foo");
        tc.getTestCase().addStatement((Statement)foo);
        VariableReference con = factory.addMethod(tc.getTestCase(), new GenericMethod(EvoServletState.class.getDeclaredMethod("getConfiguration", new Class[0]), EvoServletState.class), 3, 0);
        factory.addMethodFor(tc.getTestCase(), con, new GenericMethod(EvoServletConfig.class.getDeclaredMethod("createDispatcher", String.class), EvoServletConfig.class), 4);
        Assert.assertEquals((long)5L, (long)tc.size());
        Assert.assertTrue((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
    }

    @Test
    public void testNoNullInputs_nullString() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        VariableReference servlet = factory.addConstructor(tc.getTestCase(), new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(EvoServletState.class.getDeclaredMethod("initServlet", Servlet.class), EvoServletState.class), 1, 0);
        StringPrimitiveStatement foo = new StringPrimitiveStatement(tc.getTestCase(), null);
        tc.getTestCase().addStatement((Statement)foo);
        VariableReference con = factory.addMethod(tc.getTestCase(), new GenericMethod(EvoServletState.class.getDeclaredMethod("getConfiguration", new Class[0]), EvoServletState.class), 3, 0);
        factory.addMethodFor(tc.getTestCase(), con, new GenericMethod(EvoServletConfig.class.getDeclaredMethod("createDispatcher", String.class), EvoServletConfig.class), 4);
        Assert.assertEquals((String)tc.getTestCase().toCode(), (long)6L, (long)tc.size());
        Assert.assertTrue((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
    }

    @Test
    public void testExcludeOthers() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        VariableReference servlet = factory.addConstructor(tc.getTestCase(), new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
        factory.addMethod(tc.getTestCase(), new GenericMethod(EvoServletState.class.getDeclaredMethod("initServlet", Servlet.class), EvoServletState.class), 1, 0);
        VariableReference req = factory.addMethod(tc.getTestCase(), new GenericMethod(EvoServletState.class.getDeclaredMethod("getRequest", new Class[0]), EvoServletState.class), 2, 0);
        factory.addMethodFor(tc.getTestCase(), req, new GenericMethod(EvoHttpServletRequest.class.getDeclaredMethod("asGET", new Class[0]), EvoHttpServletRequest.class), 3);
        Assert.assertEquals((String)tc.getTestCase().toCode(), (long)4L, (long)tc.size());
        Assert.assertTrue((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
        factory.addMethodFor(tc.getTestCase(), req, new GenericMethod(EvoHttpServletRequest.class.getDeclaredMethod("asPOST", new Class[0]), EvoHttpServletRequest.class), 4);
        Assert.assertEquals((String)tc.getTestCase().toCode(), (long)5L, (long)tc.size());
        Assert.assertFalse((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
    }

    @Test
    public void testExcludeMethod() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        factory.addMethod(tc.getTestCase(), new GenericMethod(EvoServletState.class.getDeclaredMethod("reset", new Class[0]), EvoServletState.class), 0, 0);
        Assert.assertEquals((String)tc.getTestCase().toCode(), (long)1L, (long)tc.size());
        Assert.assertFalse((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
    }

    @Test
    public void testEvoSuiteClassExclude() throws Exception {
        TestChromosome tc = new TestChromosome();
        TestFactory factory = TestFactory.getInstance();
        factory.addConstructor(tc.getTestCase(), new GenericConstructor(EvoServletConfig.class.getConstructor(new Class[0]), EvoServletConfig.class), 0, 0);
        Assert.assertEquals((long)1L, (long)tc.size());
        Assert.assertFalse((boolean)ConstraintVerifier.verifyTest((TestChromosome)tc));
    }

    private static class FakeServlet
    extends HttpServlet {
        public void foo() {
        }
    }
}

