/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import com.examples.with.different.packagename.test.AbstractSuperclass;
import com.examples.with.different.packagename.test.ConcreteSubclass;
import com.examples.with.different.packagename.test.DowncastExample;
import org.evosuite.assertion.Assertion;
import org.evosuite.assertion.Inspector;
import org.evosuite.assertion.InspectorAssertion;
import org.evosuite.assertion.PrimitiveAssertion;
import org.evosuite.assertion.PrimitiveFieldAssertion;
import org.evosuite.symbolic.TestCaseBuilder;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.FieldReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.generic.GenericField;
import org.junit.Assert;
import org.junit.Test;

public class DowncastTest {
    @Test
    public void testUnnecessaryDownCast() throws NoSuchMethodException {
        TestCaseBuilder builder = new TestCaseBuilder();
        VariableReference var = builder.appendConstructor(DowncastExample.class.getConstructor(new Class[0]), new VariableReference[0]);
        VariableReference int0 = builder.appendIntPrimitive(42);
        VariableReference num0 = builder.appendMethod(var, DowncastExample.class.getMethod("getANumber", Integer.TYPE), int0);
        num0.setType(Integer.class);
        VariableReference boolean0 = builder.appendMethod(var, DowncastExample.class.getMethod("testMe", Number.class), num0);
        PrimitiveAssertion assertion = new PrimitiveAssertion();
        assertion.setSource(boolean0);
        assertion.setValue((Object)false);
        DefaultTestCase test = builder.getDefaultTestCase();
        test.getStatement(boolean0.getStPosition()).addAssertion((Assertion)assertion);
        test.removeDownCasts();
        Assert.assertEquals(Number.class, (Object)test.getStatement(2).getReturnClass());
    }

    @Test
    public void testNecessaryDownCast() throws NoSuchMethodException {
        TestCaseBuilder builder = new TestCaseBuilder();
        VariableReference var = builder.appendConstructor(DowncastExample.class.getConstructor(new Class[0]), new VariableReference[0]);
        VariableReference int0 = builder.appendIntPrimitive(42);
        VariableReference num0 = builder.appendMethod(var, DowncastExample.class.getMethod("getANumber", Integer.TYPE), int0);
        num0.setType(Integer.class);
        VariableReference boolean0 = builder.appendMethod(var, DowncastExample.class.getMethod("testWithInteger", Integer.class), num0);
        PrimitiveAssertion assertion = new PrimitiveAssertion();
        assertion.setSource(boolean0);
        assertion.setValue((Object)false);
        DefaultTestCase test = builder.getDefaultTestCase();
        test.getStatement(boolean0.getStPosition()).addAssertion((Assertion)assertion);
        test.removeDownCasts();
        Assert.assertEquals(Integer.class, (Object)test.getStatement(2).getReturnClass());
    }

    @Test
    public void testDownCastUnnecessaryForInspectorAssertion() throws NoSuchMethodException {
        TestCaseBuilder builder = new TestCaseBuilder();
        VariableReference var = builder.appendConstructor(DowncastExample.class.getConstructor(new Class[0]), new VariableReference[0]);
        VariableReference num0 = builder.appendMethod(var, DowncastExample.class.getMethod("getAbstractFoo", new Class[0]), new VariableReference[0]);
        num0.setType(ConcreteSubclass.class);
        DefaultTestCase test = builder.getDefaultTestCase();
        Inspector inspector = new Inspector(ConcreteSubclass.class, ConcreteSubclass.class.getMethod("getFoo", new Class[0]));
        InspectorAssertion assertion = new InspectorAssertion(inspector, test.getStatement(num0.getStPosition()), num0, (Object)true);
        test.getStatement(num0.getStPosition()).addAssertion((Assertion)assertion);
        test.removeDownCasts();
        System.out.println(test);
        Assert.assertEquals(AbstractSuperclass.class, (Object)test.getStatement(1).getReturnClass());
    }

    @Test
    public void testDownCastNecessaryForInspectorAssertion() throws NoSuchMethodException {
        TestCaseBuilder builder = new TestCaseBuilder();
        VariableReference var = builder.appendConstructor(DowncastExample.class.getConstructor(new Class[0]), new VariableReference[0]);
        VariableReference num0 = builder.appendMethod(var, DowncastExample.class.getMethod("getAbstractFoo", new Class[0]), new VariableReference[0]);
        num0.setType(ConcreteSubclass.class);
        DefaultTestCase test = builder.getDefaultTestCase();
        Inspector inspector = new Inspector(ConcreteSubclass.class, ConcreteSubclass.class.getMethod("getBar", new Class[0]));
        InspectorAssertion assertion = new InspectorAssertion(inspector, test.getStatement(num0.getStPosition()), num0, (Object)true);
        test.getStatement(num0.getStPosition()).addAssertion((Assertion)assertion);
        test.removeDownCasts();
        System.out.println(test);
        Assert.assertEquals(ConcreteSubclass.class, (Object)test.getStatement(1).getReturnClass());
    }

    @Test
    public void testDownCastUnnecessaryForField() throws NoSuchMethodException, NoSuchFieldException {
        TestCaseBuilder builder = new TestCaseBuilder();
        VariableReference var = builder.appendConstructor(DowncastExample.class.getConstructor(new Class[0]), new VariableReference[0]);
        VariableReference num0 = builder.appendMethod(var, DowncastExample.class.getMethod("getAbstractFoo", new Class[0]), new VariableReference[0]);
        num0.setType(ConcreteSubclass.class);
        DefaultTestCase test = builder.getDefaultTestCase();
        PrimitiveFieldAssertion assertion = new PrimitiveFieldAssertion();
        assertion.setValue((Object)true);
        assertion.setSource(num0);
        assertion.setField(AbstractSuperclass.class.getField("fieldInAbstractClass"));
        test.getStatement(num0.getStPosition()).addAssertion((Assertion)assertion);
        test.removeDownCasts();
        System.out.println(test);
        Assert.assertEquals(AbstractSuperclass.class, (Object)test.getStatement(1).getReturnClass());
    }

    @Test
    public void testDownCastNecessaryForField() throws NoSuchMethodException, NoSuchFieldException {
        TestCaseBuilder builder = new TestCaseBuilder();
        VariableReference var = builder.appendConstructor(DowncastExample.class.getConstructor(new Class[0]), new VariableReference[0]);
        VariableReference num0 = builder.appendMethod(var, DowncastExample.class.getMethod("getAbstractFoo", new Class[0]), new VariableReference[0]);
        num0.setType(ConcreteSubclass.class);
        DefaultTestCase test = builder.getDefaultTestCase();
        PrimitiveFieldAssertion assertion = new PrimitiveFieldAssertion();
        assertion.setValue((Object)true);
        assertion.setSource(num0);
        assertion.setField(ConcreteSubclass.class.getField("fieldInConcreteClass"));
        test.getStatement(num0.getStPosition()).addAssertion((Assertion)assertion);
        test.removeDownCasts();
        System.out.println(test);
        Assert.assertEquals(ConcreteSubclass.class, (Object)test.getStatement(1).getReturnClass());
    }

    @Test
    public void testFieldReferenceNeedsDowncast() throws NoSuchMethodException, NoSuchFieldException {
        TestCaseBuilder builder = new TestCaseBuilder();
        VariableReference var = builder.appendConstructor(DowncastExample.class.getConstructor(new Class[0]), new VariableReference[0]);
        VariableReference num0 = builder.appendMethod(var, DowncastExample.class.getMethod("getAbstractFoo", new Class[0]), new VariableReference[0]);
        num0.setType(ConcreteSubclass.class);
        VariableReference bool0 = builder.appendBooleanPrimitive(true);
        DefaultTestCase test = builder.getDefaultTestCase();
        FieldReference fr = new FieldReference((TestCase)test, new GenericField(ConcreteSubclass.class.getField("fieldInConcreteClass"), ConcreteSubclass.class), num0);
        AssignmentStatement statement = new AssignmentStatement((TestCase)test, (VariableReference)fr, bool0);
        test.addStatement((Statement)statement);
        test.removeDownCasts();
        System.out.println(test);
        FieldReference fr2 = (FieldReference)test.getStatement(3).getReturnValue();
        Assert.assertEquals(ConcreteSubclass.class, (Object)fr2.getSource().getVariableClass());
    }

    @Test
    public void testFieldReferenceDoesNotNeedDowncast() throws NoSuchMethodException, NoSuchFieldException {
        TestCaseBuilder builder = new TestCaseBuilder();
        VariableReference var = builder.appendConstructor(DowncastExample.class.getConstructor(new Class[0]), new VariableReference[0]);
        VariableReference num0 = builder.appendMethod(var, DowncastExample.class.getMethod("getAbstractFoo", new Class[0]), new VariableReference[0]);
        num0.setType(ConcreteSubclass.class);
        VariableReference bool0 = builder.appendBooleanPrimitive(true);
        DefaultTestCase test = builder.getDefaultTestCase();
        FieldReference fr = new FieldReference((TestCase)test, new GenericField(AbstractSuperclass.class.getField("fieldInAbstractClass"), AbstractSuperclass.class), num0);
        AssignmentStatement statement = new AssignmentStatement((TestCase)test, (VariableReference)fr, bool0);
        test.addStatement((Statement)statement);
        test.removeDownCasts();
        System.out.println(test);
        FieldReference fr2 = (FieldReference)test.getStatement(3).getReturnValue();
        Assert.assertEquals(AbstractSuperclass.class, (Object)fr2.getSource().getVariableClass());
    }
}

