/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import com.examples.with.different.packagename.AbstractEnumInInnerClass;
import com.examples.with.different.packagename.AbstractEnumUser;
import com.examples.with.different.packagename.EnumInInnerClass;
import com.examples.with.different.packagename.EnumUser;
import com.examples.with.different.packagename.otherpackage.ExampleWithInnerClass;
import com.examples.with.different.packagename.subpackage.ExampleWithInnerClass;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.Set;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestCodeVisitor;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.TestVisitor;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.EnumPrimitiveStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.utils.generic.GenericConstructor;
import org.evosuite.utils.generic.GenericMethod;
import org.evosuite.utils.generic.WildcardTypeImpl;
import org.junit.Assert;
import org.junit.Test;

public class TestCodeVisitorTest {
    public static <T extends Servlet> T foo(T servlet) {
        return servlet;
    }

    public static <T> T bar(T obj) {
        return obj;
    }

    @Test
    public void testInnerClassWithNameSubset() {
        TestCodeVisitor visitor = new TestCodeVisitor();
        Assert.assertEquals((Object)"TestCodeVisitorTest", (Object)visitor.getClassName(this.getClass()));
        Assert.assertEquals((Object)"TestCodeVisitorTest.Country", (Object)visitor.getClassName(Country.class));
        Assert.assertEquals((Object)"TestCodeVisitorTest.Country.CountryNameCode", (Object)visitor.getClassName(Country.CountryNameCode.class));
    }

    @Test
    public void testGenerics_methodWithExtends() throws NoSuchMethodException, ConstructionFailedException {
        DefaultTestCase tc = new DefaultTestCase();
        TestFactory.getInstance().addConstructor((TestCase)tc, new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
        VariableReference genericClass = TestFactory.getInstance().addConstructor((TestCase)tc, new GenericConstructor(ClassWithGeneric.class.getDeclaredConstructor(new Class[0]), ClassWithGeneric.class), 1, 0);
        Method m = ClassWithGeneric.class.getDeclaredMethod("hello", Servlet.class);
        GenericMethod gm = new GenericMethod(m, ClassWithGeneric.class);
        TestFactory.getInstance().addMethodFor((TestCase)tc, genericClass, gm, 2);
        Type[] types = gm.getParameterTypes();
        Assert.assertEquals((long)1L, (long)types.length);
        Type type = types[0];
        Assert.assertNotNull((Object)type);
        TypeVariable tv = (TypeVariable)type;
        Assert.assertEquals((long)1L, (long)tv.getBounds().length);
        Class upper = (Class)tv.getBounds()[0];
        Assert.assertEquals(Servlet.class, (Object)upper);
        TestCodeVisitor visitor = new TestCodeVisitor();
        tc.accept((TestVisitor)visitor);
    }

    @Test
    public void testGenerics_staticMethod() throws NoSuchMethodException, ConstructionFailedException {
        DefaultTestCase tc = new DefaultTestCase();
        TestFactory.getInstance().addConstructor((TestCase)tc, new GenericConstructor(Object.class.getDeclaredConstructor(new Class[0]), Object.class), 0, 0);
        Method m = TestCodeVisitorTest.class.getDeclaredMethod("bar", Object.class);
        GenericMethod gm = new GenericMethod(m, TestCodeVisitorTest.class);
        TestFactory.getInstance().addMethod((TestCase)tc, gm, 1, 0);
        Type[] types = gm.getParameterTypes();
        Assert.assertEquals((long)1L, (long)types.length);
        Type type = types[0];
        Assert.assertNotNull((Object)type);
        WildcardTypeImpl wt = (WildcardTypeImpl)type;
        Assert.assertEquals((long)0L, (long)wt.getLowerBounds().length);
        Assert.assertEquals((long)1L, (long)wt.getUpperBounds().length);
        Class upper = (Class)wt.getUpperBounds()[0];
        Assert.assertEquals(Object.class, (Object)upper);
        TestCodeVisitor visitor = new TestCodeVisitor();
        tc.accept((TestVisitor)visitor);
        System.out.println(visitor.getCode());
    }

    @Test
    public void testGenerics_staticMethodWithExtends() throws NoSuchMethodException, ConstructionFailedException {
        DefaultTestCase tc = new DefaultTestCase();
        TestFactory.getInstance().addConstructor((TestCase)tc, new GenericConstructor(FakeServlet.class.getDeclaredConstructor(new Class[0]), FakeServlet.class), 0, 0);
        Method m = TestCodeVisitorTest.class.getDeclaredMethod("foo", Servlet.class);
        GenericMethod gm = new GenericMethod(m, TestCodeVisitorTest.class);
        TestFactory.getInstance().addMethod((TestCase)tc, gm, 1, 0);
        Type[] types = gm.getParameterTypes();
        Assert.assertEquals((long)1L, (long)types.length);
        Type type = types[0];
        Assert.assertNotNull((Object)type);
        WildcardTypeImpl wt = (WildcardTypeImpl)type;
        Assert.assertEquals((long)0L, (long)wt.getLowerBounds().length);
        Assert.assertEquals((long)1L, (long)wt.getUpperBounds().length);
        Class upper = (Class)wt.getUpperBounds()[0];
        Assert.assertEquals(Object.class, (Object)upper);
        TestCodeVisitor visitor = new TestCodeVisitor();
        tc.accept((TestVisitor)visitor);
    }

    @Test
    public void testClashingImportNames() throws NoSuchMethodException, ConstructionFailedException {
        DefaultTestCase tc = new DefaultTestCase();
        TestFactory.getInstance().addConstructor((TestCase)tc, new GenericConstructor(com.examples.with.different.packagename.otherpackage.ExampleWithInnerClass.class.getDeclaredConstructor(new Class[0]), com.examples.with.different.packagename.otherpackage.ExampleWithInnerClass.class), 0, 0);
        TestFactory.getInstance().addConstructor((TestCase)tc, new GenericConstructor(ExampleWithInnerClass.class.getDeclaredConstructor(new Class[0]), ExampleWithInnerClass.class), 1, 0);
        TestCodeVisitor visitor = new TestCodeVisitor();
        tc.accept((TestVisitor)visitor);
        System.out.println(visitor.getCode());
        Set imports = visitor.getImports();
        Assert.assertTrue((boolean)imports.contains(com.examples.with.different.packagename.otherpackage.ExampleWithInnerClass.class));
        Assert.assertFalse((boolean)imports.contains(ExampleWithInnerClass.class));
        Assert.assertEquals((Object)"ExampleWithInnerClass", (Object)visitor.getClassName(com.examples.with.different.packagename.otherpackage.ExampleWithInnerClass.class));
        Assert.assertEquals((Object)"com.examples.with.different.packagename.subpackage.ExampleWithInnerClass", (Object)visitor.getClassName(ExampleWithInnerClass.class));
    }

    @Test
    public void testClashingImportNamesSubClasses() throws NoSuchMethodException, ConstructionFailedException {
        DefaultTestCase tc = new DefaultTestCase();
        TestFactory.getInstance().addConstructor((TestCase)tc, new GenericConstructor(ExampleWithInnerClass.Foo.class.getDeclaredConstructor(new Class[0]), ExampleWithInnerClass.Foo.class), 0, 0);
        TestFactory.getInstance().addConstructor((TestCase)tc, new GenericConstructor(ExampleWithInnerClass.Bar.class.getDeclaredConstructor(new Class[0]), ExampleWithInnerClass.Bar.class), 1, 0);
        TestCodeVisitor visitor = new TestCodeVisitor();
        tc.accept((TestVisitor)visitor);
        System.out.println(visitor.getCode());
        Set imports = visitor.getImports();
        Assert.assertTrue((boolean)imports.contains(com.examples.with.different.packagename.otherpackage.ExampleWithInnerClass.class));
        Assert.assertFalse((boolean)imports.contains(ExampleWithInnerClass.class));
        Assert.assertEquals((Object)"ExampleWithInnerClass", (Object)visitor.getClassName(com.examples.with.different.packagename.otherpackage.ExampleWithInnerClass.class));
        Assert.assertEquals((Object)"com.examples.with.different.packagename.subpackage.ExampleWithInnerClass", (Object)visitor.getClassName(ExampleWithInnerClass.class));
        Assert.assertEquals((Object)"ExampleWithInnerClass.Foo", (Object)visitor.getClassName(ExampleWithInnerClass.Foo.class));
        Assert.assertEquals((Object)"com.examples.with.different.packagename.subpackage.ExampleWithInnerClass.Bar", (Object)visitor.getClassName(ExampleWithInnerClass.Bar.class));
    }

    @Test
    public void testCastAndBoxingInArray() {
        DefaultTestCase tc = new DefaultTestCase();
        ArrayStatement shortArrayStatement = new ArrayStatement((TestCase)tc, short[].class, 5);
        tc.addStatement((Statement)shortArrayStatement);
        ArrayStatement longArrayStatement = new ArrayStatement((TestCase)tc, Long[].class, 5);
        tc.addStatement((Statement)longArrayStatement);
        ArrayIndex longIndex = new ArrayIndex((TestCase)tc, longArrayStatement.getArrayReference(), 0);
        ArrayIndex shortIndex = new ArrayIndex((TestCase)tc, shortArrayStatement.getArrayReference(), 1);
        AssignmentStatement assignmentStatement = new AssignmentStatement((TestCase)tc, (VariableReference)longIndex, (VariableReference)shortIndex);
        tc.addStatement((Statement)assignmentStatement);
        String code = tc.toCode();
        System.out.println(tc);
        Assert.assertFalse((boolean)code.contains("longArray0[0] = (Long) shortArray0[1]"));
    }

    @Test
    public void testWrapperCastInArray() {
        DefaultTestCase tc = new DefaultTestCase();
        ArrayStatement shortArrayStatement = new ArrayStatement((TestCase)tc, Short[].class, 5);
        tc.addStatement((Statement)shortArrayStatement);
        ArrayStatement intArrayStatement = new ArrayStatement((TestCase)tc, Integer[].class, 9);
        tc.addStatement((Statement)intArrayStatement);
        ArrayIndex intIndex = new ArrayIndex((TestCase)tc, intArrayStatement.getArrayReference(), 0);
        ArrayIndex shortIndex = new ArrayIndex((TestCase)tc, shortArrayStatement.getArrayReference(), 3);
        AssignmentStatement assignmentStatement = new AssignmentStatement((TestCase)tc, (VariableReference)intIndex, (VariableReference)shortIndex);
        tc.addStatement((Statement)assignmentStatement);
        String code = tc.toCode();
        System.out.println(tc);
        Assert.assertFalse((boolean)code.contains("integerArray0[0] = (Integer) shortArray0[3]"));
    }

    @Test
    public void testInnerClassEnum() throws Throwable {
        DefaultTestCase tc = new DefaultTestCase();
        VariableReference userObject = TestFactory.getInstance().addConstructor((TestCase)tc, new GenericConstructor(EnumUser.class.getDeclaredConstructor(new Class[0]), EnumUser.class), 0, 0);
        EnumPrimitiveStatement primitiveStatement = new EnumPrimitiveStatement((TestCase)tc, EnumInInnerClass.AnEnum.class);
        primitiveStatement.setValue((Object)EnumInInnerClass.AnEnum.FOO);
        VariableReference enumObject = tc.addStatement((Statement)primitiveStatement);
        Method m = EnumUser.class.getDeclaredMethod("foo", EnumInInnerClass.AnEnum.class);
        GenericMethod gm = new GenericMethod(m, EnumUser.class);
        MethodStatement ms = new MethodStatement((TestCase)tc, gm, userObject, Arrays.asList(enumObject));
        tc.addStatement((Statement)ms);
        TestCodeVisitor visitor = new TestCodeVisitor();
        tc.accept((TestVisitor)visitor);
        String code = visitor.getCode();
        Assert.assertTrue((boolean)code.contains("= EnumInInnerClass.AnEnum.FOO"));
    }

    @Test
    public void testInnerClassAbstractEnum() throws NoSuchMethodException, ConstructionFailedException {
        DefaultTestCase tc = new DefaultTestCase();
        VariableReference userObject = TestFactory.getInstance().addConstructor((TestCase)tc, new GenericConstructor(AbstractEnumUser.class.getDeclaredConstructor(new Class[0]), AbstractEnumUser.class), 0, 0);
        EnumPrimitiveStatement primitiveStatement = new EnumPrimitiveStatement((TestCase)tc, AbstractEnumInInnerClass.AnEnum.class);
        primitiveStatement.setValue((Object)AbstractEnumInInnerClass.AnEnum.FOO);
        VariableReference enumObject = tc.addStatement((Statement)primitiveStatement);
        Method m = AbstractEnumUser.class.getDeclaredMethod("foo", AbstractEnumInInnerClass.AnEnum.class);
        GenericMethod gm = new GenericMethod(m, AbstractEnumUser.class);
        MethodStatement ms = new MethodStatement((TestCase)tc, gm, userObject, Arrays.asList(enumObject));
        tc.addStatement((Statement)ms);
        TestCodeVisitor visitor = new TestCodeVisitor();
        tc.accept((TestVisitor)visitor);
        String code = visitor.getCode();
        System.out.println(code);
        Assert.assertFalse((boolean)code.contains("= AbstractEnumInInnerClass.AnEnum.1.FOO"));
        Assert.assertTrue((boolean)code.contains("= AbstractEnumInInnerClass.AnEnum.FOO"));
    }

    public static class Country {
        public String bar = "bar";

        public static class CountryNameCode {
            public String foo = "foo";
        }
    }

    public static class FakeServlet
    extends HttpServlet {
        private static final long serialVersionUID = 1L;
    }

    public static class ClassWithGeneric<T extends Servlet> {
        public T hello(T servlet) {
            return servlet;
        }
    }
}

