/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.numeric.IntPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.LongPrimitiveStatement;
import org.evosuite.testsuite.similarity.DiversityObserver;
import org.evosuite.utils.generic.GenericConstructor;
import org.junit.Assert;
import org.junit.Test;

public class TestSimilarity {
    @Test
    public void testSelfSimilarityBase() {
        DefaultTestCase test = new DefaultTestCase();
        double score = DiversityObserver.getNeedlemanWunschScore((TestCase)test, (TestCase)test);
        Assert.assertTrue((score <= 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testSelfSimilarity() {
        DefaultTestCase test = new DefaultTestCase();
        IntPrimitiveStatement aInt = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(42));
        test.addStatement((Statement)aInt);
        double score = DiversityObserver.getNeedlemanWunschScore((TestCase)test, (TestCase)test);
        Assert.assertTrue((score > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testBasicSimilarity() {
        DefaultTestCase test1 = new DefaultTestCase();
        DefaultTestCase test2 = new DefaultTestCase();
        IntPrimitiveStatement aInt = new IntPrimitiveStatement((TestCase)test1, Integer.valueOf(42));
        test1.addStatement((Statement)aInt);
        IntPrimitiveStatement bInt = new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(42));
        test2.addStatement((Statement)bInt);
        double score = DiversityObserver.getNeedlemanWunschScore((TestCase)test1, (TestCase)test2);
        Assert.assertTrue((score > 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testBasicSimilarityDifferentLength() {
        DefaultTestCase test1 = new DefaultTestCase();
        DefaultTestCase test2 = new DefaultTestCase();
        IntPrimitiveStatement aInt = new IntPrimitiveStatement((TestCase)test1, Integer.valueOf(42));
        test1.addStatement((Statement)aInt);
        IntPrimitiveStatement aInt2 = new IntPrimitiveStatement((TestCase)test1, Integer.valueOf(42));
        test1.addStatement((Statement)aInt2);
        IntPrimitiveStatement bInt = new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(42));
        test2.addStatement((Statement)bInt);
        double score = DiversityObserver.getNeedlemanWunschScore((TestCase)test1, (TestCase)test2);
        Assert.assertTrue((score <= 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testBasicSimilarityDifferentTypes() {
        DefaultTestCase test1 = new DefaultTestCase();
        DefaultTestCase test2 = new DefaultTestCase();
        IntPrimitiveStatement aInt = new IntPrimitiveStatement((TestCase)test1, Integer.valueOf(42));
        test1.addStatement((Statement)aInt);
        IntPrimitiveStatement aInt2 = new IntPrimitiveStatement((TestCase)test1, Integer.valueOf(42));
        test1.addStatement((Statement)aInt2);
        IntPrimitiveStatement bInt = new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(42));
        test2.addStatement((Statement)bInt);
        Constructor<?> c = Object.class.getConstructors()[0];
        ConstructorStatement cs = new ConstructorStatement((TestCase)test2, new GenericConstructor(c, Object.class), new ArrayList());
        test2.addStatement((Statement)cs);
        double score = DiversityObserver.getNeedlemanWunschScore((TestCase)test1, (TestCase)test2);
        Assert.assertTrue((score <= 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testBasicSimilarityDifferentTypes2() {
        DefaultTestCase test1 = new DefaultTestCase();
        DefaultTestCase test2 = new DefaultTestCase();
        LongPrimitiveStatement aInt = new LongPrimitiveStatement((TestCase)test1, Long.valueOf(42L));
        test1.addStatement((Statement)aInt);
        IntPrimitiveStatement aInt2 = new IntPrimitiveStatement((TestCase)test1, Integer.valueOf(42));
        test1.addStatement((Statement)aInt2);
        IntPrimitiveStatement bInt = new IntPrimitiveStatement((TestCase)test2, Integer.valueOf(42));
        test2.addStatement((Statement)bInt);
        Constructor<?> c = Object.class.getConstructors()[0];
        ConstructorStatement cs = new ConstructorStatement((TestCase)test2, new GenericConstructor(c, Object.class), new ArrayList());
        test2.addStatement((Statement)cs);
        double score = DiversityObserver.getNeedlemanWunschScore((TestCase)test1, (TestCase)test2);
        Assert.assertTrue((score <= 0.0 ? 1 : 0) != 0);
    }
}

