/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase;

import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.evosuite.testcase.execution.TimeoutHandler;
import org.junit.Assert;
import org.junit.Test;

public class TimeoutIntTest {
    protected static int RESULT = -1;

    @Test
    public void testNormalTimeout() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        FakeTestCase call = new FakeTestCase();
        TimeoutHandler handler = new TimeoutHandler();
        RESULT = -1;
        try {
            handler.execute((Callable)call, executor, 2000L, false);
        }
        catch (TimeoutException e) {
            executor.shutdownNow();
            try {
                boolean terminated = executor.awaitTermination(2000L, TimeUnit.MILLISECONDS);
                Assert.assertTrue((boolean)terminated);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            Assert.assertEquals((long)1L, (long)RESULT);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    @Test
    public void testCPUTimeout() {
        ExecutorService executor = Executors.newSingleThreadExecutor();
        FakeTestCase call = new FakeTestCase();
        TimeoutHandler handler = new TimeoutHandler();
        RESULT = -1;
        try {
            handler.execute((Callable)call, executor, 2000L, true);
        }
        catch (TimeoutException e) {
            executor.shutdownNow();
            try {
                boolean terminated = executor.awaitTermination(1000L, TimeUnit.MILLISECONDS);
                Assert.assertTrue((boolean)terminated);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            Assert.assertEquals((long)2L, (long)RESULT);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    protected class FakeTestCase
    implements Callable<Integer> {
        protected FakeTestCase() {
        }

        @Override
        public Integer call() throws Exception {
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                RESULT = 1;
                return 1;
            }
            while (!Thread.currentThread().isInterrupted()) {
                Thread.yield();
            }
            RESULT = 2;
            return 2;
        }
    }
}

