/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.fm;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import org.evosuite.testcase.fm.EvoInvocationListener;
import org.evosuite.utils.ParameterizedTypeImpl;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Matchers;
import org.mockito.MockSettings;
import org.mockito.Mockito;
import org.mockito.listeners.InvocationListener;

public class EvoInvocationListenerTest {
    @Test
    public void testGenerics() {
        ParameterizedTypeImpl type = new ParameterizedTypeImpl(AGenericClass.class, new Type[]{String.class}, null);
        EvoInvocationListener listener = new EvoInvocationListener((Type)type);
        AGenericClass aGenericClass = (AGenericClass)Mockito.mock(AGenericClass.class, (MockSettings)Mockito.withSettings().invocationListeners(new InvocationListener[]{listener}));
        Mockito.when((Object)aGenericClass.genericAsInput(Matchers.any((Class)((Class)type.getActualTypeArguments()[0])))).thenReturn((Object)true);
        listener.activate();
        boolean b = aGenericClass.genericAsInput("foo");
        Assert.assertTrue((boolean)b);
        List list = listener.getCopyOfMethodDescriptors();
        Assert.assertEquals((long)1L, (long)list.size());
    }

    @Test
    public void testCheckGenericsProperties() throws Exception {
        AGenericClass aGenericClass = (AGenericClass)Mockito.mock(AGenericClass.class);
        Method m = aGenericClass.getClass().getDeclaredMethod("genericAsInput", Object.class);
        Assert.assertEquals((Object)("" + Object.class.toString()), (Object)m.getParameterTypes()[0].toString());
    }

    @Test
    public void testFinal() {
        EvoInvocationListener listener = new EvoInvocationListener(AClassWithFinal.class);
        AClassWithFinal foo = (AClassWithFinal)Mockito.mock(AClassWithFinal.class, (MockSettings)Mockito.withSettings().invocationListeners(new InvocationListener[]{listener}));
        listener.activate();
        foo.getFoo();
        List list = listener.getCopyOfMethodDescriptors();
        Assert.assertEquals((long)0L, (long)list.size());
    }

    @Test
    public void testBase() {
        EvoInvocationListener listener = new EvoInvocationListener(Foo.class);
        Foo foo = (Foo)Mockito.mock(Foo.class, (MockSettings)Mockito.withSettings().invocationListeners(new InvocationListener[]{listener}));
        Mockito.when((Object)foo.parseString((String)Matchers.any())).thenReturn((Object)1);
        Mockito.when((Object)foo.parseString((String)Matchers.any(), Matchers.anyBoolean())).thenReturn((Object)2);
        Mockito.when((Object)foo.parseString((String)Matchers.any(), Matchers.any(Object.class))).thenReturn((Object)3);
        Mockito.when((Object)foo.parseString((String)Matchers.any(), (Foo)ArgumentMatchers.nullable(Foo.class))).thenReturn((Object)4);
        List list = listener.getCopyOfMethodDescriptors();
        Assert.assertEquals((long)0L, (long)list.size());
        listener.activate();
        int res = foo.parseString("foo");
        Assert.assertEquals((long)1L, (long)res);
        res = foo.parseString("bar", true);
        Assert.assertEquals((long)2L, (long)res);
        res = foo.parseString("foo");
        Assert.assertEquals((long)1L, (long)res);
        res = foo.parseString("bar", new Object());
        Assert.assertEquals((long)3L, (long)res);
        res = foo.parseString("bar", foo);
        Assert.assertEquals((long)4L, (long)res);
        res = foo.parseString("bar", null);
        Assert.assertEquals((long)4L, (long)res);
        list = listener.getCopyOfMethodDescriptors();
        Assert.assertEquals((long)4L, (long)list.size());
    }

    public static interface AGenericClass<T> {
        public boolean genericAsInput(T var1);
    }

    public class AClassWithFinal {
        public final boolean getFoo() {
            return true;
        }
    }

    public static interface Foo {
        public int parseString(String var1);

        public int parseString(String var1, boolean var2);

        public int parseString(String var1, Object var2);

        public int parseString(String var1, Foo var2);
    }
}

