/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.fm;

import org.evosuite.testcase.fm.SpecifiedValuesAnswer;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class SpecifiedValuesAnswerTest {
    private static boolean checkString_3different(BaseString s) {
        return s.getString().equals("foo") && s.getString().equals("bar") && s.getString().equals("42");
    }

    private static boolean checkString_allSame(BaseString s) {
        return s.getString().equals("foo") && s.getString().equals("foo") && s.getString().equals("foo");
    }

    @Test
    public void testBasicWithString_3different() {
        BaseString s = (BaseString)Mockito.mock(BaseString.class);
        Mockito.when((Object)s.getString()).thenAnswer((Answer)new SpecifiedValuesAnswer((Object[])new String[]{"foo"}));
        boolean res = SpecifiedValuesAnswerTest.checkString_3different(s);
        Assert.assertFalse((boolean)res);
        Mockito.when((Object)s.getString()).thenAnswer((Answer)new SpecifiedValuesAnswer((Object[])new String[]{"foo", "bar", "42"}));
        res = SpecifiedValuesAnswerTest.checkString_3different(s);
        Assert.assertTrue((boolean)res);
    }

    @Test
    public void testBasicWithString_allSame() {
        BaseString s = (BaseString)Mockito.mock(BaseString.class);
        Mockito.when((Object)s.getString()).thenAnswer((Answer)new SpecifiedValuesAnswer((Object[])new String[]{"bar"}));
        boolean res = SpecifiedValuesAnswerTest.checkString_allSame(s);
        Assert.assertFalse((boolean)res);
        Mockito.when((Object)s.getString()).thenAnswer((Answer)new SpecifiedValuesAnswer((Object[])new String[]{"foo"}));
        res = SpecifiedValuesAnswerTest.checkString_allSame(s);
        Assert.assertTrue((boolean)res);
    }

    private static boolean checkInteger(BaseInteger i) {
        Integer v = i.getInteger();
        return v == 42;
    }

    @Test
    public void testBasicInteger() {
        BaseInteger i = (BaseInteger)Mockito.mock(BaseInteger.class);
        Mockito.when((Object)i.getInteger()).thenAnswer((Answer)new SpecifiedValuesAnswer((Object[])new Integer[]{7}));
        boolean res = SpecifiedValuesAnswerTest.checkInteger(i);
        Assert.assertFalse((boolean)res);
        Mockito.when((Object)i.getInteger()).thenAnswer((Answer)new SpecifiedValuesAnswer((Object[])new Integer[0]));
        res = SpecifiedValuesAnswerTest.checkInteger(i);
        Assert.assertFalse((boolean)res);
        Mockito.when((Object)i.getInteger()).thenAnswer((Answer)new SpecifiedValuesAnswer((Object[])new Integer[]{42}));
        res = SpecifiedValuesAnswerTest.checkInteger(i);
        Assert.assertTrue((boolean)res);
    }

    private static boolean checkInt(BaseInt i) {
        int v = i.getInt();
        return v == 42;
    }

    @Test
    public void testBasicInt() {
        BaseInt i = (BaseInt)Mockito.mock(BaseInt.class);
        Mockito.when((Object)i.getInt()).thenAnswer((Answer)new SpecifiedValuesAnswer((Object[])new Integer[]{7}));
        boolean res = SpecifiedValuesAnswerTest.checkInt(i);
        Assert.assertFalse((boolean)res);
        Mockito.when((Object)i.getInt()).thenAnswer((Answer)new SpecifiedValuesAnswer((Object[])new Integer[0]));
        res = SpecifiedValuesAnswerTest.checkInt(i);
        Assert.assertFalse((boolean)res);
        Mockito.when((Object)i.getInt()).thenAnswer((Answer)new SpecifiedValuesAnswer((Object[])new Integer[]{42}));
        res = SpecifiedValuesAnswerTest.checkInt(i);
        Assert.assertTrue((boolean)res);
    }

    public static interface BaseInt {
        public int getInt();
    }

    public static interface BaseInteger {
        public Integer getInteger();
    }

    public static interface BaseString {
        public String getString();
    }
}

