/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.localsearch;

import com.examples.with.different.packagename.symbolic.Foo;
import java.lang.reflect.Method;
import java.util.Collections;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.ga.localsearch.LocalSearchObjective;
import org.evosuite.symbolic.TestCaseBuilder;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.ExecutableChromosome;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestChromosome;
import org.evosuite.testcase.localsearch.DSETestCaseLocalSearch;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testsuite.AbstractTestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.localsearch.TestSuiteLocalSearchObjective;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestDSETestCaseLocalSearch {
    private static final long DEFAULT_LOCAL_SEARCH_BUDGET = Properties.LOCAL_SEARCH_BUDGET;
    private static final Properties.LocalSearchBudgetType DEFAULT_LOCAL_SEARCH_BUDGET_TYPE = Properties.LOCAL_SEARCH_BUDGET_TYPE;
    private static final Properties.SolverType DEFAULT_DSE_SOLVER = Properties.DSE_SOLVER;

    private static DefaultTestCase buildTestCase0() throws NoSuchMethodException, SecurityException, ClassNotFoundException {
        TestCaseBuilder builder = new TestCaseBuilder();
        VariableReference int0 = builder.appendIntPrimitive(10);
        VariableReference int1 = builder.appendIntPrimitive(10);
        VariableReference int2 = builder.appendIntPrimitive(10);
        Class fooClass = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(Properties.TARGET_CLASS);
        Method barMethod = fooClass.getMethod("bar", Integer.TYPE, Integer.TYPE, Integer.TYPE);
        builder.appendMethod(null, barMethod, int0, int1, int2);
        return builder.getDefaultTestCase();
    }

    @Before
    public void init() {
        ClassPathHandler.getInstance().changeTargetCPtoTheSameAsEvoSuite();
        Properties.LOCAL_SEARCH_BUDGET = Integer.MAX_VALUE;
        Properties.LOCAL_SEARCH_BUDGET_TYPE = Properties.LocalSearchBudgetType.TESTS;
    }

    @After
    public void restoreProperties() {
        Properties.LOCAL_SEARCH_BUDGET = DEFAULT_LOCAL_SEARCH_BUDGET;
        Properties.LOCAL_SEARCH_BUDGET_TYPE = DEFAULT_LOCAL_SEARCH_BUDGET_TYPE;
        Properties.DSE_SOLVER = DEFAULT_DSE_SOLVER;
    }

    @Test
    public void testAVMSolver() throws NoSuchMethodException, SecurityException, ClassNotFoundException {
        Properties.DSE_SOLVER = Properties.SolverType.EVOSUITE_SOLVER;
        Properties.CRITERION = new Properties.Criterion[]{Properties.Criterion.BRANCH};
        Properties.TARGET_CLASS = Foo.class.getName();
        TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(Properties.TARGET_CLASS);
        BranchCoverageSuiteFitness branchCoverageSuiteFitness = new BranchCoverageSuiteFitness();
        TestSuiteChromosome suite = new TestSuiteChromosome();
        suite.addFitness((FitnessFunction)branchCoverageSuiteFitness);
        branchCoverageSuiteFitness.getFitness((AbstractTestSuiteChromosome)suite);
        int coveredGoals0 = suite.getNumOfCoveredGoals();
        int notCoveredGoals0 = suite.getNumOfNotCoveredGoals();
        Assert.assertEquals((long)0L, (long)coveredGoals0);
        Assert.assertNotEquals((long)0L, (long)notCoveredGoals0);
        DefaultTestCase testCase0 = TestDSETestCaseLocalSearch.buildTestCase0();
        TestChromosome testChromosome0 = new TestChromosome();
        testChromosome0.setTestCase((TestCase)testCase0);
        suite.addTest((ExecutableChromosome)testChromosome0);
        double fitnessBeforeLocalSearch = branchCoverageSuiteFitness.getFitness((AbstractTestSuiteChromosome)suite);
        int coveredGoalsBeforeLocalSearch = suite.getNumOfCoveredGoals();
        Assert.assertTrue((coveredGoalsBeforeLocalSearch > 0 ? 1 : 0) != 0);
        DefaultTestCase duplicatedTestCase0 = TestDSETestCaseLocalSearch.buildTestCase0();
        TestChromosome duplicatedTestChromosome0 = new TestChromosome();
        duplicatedTestChromosome0.setTestCase((TestCase)duplicatedTestCase0);
        suite.addTest((ExecutableChromosome)duplicatedTestChromosome0);
        TestSuiteLocalSearchObjective localSearchObjective = TestSuiteLocalSearchObjective.buildNewTestSuiteLocalSearchObjective(Collections.singletonList(branchCoverageSuiteFitness), (TestSuiteChromosome)suite, (int)1);
        DSETestCaseLocalSearch localSearch = new DSETestCaseLocalSearch();
        boolean improved = localSearch.doSearch(duplicatedTestChromosome0, (LocalSearchObjective)localSearchObjective);
        Assert.assertTrue((boolean)improved);
        double fitnessAfterLocalSearch = branchCoverageSuiteFitness.getFitness((AbstractTestSuiteChromosome)suite);
        int coveredGoalsAfterLocalSearch = suite.getNumOfCoveredGoals();
        Assert.assertTrue((fitnessAfterLocalSearch < fitnessBeforeLocalSearch ? 1 : 0) != 0);
        Assert.assertTrue((coveredGoalsAfterLocalSearch > coveredGoalsBeforeLocalSearch ? 1 : 0) != 0);
    }

    @Test
    public void testCVC4Solver() throws NoSuchMethodException, SecurityException, ClassNotFoundException {
        String cvc4_path = System.getenv("cvc4_path");
        if (cvc4_path != null) {
            Properties.CVC4_PATH = cvc4_path;
        }
        Assume.assumeTrue((Properties.CVC4_PATH != null ? 1 : 0) != 0);
        Properties.DSE_SOLVER = Properties.SolverType.CVC4_SOLVER;
        Properties.CRITERION = new Properties.Criterion[]{Properties.Criterion.BRANCH};
        Properties.TARGET_CLASS = Foo.class.getName();
        TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(Properties.TARGET_CLASS);
        BranchCoverageSuiteFitness branchCoverageSuiteFitness = new BranchCoverageSuiteFitness();
        TestSuiteChromosome suite = new TestSuiteChromosome();
        suite.addFitness((FitnessFunction)branchCoverageSuiteFitness);
        branchCoverageSuiteFitness.getFitness((AbstractTestSuiteChromosome)suite);
        int coveredGoals0 = suite.getNumOfCoveredGoals();
        int notCoveredGoals0 = suite.getNumOfNotCoveredGoals();
        Assert.assertEquals((long)0L, (long)coveredGoals0);
        Assert.assertNotEquals((long)0L, (long)notCoveredGoals0);
        DefaultTestCase testCase0 = TestDSETestCaseLocalSearch.buildTestCase0();
        TestChromosome testChromosome0 = new TestChromosome();
        testChromosome0.setTestCase((TestCase)testCase0);
        suite.addTest((ExecutableChromosome)testChromosome0);
        double fitnessBeforeLocalSearch = branchCoverageSuiteFitness.getFitness((AbstractTestSuiteChromosome)suite);
        int coveredGoalsBeforeLocalSearch = suite.getNumOfCoveredGoals();
        Assert.assertTrue((coveredGoalsBeforeLocalSearch > 0 ? 1 : 0) != 0);
        DefaultTestCase duplicatedTestCase0 = TestDSETestCaseLocalSearch.buildTestCase0();
        TestChromosome duplicatedTestChromosome0 = new TestChromosome();
        duplicatedTestChromosome0.setTestCase((TestCase)duplicatedTestCase0);
        suite.addTest((ExecutableChromosome)duplicatedTestChromosome0);
        TestSuiteLocalSearchObjective localSearchObjective = TestSuiteLocalSearchObjective.buildNewTestSuiteLocalSearchObjective(Collections.singletonList(branchCoverageSuiteFitness), (TestSuiteChromosome)suite, (int)1);
        DSETestCaseLocalSearch localSearch = new DSETestCaseLocalSearch();
        boolean improved = localSearch.doSearch(duplicatedTestChromosome0, (LocalSearchObjective)localSearchObjective);
        Assert.assertTrue((boolean)improved);
        double fitnessAfterLocalSearch = branchCoverageSuiteFitness.getFitness((AbstractTestSuiteChromosome)suite);
        int coveredGoalsAfterLocalSearch = suite.getNumOfCoveredGoals();
        Assert.assertTrue((fitnessAfterLocalSearch < fitnessBeforeLocalSearch ? 1 : 0) != 0);
        Assert.assertTrue((coveredGoalsAfterLocalSearch > coveredGoalsBeforeLocalSearch ? 1 : 0) != 0);
    }
}

