/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements;

import com.examples.with.different.packagename.fm.IssueWithNumber;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.evosuite.Properties;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.instrumentation.InstrumentingClassLoader;
import org.evosuite.instrumentation.NonInstrumentingClassLoader;
import org.evosuite.runtime.Runtime;
import org.evosuite.runtime.RuntimeSettings;
import org.evosuite.runtime.instrumentation.EvoClassLoader;
import org.evosuite.runtime.instrumentation.RuntimeInstrumentation;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.execution.Scope;
import org.evosuite.testcase.statements.ArrayStatement;
import org.evosuite.testcase.statements.AssignmentStatement;
import org.evosuite.testcase.statements.FunctionalMockStatement;
import org.evosuite.testcase.statements.MethodStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.StringPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.BooleanPrimitiveStatement;
import org.evosuite.testcase.statements.numeric.IntPrimitiveStatement;
import org.evosuite.testcase.variable.ArrayIndex;
import org.evosuite.testcase.variable.ArrayReference;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testcase.variable.VariableReferenceImpl;
import org.evosuite.utils.generic.GenericMethod;
import org.junit.After;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mockito;

public class FunctionalMockStatementTest {
    private static final int DEFAULT_LIMIT = Properties.FUNCTIONAL_MOCKING_INPUT_LIMIT;

    @After
    public void tearDown() {
        Properties.FUNCTIONAL_MOCKING_INPUT_LIMIT = DEFAULT_LIMIT;
    }

    public static int base(Foo foo) {
        return foo.getInt();
    }

    public static void all_once(Foo foo) {
        foo.getBoolean();
        foo.getInt();
        foo.getDouble();
        foo.getString();
        foo.getLong();
        foo.getObject();
        foo.getStringArray(null);
    }

    public static void all_twice(Foo foo) {
        FunctionalMockStatementTest.all_once(foo);
        FunctionalMockStatementTest.all_once(foo);
    }

    public static String getFirstInArray(Foo foo) {
        int[] anArray = new int[]{123};
        String[] res = foo.getStringArray(anArray);
        if (res == null) {
            return null;
        }
        return res[0];
    }

    public static void limit(Foo foo, int x) {
        for (int i = 0; i < x; ++i) {
            foo.getBoolean();
        }
    }

    private Scope execute(TestCase tc) throws Exception {
        Scope scope = new Scope();
        for (Statement st : tc) {
            st.execute(scope, System.out);
        }
        return scope;
    }

    @Ignore
    @Test
    public void testAClassWithPLMethod() {
        Assert.assertFalse((boolean)FunctionalMockStatement.canBeFunctionalMocked(AClassWithPLMethod.class));
    }

    @Test
    public void testConfirmToString() {
        String res = new OverrideToString().toString();
        String diff = res + " a different string";
        OverrideToString obj = (OverrideToString)Mockito.mock(OverrideToString.class);
        Mockito.when((Object)obj.toString()).thenReturn((Object)diff);
        Assert.assertEquals((Object)diff, (Object)obj.toString());
    }

    @Test
    public void testConfirmToStringAbstract() {
        String diff = " a different string";
        OverrideToStringAbstract obj = (OverrideToStringAbstract)Mockito.mock(OverrideToStringAbstract.class);
        Mockito.when((Object)obj.toString()).thenReturn((Object)diff);
        Assert.assertEquals((Object)diff, (Object)obj.toString());
    }

    @Test
    public void testConfirmNumber() {
        String foo = "foo";
        Number number = (Number)Mockito.mock(Number.class);
        Mockito.when((Object)number.toString()).thenReturn((Object)foo);
        Assert.assertEquals((Object)foo, (Object)number.toString());
    }

    @Test
    public void testConfirmNumberExternalNoMockJVMNonDeterminism() throws Exception {
        RuntimeSettings.mockJVMNonDeterminism = false;
        this.testConfirmNumberExternal();
    }

    @Test
    public void testConfirmNumberExternalWithMockJVMNonDeterminism() throws Exception {
        RuntimeSettings.mockJVMNonDeterminism = true;
        this.testConfirmNumberExternal();
    }

    private void testConfirmNumberExternal() throws Exception {
        Assert.assertEquals((Object)"foo", (Object)IssueWithNumber.getResult());
        RuntimeInstrumentation.setAvoidInstrumentingShadedClasses((boolean)true);
        ClassPathHandler.getInstance().changeTargetCPtoTheSameAsEvoSuite();
        EvoClassLoader loader = new EvoClassLoader();
        loader.skipInstrumentation(IssueWithNumber.class.getName());
        Runtime.getInstance().resetRuntime();
        Class klass = loader.loadClass(IssueWithNumber.class.getName());
        Method m = klass.getDeclaredMethod("getResult", new Class[0]);
        String res = (String)m.invoke(null, new Object[0]);
        Assert.assertEquals((Object)"foo", (Object)res);
    }

    @Test
    public void testConfirmPackageLevel() throws Exception {
        Method m = AClassWithPLMethod.class.getDeclaredMethod("foo", new Class[0]);
        Assert.assertFalse((boolean)Modifier.isPrivate(m.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isPublic(m.getModifiers()));
        Assert.assertFalse((boolean)Modifier.isProtected(m.getModifiers()));
    }

    @Test
    public void testConfirmMockitoBehaviorOnPackageLevelAccess() throws Exception {
        AClassWithPLMethod original = new AClassWithPLMethod();
        Assert.assertNotNull((Object)original.foo());
        AClassWithPLMethod mocked = (AClassWithPLMethod)Mockito.mock(AClassWithPLMethod.class);
        Assert.assertNull((Object)mocked.foo());
        Method m = AClassWithPLMethod.class.getDeclaredMethod("foo", new Class[0]);
        m.setAccessible(true);
        Assert.assertNotNull((Object)m.invoke((Object)original, new Object[0]));
        Assert.assertNull((Object)m.invoke((Object)mocked, new Object[0]));
    }

    @Test
    public void testConfirmCast() {
        char c;
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Integer.class, Integer.TYPE));
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Integer.TYPE, Integer.class));
        Assert.assertFalse((boolean)Integer.TYPE.isAssignableFrom(Integer.class));
        Assert.assertFalse((boolean)Integer.class.isAssignableFrom(Integer.TYPE));
        Assert.assertFalse((boolean)Integer.TYPE.isAssignableFrom(Character.TYPE));
        Assert.assertFalse((boolean)TypeUtils.isAssignable(Integer.TYPE, Character.TYPE));
        Assert.assertFalse((boolean)Character.TYPE.isAssignableFrom(Integer.TYPE));
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Character.TYPE, Integer.TYPE));
        Assert.assertFalse((boolean)Character.class.isAssignableFrom(Integer.TYPE));
        Assert.assertTrue((boolean)TypeUtils.isAssignable(Character.class, Integer.TYPE));
        Assert.assertFalse((boolean)Character.class.isAssignableFrom(Integer.class));
        Assert.assertFalse((boolean)TypeUtils.isAssignable(Character.class, Integer.class));
        Assert.assertTrue((boolean)Integer.TYPE.isPrimitive());
        Assert.assertFalse((boolean)Integer.class.isPrimitive());
        char i = c = 'c';
        Assert.assertEquals((long)99L, (long)i);
        Integer aInt = i;
        Integer aInteger = 7;
        Assert.assertTrue((boolean)aInt.getClass().equals(Integer.class));
        Assert.assertTrue((boolean)aInt.getClass().equals(aInteger.getClass()));
        Character aChar = Character.valueOf(c);
        Assert.assertTrue((boolean)aChar.getClass().equals(Character.class));
        Assert.assertTrue((boolean)TypeUtils.isAssignable(aChar.getClass(), Integer.TYPE));
        Assert.assertFalse((boolean)Integer.TYPE.isAssignableFrom(aChar.getClass()));
        Integer casted = null;
        try {
            casted = Integer.TYPE.cast(aChar);
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            casted = Integer.TYPE.cast(Character.valueOf(aChar.charValue()));
            Assert.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
        casted = aChar.charValue();
        Assert.assertTrue((boolean)casted.getClass().equals(Integer.class));
    }

    @Test
    public void testAvoidMockingEnvironment() {
        boolean defaultValue = RuntimeSettings.useVFS;
        RuntimeSettings.useVFS = true;
        try {
            Assert.assertFalse((boolean)FunctionalMockStatement.canBeFunctionalMocked(File.class));
        }
        catch (Throwable t) {
            RuntimeSettings.useVFS = defaultValue;
        }
    }

    @Test
    public void testPackageLevel_local() throws Exception {
        DefaultTestCase tc = new DefaultTestCase();
        VariableReferenceImpl ref = new VariableReferenceImpl((TestCase)tc, PackageLevel.class);
        try {
            FunctionalMockStatement mockStmt = new FunctionalMockStatement((TestCase)tc, (VariableReference)ref, PackageLevel.class);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPackageLevel_differentPackage() throws Exception {
        DefaultTestCase tc = new DefaultTestCase();
        Class<?> example = Class.forName("com.examples.with.different.packagename.fm.ExamplePackageLevel");
        VariableReferenceImpl ref = new VariableReferenceImpl((TestCase)tc, example);
        try {
            FunctionalMockStatement mockStmt = new FunctionalMockStatement((TestCase)tc, (VariableReference)ref, example);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPackageLevel_differentPackage_instrumentation_package() throws Exception {
        DefaultTestCase tc = new DefaultTestCase();
        ClassPathHandler.getInstance().changeTargetCPtoTheSameAsEvoSuite();
        InstrumentingClassLoader loader = new InstrumentingClassLoader();
        Class example = loader.loadClass("com.examples.with.different.packagename.fm.ExamplePackageLevel");
        VariableReferenceImpl ref = new VariableReferenceImpl((TestCase)tc, (Type)example);
        try {
            FunctionalMockStatement mockStmt = new FunctionalMockStatement((TestCase)tc, (VariableReference)ref, example);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPackageLevel_differentPackage_nonInstrumentation_package() throws Exception {
        DefaultTestCase tc = new DefaultTestCase();
        ClassPathHandler.getInstance().changeTargetCPtoTheSameAsEvoSuite();
        NonInstrumentingClassLoader loader = new NonInstrumentingClassLoader();
        Class example = loader.loadClass("com.examples.with.different.packagename.fm.ExamplePackageLevel");
        VariableReferenceImpl ref = new VariableReferenceImpl((TestCase)tc, (Type)example);
        try {
            FunctionalMockStatement mockStmt = new FunctionalMockStatement((TestCase)tc, (VariableReference)ref, example);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPackageLevel_differentPackage_instrumentation_public() throws Exception {
        DefaultTestCase tc = new DefaultTestCase();
        RuntimeInstrumentation.setAvoidInstrumentingShadedClasses((boolean)true);
        ClassPathHandler.getInstance().changeTargetCPtoTheSameAsEvoSuite();
        InstrumentingClassLoader loader = new InstrumentingClassLoader();
        Class example = loader.loadClass("com.examples.with.different.packagename.fm.ExamplePublicLevel");
        VariableReferenceImpl ref = new VariableReferenceImpl((TestCase)tc, (Type)example);
        FunctionalMockStatement mockStmt = new FunctionalMockStatement((TestCase)tc, (VariableReference)ref, example);
        tc.addStatement((Statement)mockStmt);
        this.execute((TestCase)tc);
    }

    @Test
    public void testLimit() throws Exception {
        DefaultTestCase tc = new DefaultTestCase();
        int LIMIT_5 = 5;
        Properties.FUNCTIONAL_MOCKING_INPUT_LIMIT = 5;
        boolean LOOP_0 = false;
        int LOOP_3 = 3;
        int LOOP_5 = 5;
        int LOOP_7 = 7;
        IntPrimitiveStatement x = new IntPrimitiveStatement((TestCase)tc, Integer.valueOf(3));
        VariableReference loop = tc.addStatement((Statement)x);
        VariableReference boolRef = tc.addStatement((Statement)new BooleanPrimitiveStatement((TestCase)tc, Boolean.valueOf(true)));
        VariableReferenceImpl ref = new VariableReferenceImpl((TestCase)tc, Foo.class);
        FunctionalMockStatement mockStmt = new FunctionalMockStatement((TestCase)tc, (VariableReference)ref, Foo.class);
        VariableReference mock = tc.addStatement((Statement)mockStmt);
        tc.addStatement((Statement)new MethodStatement((TestCase)tc, new GenericMethod(this.getClass().getDeclaredMethod("limit", Foo.class, Integer.TYPE), FunctionalMockStatementTest.class), null, Arrays.asList(mock, loop)));
        this.execute((TestCase)tc);
        Assert.assertTrue((boolean)mockStmt.doesNeedToUpdateInputs());
        List types = mockStmt.updateMockedMethods();
        Assert.assertEquals((long)3L, (long)types.size());
        for (Type t : types) {
            Assert.assertEquals(Boolean.TYPE, (Object)t);
        }
        mockStmt.addMissingInputs(Arrays.asList(boolRef, boolRef, boolRef));
        x.setValue((Object)5);
        this.execute((TestCase)tc);
        Assert.assertTrue((boolean)mockStmt.doesNeedToUpdateInputs());
        types = mockStmt.updateMockedMethods();
        Assert.assertEquals((long)2L, (long)types.size());
        for (Type t : types) {
            Assert.assertEquals(Boolean.TYPE, (Object)t);
        }
        mockStmt.addMissingInputs(Arrays.asList(boolRef, boolRef));
        Assert.assertEquals((long)5L, (long)mockStmt.getNumParameters());
        x.setValue((Object)7);
        this.execute((TestCase)tc);
        Assert.assertFalse((boolean)mockStmt.doesNeedToUpdateInputs());
        types = mockStmt.updateMockedMethods();
        Assert.assertEquals((long)0L, (long)types.size());
        Assert.assertEquals((long)5L, (long)mockStmt.getNumParameters());
        x.setValue((Object)5);
        this.execute((TestCase)tc);
        Assert.assertFalse((boolean)mockStmt.doesNeedToUpdateInputs());
        types = mockStmt.updateMockedMethods();
        Assert.assertEquals((long)0L, (long)types.size());
        Assert.assertEquals((long)5L, (long)mockStmt.getNumParameters());
        x.setValue((Object)3);
        this.execute((TestCase)tc);
        Assert.assertTrue((boolean)mockStmt.doesNeedToUpdateInputs());
        types = mockStmt.updateMockedMethods();
        Assert.assertEquals((long)0L, (long)types.size());
        Assert.assertEquals((long)3L, (long)mockStmt.getNumParameters());
        x.setValue((Object)0);
        this.execute((TestCase)tc);
        Assert.assertTrue((boolean)mockStmt.doesNeedToUpdateInputs());
        types = mockStmt.updateMockedMethods();
        Assert.assertEquals((long)0L, (long)types.size());
        Assert.assertEquals((long)0L, (long)mockStmt.getNumParameters());
    }

    @Test
    public void testAll_once() throws Exception {
        DefaultTestCase tc = new DefaultTestCase();
        VariableReferenceImpl ref = new VariableReferenceImpl((TestCase)tc, Foo.class);
        FunctionalMockStatement mockStmt = new FunctionalMockStatement((TestCase)tc, (VariableReference)ref, Foo.class);
        VariableReference mock = tc.addStatement((Statement)mockStmt);
        VariableReference result = tc.addStatement((Statement)new MethodStatement((TestCase)tc, new GenericMethod(this.getClass().getDeclaredMethod("all_once", Foo.class), FunctionalMockStatementTest.class), null, Arrays.asList(mock)));
        Assert.assertFalse((boolean)mockStmt.doesNeedToUpdateInputs());
        Assert.assertEquals((long)0L, (long)mockStmt.getNumParameters());
        Scope scope = this.execute((TestCase)tc);
        Assert.assertTrue((boolean)mockStmt.doesNeedToUpdateInputs());
        List types = mockStmt.updateMockedMethods();
        Assert.assertEquals((long)7L, (long)types.size());
    }

    @Test
    public void testAll_twice() throws Exception {
        DefaultTestCase tc = new DefaultTestCase();
        VariableReferenceImpl ref = new VariableReferenceImpl((TestCase)tc, Foo.class);
        FunctionalMockStatement mockStmt = new FunctionalMockStatement((TestCase)tc, (VariableReference)ref, Foo.class);
        VariableReference mock = tc.addStatement((Statement)mockStmt);
        VariableReference result = tc.addStatement((Statement)new MethodStatement((TestCase)tc, new GenericMethod(this.getClass().getDeclaredMethod("all_twice", Foo.class), FunctionalMockStatementTest.class), null, Arrays.asList(mock)));
        Assert.assertFalse((boolean)mockStmt.doesNeedToUpdateInputs());
        Assert.assertEquals((long)0L, (long)mockStmt.getNumParameters());
        Scope scope = this.execute((TestCase)tc);
        Assert.assertTrue((boolean)mockStmt.doesNeedToUpdateInputs());
        List types = mockStmt.updateMockedMethods();
        Assert.assertEquals((long)14L, (long)types.size());
    }

    @Test
    public void testArray() throws Exception {
        DefaultTestCase tc = new DefaultTestCase();
        String MOCKED_VALUE = "Hello 42!!!";
        VariableReference aString = tc.addStatement((Statement)new StringPrimitiveStatement((TestCase)tc, "Hello 42!!!"));
        ArrayReference mockedArray = (ArrayReference)tc.addStatement((Statement)new ArrayStatement((TestCase)tc, String[].class, 1));
        ArrayIndex arrayIndex = new ArrayIndex((TestCase)tc, mockedArray, 0);
        AssignmentStatement stmt = new AssignmentStatement((TestCase)tc, (VariableReference)arrayIndex, aString);
        tc.addStatement((Statement)stmt);
        FunctionalMockStatement mockStmt = new FunctionalMockStatement((TestCase)tc, Foo.class, Foo.class);
        VariableReference mock = tc.addStatement((Statement)mockStmt);
        VariableReference result = tc.addStatement((Statement)new MethodStatement((TestCase)tc, new GenericMethod(this.getClass().getDeclaredMethod("getFirstInArray", Foo.class), FunctionalMockStatementTest.class), null, Arrays.asList(mock)));
        Assert.assertFalse((boolean)mockStmt.doesNeedToUpdateInputs());
        Assert.assertEquals((long)0L, (long)mockStmt.getNumParameters());
        Scope scope = this.execute((TestCase)tc);
        Object obj = scope.getObject(result);
        Assert.assertNull((Object)obj);
        Assert.assertTrue((boolean)mockStmt.doesNeedToUpdateInputs());
        List types = mockStmt.updateMockedMethods();
        Assert.assertEquals((long)1L, (long)types.size());
        Assert.assertEquals(String[].class, types.get(0));
        mockStmt.addMissingInputs(Arrays.asList(mockedArray));
        Assert.assertEquals((long)1L, (long)mockStmt.getNumParameters());
        Assert.assertTrue((boolean)((VariableReference)mockStmt.getParameterReferences().get(0)).same((VariableReference)mockedArray));
        scope = this.execute((TestCase)tc);
        String val = (String)scope.getObject(result);
        Assert.assertEquals((Object)"Hello 42!!!", (Object)val);
    }

    @Test
    public void testBase() throws Exception {
        DefaultTestCase tc = new DefaultTestCase();
        int MOCKED_VALUE = 42;
        VariableReference mockedInput = tc.addStatement((Statement)new IntPrimitiveStatement((TestCase)tc, Integer.valueOf(42)));
        VariableReferenceImpl ref = new VariableReferenceImpl((TestCase)tc, Foo.class);
        FunctionalMockStatement mockStmt = new FunctionalMockStatement((TestCase)tc, (VariableReference)ref, Foo.class);
        VariableReference mock = tc.addStatement((Statement)mockStmt);
        VariableReference result = tc.addStatement((Statement)new MethodStatement((TestCase)tc, new GenericMethod(this.getClass().getDeclaredMethod("base", Foo.class), FunctionalMockStatementTest.class), null, Arrays.asList(mock)));
        Assert.assertFalse((boolean)mockStmt.doesNeedToUpdateInputs());
        Assert.assertEquals((long)0L, (long)mockStmt.getNumParameters());
        Scope scope = this.execute((TestCase)tc);
        Integer val = (Integer)scope.getObject(result);
        Assert.assertEquals((long)0L, (long)val.intValue());
        Assert.assertTrue((boolean)mockStmt.doesNeedToUpdateInputs());
        List types = mockStmt.updateMockedMethods();
        Assert.assertEquals((long)1L, (long)types.size());
        Assert.assertEquals(Integer.TYPE, types.get(0));
        mockStmt.addMissingInputs(Arrays.asList(mockedInput));
        Assert.assertEquals((long)1L, (long)mockStmt.getNumParameters());
        Assert.assertTrue((boolean)((VariableReference)mockStmt.getParameterReferences().get(0)).same(mockedInput));
        scope = new Scope();
        for (Statement st : tc) {
            st.execute(scope, System.out);
        }
        val = (Integer)scope.getObject(result);
        Assert.assertEquals((long)42L, (long)val.intValue());
    }

    public static abstract class OverrideToStringAbstract
    implements Serializable {
        private static final long serialVersionUID = -8742448824652078965L;

        public String toString() {
            return "foo";
        }

        public abstract double foo();

        public int bar() {
            return 1;
        }
    }

    public static class OverrideToString {
        public String toString() {
            return "foo";
        }
    }

    public static class AClassWithPLMethod {
        String foo() {
            return "Value returned by package-level access method";
        }
    }

    static class PackageLevel {
        PackageLevel() {
        }
    }

    public static interface Foo {
        public boolean getBoolean();

        public int getInt();

        public double getDouble();

        public String getString();

        public long getLong();

        public Object getObject();

        public String[] getStringArray(int[] var1);
    }
}

