/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testcase.statements.reflection;

import java.lang.reflect.Field;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.evosuite.Properties;
import org.evosuite.runtime.javaee.injection.Injector;
import org.evosuite.testcase.statements.reflection.ReflectionFactory;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class ReflectionFactoryTest {
    private static final boolean DEFALUT_JEE = Properties.JEE;

    @After
    public void tearDown() {
        Properties.JEE = DEFALUT_JEE;
    }

    @Test
    public void testGetNumberOfUsableFields() throws Exception {
        Properties.JEE = false;
        Injector.reset();
        ReflectionFactory rf = new ReflectionFactory(Foo.class);
        Assert.assertEquals((long)2L, (long)rf.getNumberOfUsableFields());
        Assert.assertEquals((long)1L, (long)Injector.getAllFieldsToInject(Foo.class).size());
        Assert.assertTrue((boolean)Injector.hasEntityManager(Foo.class));
        Properties.JEE = true;
        Injector.reset();
        rf = new ReflectionFactory(Foo.class);
        Assert.assertEquals((long)1L, (long)rf.getNumberOfUsableFields());
        Assert.assertEquals((long)1L, (long)Injector.getAllFieldsToInject(Foo.class).size());
        Assert.assertTrue((boolean)Injector.hasEntityManager(Foo.class));
        Field f = rf.nextField();
        Assert.assertEquals((Object)Foo.class.getDeclaredField("x"), (Object)f);
    }

    public static class Foo {
        private int x;
        public double p;
        @PersistenceContext
        private EntityManager em;
    }
}

