/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.testsuite;

import com.examples.with.different.packagename.FlagExample1;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.evosuite.Properties;
import org.evosuite.TestGenerationContext;
import org.evosuite.classpath.ClassPathHandler;
import org.evosuite.coverage.TestFitnessFactory;
import org.evosuite.coverage.branch.BranchCoverageFactory;
import org.evosuite.coverage.branch.BranchCoverageSuiteFitness;
import org.evosuite.coverage.dataflow.DefUseCoverageFactory;
import org.evosuite.coverage.dataflow.DefUseCoverageSuiteFitness;
import org.evosuite.ga.Chromosome;
import org.evosuite.ga.ConstructionFailedException;
import org.evosuite.ga.FitnessFunction;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.TestFactory;
import org.evosuite.testcase.execution.reset.ClassReInitializer;
import org.evosuite.testcase.statements.ConstructorStatement;
import org.evosuite.testcase.statements.Statement;
import org.evosuite.testcase.statements.numeric.IntPrimitiveStatement;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testsuite.TestSuiteChromosome;
import org.evosuite.testsuite.TestSuiteMinimizer;
import org.evosuite.utils.Randomness;
import org.evosuite.utils.generic.GenericClass;
import org.evosuite.utils.generic.GenericConstructor;
import org.evosuite.utils.generic.GenericMethod;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestTestSuiteMinimizer {
    private static java.util.Properties currentProperties;

    @Before
    public void setUp() {
        ClassPathHandler.getInstance().changeTargetCPtoTheSameAsEvoSuite();
        Properties.getInstance().resetToDefaults();
        Randomness.setSeed((long)42L);
        Properties.TARGET_CLASS = "";
        TestGenerationContext.getInstance().resetContext();
        ClassReInitializer.resetSingleton();
        Randomness.setSeed((long)42L);
        currentProperties = (java.util.Properties)System.getProperties().clone();
    }

    @After
    public void tearDown() {
        TestGenerationContext.getInstance().resetContext();
        System.setProperties(currentProperties);
        Properties.getInstance().resetToDefaults();
    }

    @Test
    public void minimizeEmptySuite() throws ClassNotFoundException {
        DefaultTestCase test = new DefaultTestCase();
        TestSuiteChromosome tsc = new TestSuiteChromosome();
        tsc.addTest((TestCase)test);
        BranchCoverageSuiteFitness ff = new BranchCoverageSuiteFitness();
        double previous_fitness = ff.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)ff, previous_fitness);
        Assert.assertEquals((double)previous_fitness, (double)0.0, (double)0.0);
        TestSuiteMinimizer minimizer = new TestSuiteMinimizer((TestFitnessFactory)new BranchCoverageFactory());
        minimizer.minimize(tsc, false);
        Assert.assertEquals((long)0L, (long)tsc.getTests().size());
        double fitness = ff.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_fitness, (double)fitness, (double)0.0);
    }

    @Test
    public void minimizeSuiteOnlyWithVariables() {
        DefaultTestCase test = new DefaultTestCase();
        for (int i = 0; i < 10; ++i) {
            IntPrimitiveStatement ips = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(i));
            test.addStatement((Statement)ips);
        }
        Assert.assertEquals((long)10L, (long)test.size());
        TestSuiteChromosome tsc = new TestSuiteChromosome();
        tsc.addTest((TestCase)test);
        BranchCoverageSuiteFitness ff = new BranchCoverageSuiteFitness();
        double previous_fitness = ff.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)ff, previous_fitness);
        Assert.assertEquals((double)previous_fitness, (double)0.0, (double)0.0);
        TestSuiteMinimizer minimizer = new TestSuiteMinimizer((TestFitnessFactory)new BranchCoverageFactory());
        minimizer.minimize(tsc, false);
        Assert.assertEquals((long)0L, (long)tsc.getTests().size());
        double fitness = ff.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_fitness, (double)fitness, (double)0.0);
    }

    @Test
    public void minimizeSuiteHalfCoverage() throws ClassNotFoundException, NoSuchFieldException, SecurityException, ConstructionFailedException, NoSuchMethodException {
        Properties.TARGET_CLASS = FlagExample1.class.getCanonicalName();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(Properties.TARGET_CLASS);
        GenericClass clazz = new GenericClass(sut);
        DefaultTestCase test = new DefaultTestCase();
        GenericConstructor gc = new GenericConstructor(clazz.getRawClass().getConstructors()[0], clazz);
        TestFactory testFactory = TestFactory.getInstance();
        testFactory.addConstructor((TestCase)test, gc, 0, 0);
        ArrayList parameters = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            IntPrimitiveStatement ips = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(28234 + i));
            VariableReference variableReference = test.addStatement((Statement)ips, i + 1);
        }
        ConstructorStatement ct = new ConstructorStatement((TestCase)test, gc, parameters);
        Method m = clazz.getRawClass().getMethod("testMe", Integer.TYPE);
        GenericMethod method = new GenericMethod(m, sut);
        testFactory.addMethod((TestCase)test, method, 11, 0);
        Assert.assertEquals((long)12L, (long)test.size());
        TestSuiteChromosome tsc = new TestSuiteChromosome();
        tsc.addTest((TestCase)test);
        BranchCoverageSuiteFitness ff = new BranchCoverageSuiteFitness();
        double previous_fitness = ff.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)ff, previous_fitness);
        Assert.assertEquals((double)previous_fitness, (double)2.0, (double)0.0);
        TestSuiteMinimizer minimizer = new TestSuiteMinimizer((TestFitnessFactory)new BranchCoverageFactory());
        minimizer.minimize(tsc, false);
        Assert.assertEquals((long)1L, (long)tsc.getTests().size());
        Assert.assertEquals((long)3L, (long)((TestCase)tsc.getTests().get(0)).size());
        double fitness = ff.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_fitness, (double)fitness, (double)0.0);
    }

    @Test
    public void minimizeSuiteHalfCoverageWithTwoFitnessFunctions() throws ClassNotFoundException, ConstructionFailedException, NoSuchMethodException, SecurityException {
        Properties.TARGET_CLASS = FlagExample1.class.getCanonicalName();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(Properties.TARGET_CLASS);
        GenericClass clazz = new GenericClass(sut);
        DefaultTestCase test = new DefaultTestCase();
        GenericConstructor gc = new GenericConstructor(clazz.getRawClass().getConstructors()[0], clazz);
        TestFactory testFactory = TestFactory.getInstance();
        testFactory.addConstructor((TestCase)test, gc, 0, 0);
        ArrayList parameters = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            IntPrimitiveStatement ips = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(28234 + i));
            VariableReference variableReference = test.addStatement((Statement)ips, i + 1);
        }
        ConstructorStatement ct = new ConstructorStatement((TestCase)test, gc, parameters);
        Method m = clazz.getRawClass().getMethod("testMe", Integer.TYPE);
        GenericMethod method = new GenericMethod(m, sut);
        testFactory.addMethod((TestCase)test, method, 11, 0);
        Assert.assertEquals((long)12L, (long)test.size());
        TestSuiteChromosome tsc = new TestSuiteChromosome();
        tsc.addTest((TestCase)test);
        BranchCoverageSuiteFitness branch = new BranchCoverageSuiteFitness();
        double previous_branch_fitness = branch.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)branch, previous_branch_fitness);
        Assert.assertEquals((double)previous_branch_fitness, (double)2.0, (double)0.0);
        DefUseCoverageSuiteFitness defuse = new DefUseCoverageSuiteFitness();
        double previous_defuse_fitness = defuse.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)defuse, previous_defuse_fitness);
        Assert.assertEquals((double)previous_defuse_fitness, (double)0.0, (double)0.0);
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new BranchCoverageFactory());
        factories.add(new DefUseCoverageFactory());
        TestSuiteMinimizer minimizer = new TestSuiteMinimizer(factories);
        minimizer.minimize(tsc, false);
        Assert.assertEquals((long)1L, (long)tsc.getTests().size());
        Assert.assertEquals((long)3L, (long)((TestCase)tsc.getTests().get(0)).size());
        double branch_fitness = branch.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_branch_fitness, (double)branch_fitness, (double)0.0);
        double defuse_fitness = defuse.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_defuse_fitness, (double)defuse_fitness, (double)0.0);
    }

    @Test
    public void minimizeSuiteFullCoverage() throws ClassNotFoundException, NoSuchFieldException, SecurityException, ConstructionFailedException, NoSuchMethodException {
        Properties.TARGET_CLASS = FlagExample1.class.getCanonicalName();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(Properties.TARGET_CLASS);
        GenericClass clazz = new GenericClass(sut);
        DefaultTestCase test = new DefaultTestCase();
        GenericConstructor gc = new GenericConstructor(clazz.getRawClass().getConstructors()[0], clazz);
        TestFactory testFactory = TestFactory.getInstance();
        testFactory.addConstructor((TestCase)test, gc, 0, 0);
        ArrayList parameters = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            IntPrimitiveStatement ips = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(28234 + i));
            VariableReference variableReference = test.addStatement((Statement)ips, i + 1);
        }
        ConstructorStatement ct = new ConstructorStatement((TestCase)test, gc, parameters);
        Method m = clazz.getRawClass().getMethod("testMe", Integer.TYPE);
        GenericMethod method = new GenericMethod(m, sut);
        testFactory.addMethod((TestCase)test, method, 11, 0);
        parameters = new ArrayList();
        for (int i = 12; i < 15; ++i) {
            IntPrimitiveStatement ips = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(i));
            VariableReference variableReference = test.addStatement((Statement)ips, i);
        }
        ct = new ConstructorStatement((TestCase)test, gc, parameters);
        testFactory.addMethod((TestCase)test, method, 15, 0);
        Assert.assertEquals((long)16L, (long)test.size());
        TestSuiteChromosome tsc = new TestSuiteChromosome();
        tsc.addTest((TestCase)test);
        BranchCoverageSuiteFitness ff = new BranchCoverageSuiteFitness();
        double previous_fitness = ff.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)ff, previous_fitness);
        Assert.assertEquals((double)previous_fitness, (double)0.0, (double)0.0);
        TestSuiteMinimizer minimizer = new TestSuiteMinimizer((TestFitnessFactory)new BranchCoverageFactory());
        minimizer.minimize(tsc, false);
        Assert.assertEquals((long)1L, (long)tsc.getTests().size());
        Assert.assertEquals((long)5L, (long)((TestCase)tsc.getTests().get(0)).size());
        double fitness = ff.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_fitness, (double)fitness, (double)0.0);
    }

    @Test
    public void minimizeSuiteFullCoverageWithTwoFitnessFunctions() throws ClassNotFoundException, NoSuchFieldException, SecurityException, ConstructionFailedException, NoSuchMethodException {
        Properties.TARGET_CLASS = FlagExample1.class.getCanonicalName();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(Properties.TARGET_CLASS);
        GenericClass clazz = new GenericClass(sut);
        DefaultTestCase test = new DefaultTestCase();
        GenericConstructor gc = new GenericConstructor(clazz.getRawClass().getConstructors()[0], clazz);
        TestFactory testFactory = TestFactory.getInstance();
        testFactory.addConstructor((TestCase)test, gc, 0, 0);
        ArrayList parameters = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            IntPrimitiveStatement ips = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(28234 + i));
            VariableReference variableReference = test.addStatement((Statement)ips, i + 1);
        }
        ConstructorStatement ct = new ConstructorStatement((TestCase)test, gc, parameters);
        Method m = clazz.getRawClass().getMethod("testMe", Integer.TYPE);
        GenericMethod method = new GenericMethod(m, sut);
        testFactory.addMethod((TestCase)test, method, 11, 0);
        parameters = new ArrayList();
        for (int i = 12; i < 15; ++i) {
            IntPrimitiveStatement ips = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(i));
            VariableReference variableReference = test.addStatement((Statement)ips, i);
        }
        ct = new ConstructorStatement((TestCase)test, gc, parameters);
        testFactory.addMethod((TestCase)test, method, 15, 0);
        Assert.assertEquals((long)16L, (long)test.size());
        TestSuiteChromosome tsc = new TestSuiteChromosome();
        tsc.addTest((TestCase)test);
        BranchCoverageSuiteFitness branch = new BranchCoverageSuiteFitness();
        double previous_branch_fitness = branch.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)branch, previous_branch_fitness);
        Assert.assertEquals((double)previous_branch_fitness, (double)0.0, (double)0.0);
        DefUseCoverageSuiteFitness defuse = new DefUseCoverageSuiteFitness();
        double previous_defuse_fitness = defuse.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)defuse, previous_defuse_fitness);
        Assert.assertEquals((double)previous_defuse_fitness, (double)0.0, (double)0.0);
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new BranchCoverageFactory());
        factories.add(new DefUseCoverageFactory());
        TestSuiteMinimizer minimizer = new TestSuiteMinimizer(factories);
        minimizer.minimize(tsc, false);
        Assert.assertEquals((long)1L, (long)tsc.getTests().size());
        Assert.assertEquals((long)5L, (long)((TestCase)tsc.getTests().get(0)).size());
        double branch_fitness = branch.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_branch_fitness, (double)branch_fitness, (double)0.0);
        double defuse_fitness = defuse.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_defuse_fitness, (double)defuse_fitness, (double)0.0);
    }

    @Test
    public void minimizeSuiteFullCoverageWithTwoFitnessFunctionsMinimizeTestsEnabled() throws ClassNotFoundException, NoSuchFieldException, SecurityException, ConstructionFailedException, NoSuchMethodException {
        Properties.TARGET_CLASS = FlagExample1.class.getCanonicalName();
        Class sut = TestGenerationContext.getInstance().getClassLoaderForSUT().loadClass(Properties.TARGET_CLASS);
        GenericClass clazz = new GenericClass(sut);
        DefaultTestCase test = new DefaultTestCase();
        GenericConstructor gc = new GenericConstructor(clazz.getRawClass().getConstructors()[0], clazz);
        TestFactory testFactory = TestFactory.getInstance();
        testFactory.addConstructor((TestCase)test, gc, 0, 0);
        ArrayList parameters = new ArrayList();
        for (int i = 0; i < 10; ++i) {
            IntPrimitiveStatement ips = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(28234 + i));
            VariableReference variableReference = test.addStatement((Statement)ips, i + 1);
        }
        ConstructorStatement ct = new ConstructorStatement((TestCase)test, gc, parameters);
        Method m = clazz.getRawClass().getMethod("testMe", Integer.TYPE);
        GenericMethod method = new GenericMethod(m, sut);
        testFactory.addMethod((TestCase)test, method, 11, 0);
        parameters = new ArrayList();
        for (int i = 12; i < 15; ++i) {
            IntPrimitiveStatement ips = new IntPrimitiveStatement((TestCase)test, Integer.valueOf(i));
            VariableReference variableReference = test.addStatement((Statement)ips, i);
        }
        ct = new ConstructorStatement((TestCase)test, gc, parameters);
        testFactory.addMethod((TestCase)test, method, 15, 0);
        Assert.assertEquals((long)16L, (long)test.size());
        TestSuiteChromosome tsc = new TestSuiteChromosome();
        tsc.addTest((TestCase)test);
        BranchCoverageSuiteFitness branch = new BranchCoverageSuiteFitness();
        double previous_branch_fitness = branch.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)branch, previous_branch_fitness);
        Assert.assertEquals((double)previous_branch_fitness, (double)0.0, (double)0.0);
        DefUseCoverageSuiteFitness defuse = new DefUseCoverageSuiteFitness();
        double previous_defuse_fitness = defuse.getFitness((Chromosome)tsc);
        tsc.setFitness((FitnessFunction)defuse, previous_defuse_fitness);
        Assert.assertEquals((double)previous_defuse_fitness, (double)0.0, (double)0.0);
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new BranchCoverageFactory());
        factories.add(new DefUseCoverageFactory());
        TestSuiteMinimizer minimizer = new TestSuiteMinimizer(factories);
        minimizer.minimize(tsc, true);
        Assert.assertEquals((long)2L, (long)tsc.getTests().size());
        Assert.assertEquals((long)3L, (long)((TestCase)tsc.getTests().get(0)).size());
        Assert.assertEquals((long)3L, (long)((TestCase)tsc.getTests().get(1)).size());
        double branch_fitness = branch.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_branch_fitness, (double)branch_fitness, (double)0.0);
        double defuse_fitness = defuse.getFitness((Chromosome)tsc);
        Assert.assertEquals((double)previous_defuse_fitness, (double)defuse_fitness, (double)0.0);
    }
}

