/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.util.HashMap;
import java.util.Map;
import org.evosuite.Properties;
import org.evosuite.instrumentation.testability.TestabilityTransformationClassLoader;
import org.evosuite.testcase.execution.ExecutionTracer;

public class ClassTransformer {
    private static ClassTransformer instance = new ClassTransformer();
    private final Map<String, Class<?>> instrumentedClasses = new HashMap();

    public static ClassTransformer getInstance() {
        return instance;
    }

    private ClassTransformer() {
    }

    public Class<?> instrumentClass(String fullyQualifiedTargetClass) {
        Class<?> result = this.instrumentedClasses.get(fullyQualifiedTargetClass);
        if (result != null) {
            assert (Properties.TARGET_CLASS.equals(fullyQualifiedTargetClass));
            assert (Properties.PROJECT_PREFIX.equals(fullyQualifiedTargetClass));
            return result;
        }
        try {
            Properties.TARGET_CLASS = fullyQualifiedTargetClass;
            Properties.PROJECT_PREFIX = fullyQualifiedTargetClass;
            ExecutionTracer.enable();
            TestabilityTransformationClassLoader classLoader = new TestabilityTransformationClassLoader();
            result = ((ClassLoader)classLoader).loadClass(fullyQualifiedTargetClass);
            this.instrumentedClasses.put(fullyQualifiedTargetClass, result);
            return result;
        }
        catch (ClassNotFoundException exc) {
            throw new RuntimeException(exc);
        }
    }
}

