/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.util.Scanner;
import org.evosuite.utils.FileIOUtils;
import org.junit.Assert;
import org.junit.Test;

public class FileIOUtilsTest {
    @Test
    public void testCopyDirectoryAndOverwriteFilesIfNeeded() throws Exception {
        File tmpRoot = File.createTempFile("foo" + System.currentTimeMillis(), "");
        tmpRoot.delete();
        tmpRoot.mkdirs();
        tmpRoot.deleteOnExit();
        File src = new File(tmpRoot, "src");
        src.mkdirs();
        src.deleteOnExit();
        File a = new File(src, "a.txt");
        a.deleteOnExit();
        a.createNewFile();
        File b = new File(src, "b.txt");
        b.deleteOnExit();
        b.createNewFile();
        File folder = new File(src, "folder");
        folder.mkdirs();
        folder.deleteOnExit();
        File c = new File(folder, "c.txt");
        c.deleteOnExit();
        c.createNewFile();
        File dest = new File(tmpRoot, "dest");
        File destA = new File(dest, "a.txt");
        File destB = new File(dest, "b.txt");
        File destC = new File(new File(dest, "folder"), "c.txt");
        Assert.assertFalse((boolean)destA.exists());
        Assert.assertFalse((boolean)destB.exists());
        Assert.assertFalse((boolean)destC.exists());
        FileIOUtils.copyDirectoryAndOverwriteFilesIfNeeded((File)src, (File)dest);
        Assert.assertTrue((boolean)destA.exists());
        Assert.assertTrue((boolean)destB.exists());
        Assert.assertTrue((boolean)destC.exists());
        Assert.assertEquals((long)a.lastModified(), (long)destA.lastModified());
        Assert.assertEquals((long)b.lastModified(), (long)destB.lastModified());
        Assert.assertEquals((long)c.lastModified(), (long)destC.lastModified());
        Thread.sleep(1000L);
        boolean deleted = c.delete();
        Assert.assertTrue((boolean)deleted);
        c.createNewFile();
        c.deleteOnExit();
        FileWriter out = new FileWriter(c);
        String line = "foo bar";
        out.write(line + "\n");
        out.close();
        Assert.assertNotEquals((long)c.lastModified(), (long)destC.lastModified());
        FileIOUtils.copyDirectoryAndOverwriteFilesIfNeeded((File)src, (File)dest);
        Assert.assertEquals((long)c.lastModified(), (long)destC.lastModified());
        Scanner in = new Scanner(new FileReader(destC));
        String read = in.nextLine();
        in.close();
        Assert.assertEquals((Object)line, (Object)read);
    }
}

