/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.evosuite.utils.LoggingUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestLogbackConfiguration {
    public static final PrintStream defaultOut = System.out;
    public static final PrintStream defaultErr = System.err;

    @After
    public void resetDefaultPrinters() {
        System.setOut(defaultOut);
        System.setErr(defaultErr);
        LoggingUtils.changeLogbackFile((String)"logback.xml");
    }

    @Test
    public void testStdOutErr() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        System.setOut(new PrintStream(out));
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        System.setErr(new PrintStream(err));
        boolean loaded = LoggingUtils.changeLogbackFile((String)LoggingUtils.getLogbackFileName());
        Assert.assertTrue((boolean)loaded);
        Logger logger = LoggerFactory.getLogger(TestLogbackConfiguration.class);
        String warnMsg = "this should go to std out";
        String errMsg = "this should go to std err";
        logger.warn("this should go to std out");
        logger.error("this should go to std err");
        String printedOut = out.toString();
        String printedErr = err.toString();
        Assert.assertTrue((String)("Content of std out is: " + printedOut), (boolean)printedOut.contains("this should go to std out"));
        Assert.assertTrue((String)("Content of std err is: " + printedErr), (boolean)printedErr.contains("this should go to std err"));
        Assert.assertTrue((String)("Content of std out is: " + printedOut), (!printedOut.contains("this should go to std err") ? 1 : 0) != 0);
        Assert.assertTrue((String)("Content of std err is: " + printedErr), (!printedErr.contains("this should go to std out") ? 1 : 0) != 0);
    }
}

