/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils;

import java.util.regex.Pattern;
import org.evosuite.utils.RegexDistanceUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestRegexDistance {
    @Test
    public void testLongRegex() {
        String example = "-@0.AA";
        String REGEX = "^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
        Assert.assertTrue((boolean)"-@0.AA".matches("^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$"));
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"-@0.AA", (String)"^[_A-Za-z0-9-]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$"), (double)0.0);
    }

    @Test
    public void testEmptyRegex() {
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"", (String)""), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"a", (String)""), (double)0.0);
        Assert.assertEquals((double)2.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"ab", (String)""), (double)0.0);
        Assert.assertEquals((double)3.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"abc", (String)""), (double)0.0);
    }

    @Test
    public void testIdenticalChar() {
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"a", (String)"a"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"aa", (String)"aa"), (double)0.0);
    }

    @Test
    public void testReplaceChar() {
        Assert.assertEquals((double)0.5, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"b", (String)"a"), (double)0.0);
        Assert.assertEquals((double)0.5, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"ab", (String)"aa"), (double)0.0);
    }

    @Test
    public void testDeleteChar() {
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"aa", (String)"a"), (double)0.0);
        Assert.assertEquals((double)2.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"aaa", (String)"a"), (double)0.0);
        Assert.assertEquals((double)3.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"aaaa", (String)"a"), (double)0.0);
        Assert.assertEquals((double)4.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"aaaaa", (String)"a"), (double)0.0);
    }

    @Test
    public void testInsertCharInEmptyString() {
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"", (String)"a"), (double)0.0);
        Assert.assertEquals((double)2.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"", (String)"aa"), (double)0.0);
        Assert.assertEquals((double)3.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"", (String)"aaa"), (double)0.0);
    }

    @Test
    public void testInsertChar() {
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"a", (String)"aa"), (double)0.0);
        Assert.assertEquals((double)2.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"a", (String)"aaa"), (double)0.0);
        Assert.assertEquals((double)3.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"a", (String)"aaaa"), (double)0.0);
    }

    @Test
    public void testTwoChar() {
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"ab", (String)"ab"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"ab", (String)"ba"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"ab", (String)"bc"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"bb", (String)"aa"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"bb", (String)"cc"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"bb", (String)"ac"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"bb", (String)"ca"), (double)0.0);
        Assert.assertEquals((double)2.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"", (String)"ab"), (double)0.0);
        Assert.assertEquals((double)2.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"ab", (String)""), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"a", (String)"ab"), (double)0.0);
        Assert.assertEquals((double)1.5, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"aaa", (String)"ab"), (double)0.0);
        Assert.assertEquals((double)2.5, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"aaaa", (String)"ab"), (double)0.0);
        Assert.assertEquals((double)1.5, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"bb", (String)"bab"), (double)0.0);
        Assert.assertEquals((double)3.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"b", (String)"bcab"), (double)0.0);
        Assert.assertEquals((double)4.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"b", (String)"bcaab"), (double)0.0);
        Assert.assertEquals((double)1.5, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"xb", (String)"xcb"), (double)0.0);
        Assert.assertEquals((double)1.5, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"b", (String)"cb"), (double)0.0);
        Assert.assertEquals((double)2.5, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"b", (String)"cab"), (double)0.0);
        Assert.assertEquals((double)3.5, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"b", (String)"caab"), (double)0.0);
        Assert.assertEquals((double)1.5, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"b", (String)"ab"), (double)0.0);
        Assert.assertEquals((double)2.5, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"b", (String)"aab"), (double)0.0);
    }

    @Test
    public void testThreeChar() {
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"abc", (String)"abc"), (double)0.0);
        Assert.assertEquals((double)1.5, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"abc", (String)"bab"), (double)0.0);
        Assert.assertEquals((double)3.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"", (String)"abc"), (double)0.0);
        Assert.assertEquals((double)3.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"abc", (String)""), (double)0.0);
        Assert.assertEquals((double)2.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"a", (String)"abc"), (double)0.0);
        Assert.assertEquals((double)1.5, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"aa", (String)"abc"), (double)0.0);
        Assert.assertEquals((double)2.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"aaaa", (String)"abb"), (double)0.0);
    }

    @Test
    public void testOr() {
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"ac", (String)"(a|b)a*(c|d)"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"bc", (String)"(a|b)a*(c|d)"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"ad", (String)"(a|b)a*(c|d)"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"bd", (String)"(a|b)a*(c|d)"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"aac", (String)"(a|b)a*(c|d)"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"aad", (String)"(a|b)a*(c|d)"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"bad", (String)"(a|b)a*(c|d)"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"baac", (String)"(a|b)a*(c|d)"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"aaaaad", (String)"(a|b)a*(c|d)"), (double)0.0);
        Assert.assertEquals((double)2.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"", (String)"(a|b)a*(c|d)"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"a", (String)"(a|b)a*(c|d)"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"b", (String)"(a|b)a*(c|d)"), (double)0.0);
        Assert.assertEquals((double)0.6666666666666666, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"aaa", (String)"(a|b)a*(c|d)"), (double)0.0);
    }

    @Test
    public void testThreeOrFour() {
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"AAA", (String)"A{3,4}"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"AAAA", (String)"A{3,4}"), (double)0.0);
        Assert.assertEquals((double)3.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"", (String)"A{3,4}"), (double)0.0);
        Assert.assertEquals((double)2.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"A", (String)"A{3,4}"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"AA", (String)"A{3,4}"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"AAAAA", (String)"A{3,4}"), (double)0.0);
        Assert.assertEquals((double)2.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"AAAAAA", (String)"A{3,4}"), (double)0.0);
    }

    @Test
    public void testOptional() {
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"ac", (String)"a.?c"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"abc", (String)"a.?c"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"a.c", (String)"a.?c"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"acc", (String)"a.?c"), (double)0.0);
        Assert.assertEquals((double)2.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"", (String)"a.?c"), (double)0.0);
        Assert.assertEquals((double)0.5, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"acd", (String)"a.?c"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"a", (String)"a.?c"), (double)0.0);
        Assert.assertEquals((double)0.6666666666666666, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"cc", (String)"a.?c"), (double)0.0);
    }

    @Test
    public void testDeletionFollowedByInsertion() {
        double addd = RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"addd", (String)"a.?c");
        double add = RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"add", (String)"a.?c");
        Assert.assertTrue((addd != 1.5 ? 1 : 0) != 0);
        Assert.assertTrue((add < addd ? 1 : 0) != 0);
        Assert.assertEquals((double)0.5, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"add", (String)"a.?c"), (double)0.0);
    }

    @Test
    public void testRange() {
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"A", (String)"[A-Z-0-9]+"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"1", (String)"[A-Z-0-9]+"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"A1", (String)"[A-Z-0-9]+"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"A1B2", (String)"[A-Z-0-9]+"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"3H8J2", (String)"[A-Z-0-9]+"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"", (String)"[A-Z-0-9]+"), (double)0.0);
        Assert.assertEquals((double)0.875, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"a", (String)"[A-Z-0-9]+"), (double)0.0);
        Assert.assertEquals((double)0.875, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"1a", (String)"[A-Z-0-9]+"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"A1By", (String)"[A-Z-0-9]+"), (double)0.1);
        Assert.assertEquals((double)1.75, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"1aa", (String)"[A-Z-0-9]+"), (double)0.0);
    }

    @Test
    public void testEmail() {
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"ZhiX@Hhhh", (String)"[A-Za-z]{4,10}\\@[A-Za-z]{4,10}"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"ZhiX@Hhh", (String)"[A-Za-z]{4,10}\\@[A-Za-z]{4,10}"), (double)0.0);
        Assert.assertEquals((double)2.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"ZhiX@Hh", (String)"[A-Za-z]{4,10}\\@[A-Za-z]{4,10}"), (double)0.0);
        Assert.assertEquals((double)3.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"ZhiX@H", (String)"[A-Za-z]{4,10}\\@[A-Za-z]{4,10}"), (double)0.0);
        Assert.assertEquals((double)5.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"hiX@H", (String)"[A-Za-z]{4,10}\\@[A-Za-z]{4,10}"), (double)1.0);
        Assert.assertEquals((double)5.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"ZhiXH", (String)"[A-Za-z]{4,10}\\@[A-Za-z]{4,10}"), (double)0.3);
    }

    @Test
    public void tetsAutomaton() {
        RegexDistanceUtils.getAndCacheAutomaton((String)"[a0]");
        RegexDistanceUtils.getAndCacheAutomaton((String)"[a0]*");
        RegexDistanceUtils.getAndCacheAutomaton((String)"[a0]+");
        RegexDistanceUtils.getAndCacheAutomaton((String)"a.?c");
    }

    @Test
    public void testClosure() {
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"", (String)"[a0]*"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"a", (String)"[a0]"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"0", (String)"[a0]"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"a", (String)"[a0]+"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"0", (String)"[a0]+"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"a", (String)"[a0]*"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"0", (String)"[a0]*"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"test", (String)"[a0]*test"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"atest", (String)"[a0]*test"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"0test", (String)"[a0]*test"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"a0a0test", (String)"[a0]*test"), (double)0.0);
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"aaaaa0a0test", (String)"[a0]*test"), (double)0.0);
        Assert.assertEquals((double)4.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"", (String)"[a0]*test"), (double)0.0);
        Assert.assertEquals((double)3.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"t", (String)"[a0]*test"), (double)0.0);
        Assert.assertEquals((double)2.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"te", (String)"[a0]*test"), (double)0.0);
        Assert.assertEquals((double)1.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"tes", (String)"[a0]*test"), (double)0.0);
    }

    @Test
    public void testReplacement() {
        Assert.assertEquals((Object)"test", (Object)RegexDistanceUtils.expandRegex((String)"test"));
        Assert.assertEquals((Object)"[a-zA-Z_0-9]", (Object)RegexDistanceUtils.expandRegex((String)"\\w"));
        Assert.assertEquals((Object)"[^a-zA-Z_0-9]", (Object)RegexDistanceUtils.expandRegex((String)"\\W"));
    }

    @Test
    public void testGroups() {
        Assert.assertEquals((double)0.0, (double)RegexDistanceUtils.getDistanceTailoredForStringAVM((String)"tue", (String)"((mon)|(tue)|(wed)|(thur)|(fri)|(sat)|(sun))"), (double)0.0);
    }

    @Test
    public void testWordBoundaries() {
        String regex = ".*\\bhallo\\b.*";
        String str = "hallo test";
        Pattern p = Pattern.compile(regex);
        if (p.matcher(str).matches()) {
            Assert.assertEquals((long)0L, (long)RegexDistanceUtils.getStandardDistance((String)str, (String)regex));
        } else {
            Assert.assertTrue((0 < RegexDistanceUtils.getStandardDistance((String)str, (String)regex) ? 1 : 0) != 0);
        }
    }
}

