/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils.generic;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.evosuite.utils.generic.GenericMethod;
import org.evosuite.utils.generic.WildcardTypeImpl;
import org.junit.Assert;
import org.junit.Test;

public class GenericMethodTest {
    @Test
    public void testGetExactReturnType() throws Exception {
        Method m = B.class.getDeclaredMethod("bar", Object.class);
        GenericMethod gm = new GenericMethod(m, B.class);
        Type res = gm.getExactReturnType(m, B.class);
        Assert.assertEquals(Object.class, (Object)res);
    }

    @Test
    public void testGetExactReturnType_extend() throws Exception {
        Method m2;
        try {
            m2 = C.class.getDeclaredMethod("bar", Object.class);
            Assert.fail();
        }
        catch (Exception m2) {
            // empty catch block
        }
        m2 = C.class.getDeclaredMethod("bar", A.class);
        GenericMethod gm = new GenericMethod(m2, C.class);
        Type res = gm.getExactReturnType(m2, C.class);
        Assert.assertEquals(A.class, (Object)res);
    }

    @Test
    public void testGetExactReturnType_extend2() throws Exception {
        Method m2;
        try {
            m2 = D.class.getDeclaredMethod("bar", A.class);
            Assert.fail();
        }
        catch (Exception m2) {
            // empty catch block
        }
        m2 = D.class.getDeclaredMethod("bar", B.class);
        GenericMethod gm = new GenericMethod(m2, D.class);
        Type res = gm.getExactReturnType(m2, D.class);
        Assert.assertEquals(B.class, (Object)res);
    }

    @Test
    public void testGetExactReturnType_staticMethod() throws Exception {
        Method m = A.class.getDeclaredMethod("bar", Object.class);
        GenericMethod gm = new GenericMethod(m, A.class);
        Type res = gm.getExactReturnType(m, A.class);
        Assert.assertNotNull((Object)res);
        WildcardTypeImpl wt = (WildcardTypeImpl)res;
        Assert.assertEquals((long)0L, (long)wt.getLowerBounds().length);
        Assert.assertEquals((long)1L, (long)wt.getUpperBounds().length);
        Class upper = (Class)wt.getUpperBounds()[0];
        Assert.assertEquals(Object.class, (Object)upper);
    }

    @Test
    public void testGetExactParameterTypes_staticMethod() throws Exception {
        Method m = A.class.getDeclaredMethod("bar", Object.class);
        GenericMethod gm = new GenericMethod(m, A.class);
        Type res = gm.getExactParameterTypes(m, A.class)[0];
        Assert.assertNotNull((Object)res);
        WildcardTypeImpl wt = (WildcardTypeImpl)res;
        Assert.assertEquals((long)0L, (long)wt.getLowerBounds().length);
        Assert.assertEquals((long)1L, (long)wt.getUpperBounds().length);
        Class upper = (Class)wt.getUpperBounds()[0];
        Assert.assertEquals(Object.class, (Object)upper);
    }

    public static class D<T extends A> {
        public <T extends B> T bar(T t) {
            return t;
        }
    }

    public static class C<T extends A> {
        public T bar(T t) {
            return t;
        }
    }

    public static class B<T> {
        public T bar(T t) {
            return t;
        }
    }

    private static class A {
        private A() {
        }

        public static <T> T bar(T obj) {
            return obj;
        }
    }
}

