/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.utils.generic;

import com.examples.with.different.packagename.utils.generic.BigFraction;
import com.examples.with.different.packagename.utils.generic.ClassWithOverloadedMethods;
import com.examples.with.different.packagename.utils.generic.ClassWithoutOverloadedMethods;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.evosuite.testcase.DefaultTestCase;
import org.evosuite.testcase.TestCase;
import org.evosuite.testcase.variable.ConstantValue;
import org.evosuite.testcase.variable.VariableReference;
import org.evosuite.testcase.variable.VariableReferenceImpl;
import org.evosuite.utils.generic.GenericConstructor;
import org.evosuite.utils.generic.GenericMethod;
import org.junit.Assert;
import org.junit.Test;

public class TestOverloading {
    @Test
    public void testOverloadedConstructor() {
        Class<ClassWithOverloadedMethods> clazz = ClassWithOverloadedMethods.class;
        Constructor<?> constructor1 = clazz.getConstructors()[0];
        Constructor<?> constructor2 = clazz.getConstructors()[1];
        GenericConstructor genericConstructor1 = new GenericConstructor(constructor1, clazz);
        GenericConstructor genericConstructor2 = new GenericConstructor(constructor2, clazz);
        DefaultTestCase test = new DefaultTestCase();
        ConstantValue intValue = new ConstantValue((TestCase)test, Integer.TYPE);
        VariableReferenceImpl integerVar = new VariableReferenceImpl((TestCase)test, Integer.class);
        List<VariableReference> parameters = Arrays.asList(intValue, integerVar);
        Assert.assertTrue((boolean)genericConstructor1.isOverloaded(parameters));
        Assert.assertTrue((boolean)genericConstructor2.isOverloaded(parameters));
    }

    @Test
    public void testOverloadedConstructorBigFraction() {
        Class<BigFraction> clazz = BigFraction.class;
        Constructor<?> constructor1 = clazz.getConstructors()[0];
        Constructor<?> constructor2 = clazz.getConstructors()[1];
        GenericConstructor genericConstructor1 = new GenericConstructor(constructor1, clazz);
        GenericConstructor genericConstructor2 = new GenericConstructor(constructor2, clazz);
        DefaultTestCase test = new DefaultTestCase();
        ConstantValue longValue = new ConstantValue((TestCase)test, Long.TYPE);
        ConstantValue intValue = new ConstantValue((TestCase)test, Integer.TYPE);
        List<VariableReference> parameters = Arrays.asList(longValue, intValue);
        Assert.assertTrue((boolean)genericConstructor1.isOverloaded(parameters));
        Assert.assertTrue((boolean)genericConstructor2.isOverloaded(parameters));
    }

    @Test
    public void testNotOverloadedConstructor() {
        Class<ClassWithoutOverloadedMethods> clazz = ClassWithoutOverloadedMethods.class;
        Constructor<?> constructor1 = clazz.getConstructors()[0];
        Constructor<?> constructor2 = clazz.getConstructors()[1];
        GenericConstructor genericConstructor1 = new GenericConstructor(constructor1, clazz);
        GenericConstructor genericConstructor2 = new GenericConstructor(constructor2, clazz);
        DefaultTestCase test = new DefaultTestCase();
        ConstantValue intValue = new ConstantValue((TestCase)test, Integer.TYPE);
        VariableReferenceImpl stringVar = new VariableReferenceImpl((TestCase)test, String.class);
        List<VariableReference> parameters1 = Arrays.asList(intValue);
        List<VariableReference> parameters2 = Arrays.asList(stringVar);
        Assert.assertFalse((boolean)genericConstructor1.isOverloaded(parameters1));
        Assert.assertFalse((boolean)genericConstructor2.isOverloaded(parameters2));
        Assert.assertFalse((boolean)genericConstructor1.isOverloaded(parameters2));
        Assert.assertFalse((boolean)genericConstructor2.isOverloaded(parameters1));
    }

    @Test
    public void testOverloadedMethod() {
        Class<ClassWithOverloadedMethods> clazz = ClassWithOverloadedMethods.class;
        Method method1 = clazz.getMethods()[0];
        Method method2 = clazz.getMethods()[1];
        GenericMethod genericMethod1 = new GenericMethod(method1, clazz);
        GenericMethod genericMethod2 = new GenericMethod(method2, clazz);
        DefaultTestCase test = new DefaultTestCase();
        ConstantValue intValue = new ConstantValue((TestCase)test, Integer.TYPE);
        VariableReferenceImpl integerVar = new VariableReferenceImpl((TestCase)test, Integer.class);
        List<VariableReference> parameters1 = Arrays.asList(intValue);
        List<VariableReference> parameters2 = Arrays.asList(integerVar);
        Assert.assertTrue((boolean)genericMethod1.isOverloaded());
        Assert.assertTrue((boolean)genericMethod2.isOverloaded());
        Assert.assertTrue((boolean)genericMethod1.isOverloaded(parameters1));
        Assert.assertTrue((boolean)genericMethod2.isOverloaded(parameters1));
        Assert.assertTrue((boolean)genericMethod1.isOverloaded(parameters2));
        Assert.assertTrue((boolean)genericMethod2.isOverloaded(parameters2));
    }

    @Test
    public void testNotOverloadedMethod() {
        Class<ClassWithoutOverloadedMethods> clazz = ClassWithoutOverloadedMethods.class;
        Method method1 = clazz.getMethods()[0];
        Method method2 = clazz.getMethods()[1];
        GenericMethod genericMethod1 = new GenericMethod(method1, clazz);
        GenericMethod genericMethod2 = new GenericMethod(method2, clazz);
        DefaultTestCase test = new DefaultTestCase();
        ConstantValue intValue = new ConstantValue((TestCase)test, Integer.TYPE);
        VariableReferenceImpl stringVar = new VariableReferenceImpl((TestCase)test, String.class);
        List<VariableReference> parameters1 = Arrays.asList(intValue);
        List<VariableReference> parameters2 = Arrays.asList(stringVar);
        Assert.assertFalse((boolean)genericMethod1.isOverloaded());
        Assert.assertFalse((boolean)genericMethod2.isOverloaded());
        Assert.assertFalse((boolean)genericMethod1.isOverloaded(parameters1));
        Assert.assertFalse((boolean)genericMethod2.isOverloaded(parameters1));
        Assert.assertFalse((boolean)genericMethod1.isOverloaded(parameters2));
        Assert.assertFalse((boolean)genericMethod2.isOverloaded(parameters2));
    }
}

