/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.maven;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.eclipse.aether.RepositorySystemSession;
import org.evosuite.maven.util.EvoSuiteRunner;
import org.evosuite.maven.util.ProjectUtils;

@Mojo(name="coverage", requiresProject=true, requiresDependencyResolution=ResolutionScope.TEST, requiresDependencyCollection=ResolutionScope.TEST)
public class CoverageMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    private MavenProject project;
    @Parameter(defaultValue="${plugin.artifacts}", required=true, readonly=true)
    private List<Artifact> artifacts;
    @Component
    private ProjectBuilder projectBuilder;
    @Parameter(defaultValue="${repositorySystemSession}", required=true, readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(property="criterion", defaultValue="LINE:BRANCH:CBRANCH:WEAKMUTATION:METHODTRACE")
    private String criterion;
    @Parameter(property="global_timeout", defaultValue="120")
    private int global_timeout;
    @Parameter(property="output_variables", defaultValue="TARGET_CLASS,criterion,Coverage,Total_Goals,Covered_Goals,LineCoverage,LineCoverageBitString,BranchCoverage,BranchCoverageBitString,CBranchCoverage,CBranchCoverageBitString,WeakMutationScore,WeakMutationCoverageBitString,MethodTraceCoverage,MethodTraceCoverageBitString")
    private String output_variables;
    @Parameter(property="junit")
    private String junit;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.getLog().info((CharSequence)"Going to measure the coverage of manually written test cases with EvoSuite");
        ArrayList<String> target = new ArrayList<String>();
        LinkedHashSet<String> cp = new LinkedHashSet<String>();
        target.addAll(ProjectUtils.getCompileClasspathElements(this.project));
        cp.addAll(ProjectUtils.getTestClasspathElements(this.project));
        cp.addAll(ProjectUtils.getDependencyPathElements(this.project));
        cp.addAll(ProjectUtils.getRuntimeClasspathElements(this.project));
        if (target.isEmpty() || cp.isEmpty()) {
            this.getLog().info((CharSequence)"Nothing to measure coverage!");
            return;
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add("-measureCoverage");
        params.add("-target");
        params.add(ProjectUtils.toClasspathString(target));
        params.add("-DCP=" + ProjectUtils.toClasspathString(cp));
        if (this.junit != null) {
            params.add("-Djunit=" + this.junit);
        }
        params.add("-Dcriterion=" + this.criterion);
        params.add("-Doutput_variables=" + this.output_variables);
        params.add("-Dglobal_timeout=" + this.global_timeout);
        params.add("-Dsandbox=false");
        params.add("-Dvirtual_fs=false");
        params.add("-Dvirtual_net=false");
        params.add("-Dreplace_calls=false");
        params.add("-Dreplace_system_in=false");
        this.getLog().info((CharSequence)"Params:");
        for (String s : params) {
            this.getLog().info((CharSequence)("  " + s));
        }
        EvoSuiteRunner runner = new EvoSuiteRunner(this.getLog(), this.artifacts, this.projectBuilder, this.repoSession);
        runner.registerShutDownHook();
        boolean ok = runner.runEvoSuite(this.project.getBasedir().toString(), params);
        if (!ok) {
            throw new MojoFailureException("Failed to correctly execute EvoSuite");
        }
    }
}

