/*
 * Decompiled with CFR 0.152.
 */
package org.evosuite.maven.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.maven.artifact.DependencyResolutionRequiredException;
import org.apache.maven.project.MavenProject;
import org.evosuite.PackageInfo;

public class ProjectUtils {
    public static List<String> getCompileClasspathElements(MavenProject project) {
        ArrayList<String> compileClassPath = new ArrayList<String>();
        try {
            project.getCompileClasspathElements().stream().filter(element -> !element.endsWith(".jar")).filter(element -> new File((String)element).exists()).forEach(element -> compileClassPath.add((String)element));
        }
        catch (DependencyResolutionRequiredException e) {
            e.printStackTrace();
        }
        return compileClassPath;
    }

    public static List<String> getTestClasspathElements(MavenProject project) {
        ArrayList<String> testClassPath = new ArrayList<String>();
        try {
            project.getTestClasspathElements().stream().filter(element -> !element.endsWith(".jar")).filter(element -> new File((String)element).exists()).forEach(element -> testClassPath.add((String)element));
        }
        catch (DependencyResolutionRequiredException e) {
            e.printStackTrace();
        }
        return testClassPath;
    }

    public static List<String> getRuntimeClasspathElements(MavenProject project) {
        ArrayList<String> runtimeClassPath = new ArrayList<String>();
        try {
            project.getRuntimeClasspathElements().stream().filter(element -> new File((String)element).exists()).forEach(element -> runtimeClassPath.add((String)element));
        }
        catch (DependencyResolutionRequiredException e) {
            e.printStackTrace();
        }
        return runtimeClassPath;
    }

    public static List<String> getDependencyPathElements(MavenProject project) {
        ArrayList<String> dependencyArtifacts = new ArrayList<String>();
        project.getDependencyArtifacts().stream().filter(element -> !element.isOptional()).filter(element -> element.getFile().exists()).filter(element -> !element.getGroupId().equals(PackageInfo.getEvoSuitePackage())).filter(element -> !element.getGroupId().equals("junit")).forEach(element -> dependencyArtifacts.add(element.getFile().getAbsolutePath()));
        return dependencyArtifacts;
    }

    public static String toClasspathString(Collection<String> elements) {
        StringBuilder str = new StringBuilder();
        elements.forEach(element -> str.append(str.length() == 0 ? element : File.pathSeparator + element));
        return str.toString();
    }
}

