/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.stream.Stream;
import org.exparity.hamcrest.date.core.AnyOf;
import org.exparity.hamcrest.date.core.DateMatcher;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsDayOfMonth;
import org.exparity.hamcrest.date.core.IsDayOfWeek;
import org.exparity.hamcrest.date.core.IsLeapYear;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMonth;
import org.exparity.hamcrest.date.core.IsSameDay;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.IsYear;
import org.exparity.hamcrest.date.core.format.DatePartFormatter;
import org.exparity.hamcrest.date.core.format.LocalDateFormatter;
import org.exparity.hamcrest.date.core.wrapper.FieldLocalDateWrapper;
import org.exparity.hamcrest.date.core.wrapper.LocalDateWrapper;
import org.hamcrest.Factory;

public abstract class LocalDateMatchers {
    public static DateMatcher<LocalDate> after(LocalDate date) {
        return new IsAfter<LocalDate>(new LocalDateWrapper(date), new LocalDateFormatter());
    }

    public static DateMatcher<LocalDate> after(int year, Month month, int dayOfMonth) {
        return LocalDateMatchers.after(LocalDate.of(year, month, dayOfMonth));
    }

    public static DateMatcher<LocalDate> before(LocalDate date) {
        return new IsBefore<LocalDate>(new LocalDateWrapper(date), new LocalDateFormatter());
    }

    public static DateMatcher<LocalDate> before(int year, Month month, int dayOfMonth) {
        return LocalDateMatchers.before(LocalDate.of(year, month, dayOfMonth));
    }

    public static DateMatcher<LocalDate> sameDay(LocalDate date) {
        return new IsSameDay<LocalDate>(new LocalDateWrapper(date), new LocalDateFormatter());
    }

    public static DateMatcher<LocalDate> isDay(int year, Month month, int dayOfMonth) {
        return LocalDateMatchers.sameDay(LocalDate.of(year, month, dayOfMonth));
    }

    public static DateMatcher<LocalDate> sameOrBefore(LocalDate date) {
        return new IsSameOrBefore<LocalDate>(new LocalDateWrapper(date), new LocalDateFormatter());
    }

    @Factory
    public static DateMatcher<LocalDate> sameOrBefore(int year, Month month, int day) {
        return LocalDateMatchers.sameOrBefore(LocalDate.of(year, month, day));
    }

    public static DateMatcher<LocalDate> sameOrAfter(LocalDate date) {
        return new IsSameOrAfter<LocalDate>(new LocalDateWrapper(date), new LocalDateFormatter());
    }

    public static DateMatcher<LocalDate> sameOrAfter(int year, Month month, int day) {
        return LocalDateMatchers.sameOrAfter(LocalDate.of(year, month, day));
    }

    public static DateMatcher<LocalDate> sameMonthOfYear(LocalDate date) {
        return LocalDateMatchers.isMonth(date.getMonth());
    }

    public static DateMatcher<LocalDate> sameDayOfMonth(LocalDate date) {
        return new IsDayOfMonth<LocalDate>(new FieldLocalDateWrapper(date, ChronoField.DAY_OF_MONTH), (d, z) -> d.atStartOfDay(z).getDayOfMonth());
    }

    public static DateMatcher<LocalDate> isDayOfMonth(int dayOfMonth) {
        return new IsDayOfMonth<LocalDate>(new FieldLocalDateWrapper(dayOfMonth, ChronoField.DAY_OF_MONTH), (d, z) -> d.atStartOfDay(z).getDayOfMonth());
    }

    public static DateMatcher<LocalDate> sameYear(LocalDate date) {
        return new IsYear<LocalDate>(new FieldLocalDateWrapper(date, ChronoField.YEAR), (d, z) -> d.atStartOfDay(z).getYear());
    }

    public static DateMatcher<LocalDate> isYear(int year) {
        return new IsYear<LocalDate>(new FieldLocalDateWrapper(year, ChronoField.YEAR), (d, z) -> d.atStartOfDay(z).getYear());
    }

    public static DateMatcher<LocalDate> within(long period, ChronoUnit unit, LocalDate date) {
        return new IsWithin<LocalDate>(period, unit, new LocalDateWrapper(date), new LocalDateFormatter());
    }

    public static DateMatcher<LocalDate> within(long period, ChronoUnit unit, int year, Month month, int dayofMonth) {
        return LocalDateMatchers.within(period, unit, LocalDate.of(year, month, dayofMonth));
    }

    public static DateMatcher<LocalDate> isYesterday() {
        return LocalDateMatchers.sameDay(LocalDate.now().plusDays(-1L));
    }

    public static DateMatcher<LocalDate> isToday() {
        return LocalDateMatchers.sameDay(LocalDate.now());
    }

    public static DateMatcher<LocalDate> isTomorrow() {
        return LocalDateMatchers.sameDay(LocalDate.now().plusDays(1L));
    }

    public static DateMatcher<LocalDate> sameDayOfWeek(LocalDate date) {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.from(date));
    }

    public static DateMatcher<LocalDate> isDayOfWeek(DayOfWeek dayOfWeek) {
        return new IsDayOfWeek<LocalDate>(new FieldLocalDateWrapper(dayOfWeek.getValue(), ChronoField.DAY_OF_WEEK), (d, z) -> d.atStartOfDay(z).getDayOfWeek().getValue());
    }

    public static DateMatcher<LocalDate> isDayOfWeek(DayOfWeek ... daysOfWeek) {
        return new AnyOf<LocalDate>(Stream.of(daysOfWeek).map(LocalDateMatchers::isDayOfWeek), (d, z) -> "the date is on a " + d.atStartOfDay((ZoneId)z).getDayOfWeek().name().toLowerCase());
    }

    public static DateMatcher<LocalDate> isMonday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.MONDAY);
    }

    public static DateMatcher<LocalDate> isTuesday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.TUESDAY);
    }

    public static DateMatcher<LocalDate> isWednesday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.WEDNESDAY);
    }

    public static DateMatcher<LocalDate> isThursday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.THURSDAY);
    }

    public static DateMatcher<LocalDate> isFriday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.FRIDAY);
    }

    public static DateMatcher<LocalDate> isSaturday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.SATURDAY);
    }

    public static DateMatcher<LocalDate> isSunday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.SUNDAY);
    }

    public static DateMatcher<LocalDate> isWeekday() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.MONDAY, DayOfWeek.TUESDAY, DayOfWeek.WEDNESDAY, DayOfWeek.THURSDAY, DayOfWeek.FRIDAY);
    }

    public static DateMatcher<LocalDate> isWeekend() {
        return LocalDateMatchers.isDayOfWeek(DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    public static DateMatcher<LocalDate> isFirstDayOfMonth() {
        return new IsMinimum<LocalDate>(ChronoField.DAY_OF_MONTH, (d, z) -> d.atStartOfDay(z).get(ChronoField.DAY_OF_MONTH), (d, z) -> ChronoField.DAY_OF_MONTH.rangeRefinedBy(d.atStartOfDay(z)), new DatePartFormatter(), () -> "the date is the first day of the month");
    }

    public static DateMatcher<LocalDate> isMinimum(ChronoField field) {
        return new IsMinimum<LocalDate>(field, (d, z) -> d.atStartOfDay(z).get(field), (d, z) -> field.rangeRefinedBy(d.atStartOfDay(z)), new DatePartFormatter());
    }

    public static DateMatcher<LocalDate> isLastDayOfMonth() {
        return new IsMaximum<LocalDate>(ChronoField.DAY_OF_MONTH, (d, z) -> d.atStartOfDay(z).get(ChronoField.DAY_OF_MONTH), (d, z) -> ChronoField.DAY_OF_MONTH.rangeRefinedBy(d.atStartOfDay(z)), new DatePartFormatter(), () -> "the date is the last day of the month");
    }

    public static DateMatcher<LocalDate> isMaximum(ChronoField field) {
        return new IsMaximum<LocalDate>(field, (d, z) -> d.atStartOfDay(z).get(field), (d, z) -> field.rangeRefinedBy(d.atStartOfDay(z)), new DatePartFormatter());
    }

    public static DateMatcher<LocalDate> isMonth(Month month) {
        return new IsMonth<LocalDate>(new FieldLocalDateWrapper(month.getValue(), ChronoField.MONTH_OF_YEAR), (d, z) -> d.atStartOfDay(z).getMonthValue());
    }

    public static DateMatcher<LocalDate> isJanuary() {
        return LocalDateMatchers.isMonth(Month.JANUARY);
    }

    public static DateMatcher<LocalDate> isFebruary() {
        return LocalDateMatchers.isMonth(Month.FEBRUARY);
    }

    public static DateMatcher<LocalDate> isMarch() {
        return LocalDateMatchers.isMonth(Month.MARCH);
    }

    public static DateMatcher<LocalDate> isApril() {
        return LocalDateMatchers.isMonth(Month.APRIL);
    }

    public static DateMatcher<LocalDate> isMay() {
        return LocalDateMatchers.isMonth(Month.MAY);
    }

    public static DateMatcher<LocalDate> isJune() {
        return LocalDateMatchers.isMonth(Month.JUNE);
    }

    public static DateMatcher<LocalDate> isJuly() {
        return LocalDateMatchers.isMonth(Month.JULY);
    }

    public static DateMatcher<LocalDate> isAugust() {
        return LocalDateMatchers.isMonth(Month.AUGUST);
    }

    public static DateMatcher<LocalDate> isSeptember() {
        return LocalDateMatchers.isMonth(Month.SEPTEMBER);
    }

    public static DateMatcher<LocalDate> isOctober() {
        return LocalDateMatchers.isMonth(Month.OCTOBER);
    }

    public static DateMatcher<LocalDate> isNovember() {
        return LocalDateMatchers.isMonth(Month.NOVEMBER);
    }

    public static DateMatcher<LocalDate> isDecember() {
        return LocalDateMatchers.isMonth(Month.DECEMBER);
    }

    public static DateMatcher<LocalDate> isLeapYear() {
        return new IsLeapYear<LocalDate>((d, z) -> d, new LocalDateFormatter());
    }
}

