/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date;

import java.time.LocalTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import org.exparity.hamcrest.date.core.IsAfter;
import org.exparity.hamcrest.date.core.IsBefore;
import org.exparity.hamcrest.date.core.IsHour;
import org.exparity.hamcrest.date.core.IsMaximum;
import org.exparity.hamcrest.date.core.IsMinimum;
import org.exparity.hamcrest.date.core.IsMinute;
import org.exparity.hamcrest.date.core.IsSameOrAfter;
import org.exparity.hamcrest.date.core.IsSameOrBefore;
import org.exparity.hamcrest.date.core.IsSecond;
import org.exparity.hamcrest.date.core.IsWithin;
import org.exparity.hamcrest.date.core.format.DatePartFormatter;
import org.exparity.hamcrest.date.core.format.LocalTimeFormatter;
import org.exparity.hamcrest.date.core.wrapper.FieldLocalTimeWrapper;
import org.exparity.hamcrest.date.core.wrapper.LocalTimeWrapper;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;

public abstract class LocalTimeMatchers {
    public static Matcher<LocalTime> after(LocalTime time) {
        return new IsAfter<LocalTime>(new LocalTimeWrapper(time), new LocalTimeFormatter());
    }

    public static Matcher<LocalTime> after(int hour, int minute, int second) {
        return new IsAfter<LocalTime>(new LocalTimeWrapper(hour, minute, second), new LocalTimeFormatter());
    }

    public static Matcher<LocalTime> before(LocalTime time) {
        return new IsBefore<LocalTime>(new LocalTimeWrapper(time), new LocalTimeFormatter());
    }

    public static Matcher<LocalTime> before(int hour, int minute, int second) {
        return new IsBefore<LocalTime>(new LocalTimeWrapper(hour, minute, second), new LocalTimeFormatter());
    }

    public static Matcher<LocalTime> sameOrBefore(LocalTime time) {
        return new IsSameOrBefore<LocalTime>(new LocalTimeWrapper(time), new LocalTimeFormatter());
    }

    @Factory
    public static Matcher<LocalTime> sameOrBefore(int hour, int minute, int second) {
        return new IsSameOrBefore<LocalTime>(new LocalTimeWrapper(hour, minute, second), new LocalTimeFormatter());
    }

    public static Matcher<LocalTime> sameOrAfter(LocalTime time) {
        return new IsSameOrAfter<LocalTime>(new LocalTimeWrapper(time), new LocalTimeFormatter());
    }

    public static Matcher<LocalTime> sameOrAfter(int hour, int minute, int second) {
        return LocalTimeMatchers.sameOrAfter(LocalTime.of(hour, minute, second));
    }

    public static Matcher<LocalTime> within(long period, ChronoUnit unit, LocalTime time) {
        return new IsWithin<LocalTime>(period, unit, new LocalTimeWrapper(time), new LocalTimeFormatter());
    }

    public static Matcher<LocalTime> within(long period, ChronoUnit unit, int hour, int minute, int second) {
        return new IsWithin<LocalTime>(period, unit, new LocalTimeWrapper(hour, minute, second), new LocalTimeFormatter());
    }

    public static Matcher<LocalTime> isMinimum(ChronoField field) {
        return new IsMinimum<LocalTime>(field, (d, z) -> d.get(field), (d, z) -> field.rangeRefinedBy((TemporalAccessor)d), new DatePartFormatter());
    }

    public static Matcher<LocalTime> isMaximum(ChronoField field) {
        return new IsMaximum<LocalTime>(field, (d, z) -> d.get(field), (d, z) -> field.rangeRefinedBy((TemporalAccessor)d), new DatePartFormatter());
    }

    public static Matcher<LocalTime> isHour(int hour) {
        return new IsHour<LocalTime>(new FieldLocalTimeWrapper(hour, ChronoField.HOUR_OF_DAY), (d, ignored) -> d.getHour());
    }

    public static Matcher<LocalTime> sameHourOfDay(LocalTime time) {
        return new IsHour<LocalTime>(new FieldLocalTimeWrapper(time, ChronoField.HOUR_OF_DAY), (d, ignored) -> d.getHour());
    }

    public static Matcher<LocalTime> isMinute(int minute) {
        return new IsMinute<LocalTime>(new FieldLocalTimeWrapper(minute, ChronoField.MINUTE_OF_HOUR), (d, ignored) -> d.getMinute());
    }

    public static Matcher<LocalTime> sameMinuteOfHour(LocalTime time) {
        return new IsMinute<LocalTime>(new FieldLocalTimeWrapper(time, ChronoField.MINUTE_OF_HOUR), (d, ignored) -> d.getMinute());
    }

    public static Matcher<LocalTime> isSecond(int second) {
        return new IsSecond<LocalTime>(new FieldLocalTimeWrapper(second, ChronoField.SECOND_OF_MINUTE), (d, ignored) -> d.getSecond());
    }

    public static Matcher<LocalTime> sameSecondOfMinute(LocalTime time) {
        return new IsSecond<LocalTime>(new FieldLocalTimeWrapper(time, ChronoField.SECOND_OF_MINUTE), (d, ignored) -> d.getSecond());
    }
}

