/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.ZoneId;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.exparity.hamcrest.date.core.DateMatcher;
import org.hamcrest.Description;

public class AnyOf<T>
extends DateMatcher<T> {
    private final Stream<DateMatcher<? super T>> dateMatchers;
    private final ZoneId zone;
    private final BiFunction<T, ZoneId, String> descriptionProvider;
    private final org.hamcrest.core.AnyOf<? super T> anyOf;

    private AnyOf(Stream<DateMatcher<? super T>> dateMatchers, ZoneId zone, BiFunction<T, ZoneId, String> descriptionProvider) {
        this.dateMatchers = dateMatchers;
        this.zone = zone;
        this.descriptionProvider = descriptionProvider;
        this.anyOf = new org.hamcrest.core.AnyOf((Iterable)this.dateMatchers.map(m -> m.atZone(zone)).collect(Collectors.toList()));
    }

    public AnyOf(Stream<DateMatcher<? super T>> dateMatchers, BiFunction<T, ZoneId, String> descriptionProvider) {
        this(dateMatchers, ZoneId.systemDefault(), descriptionProvider);
    }

    protected boolean matchesSafely(T t, Description mismatchDescription) {
        if (!this.anyOf.matches(t)) {
            mismatchDescription.appendText(this.descriptionProvider.apply(t, this.zone));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        this.anyOf.describeTo(description);
    }

    @Override
    public DateMatcher<T> atZone(ZoneId zone) {
        return new AnyOf<T>(this.dateMatchers, zone, this.descriptionProvider);
    }
}

