/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.DayOfWeek;
import java.time.ZoneId;
import org.exparity.hamcrest.date.core.DateMatcher;
import org.exparity.hamcrest.date.core.TemporalFieldAdapter;
import org.exparity.hamcrest.date.core.TemporalFieldWrapper;
import org.hamcrest.Description;

public class IsDayOfWeek<T>
extends DateMatcher<T> {
    private final TemporalFieldWrapper<T> expected;
    private final TemporalFieldAdapter<T> accessor;
    private final ZoneId zone;

    private IsDayOfWeek(TemporalFieldWrapper<T> expected, TemporalFieldAdapter<T> accessor, ZoneId zone) {
        this.expected = expected;
        this.accessor = accessor;
        this.zone = zone;
    }

    public IsDayOfWeek(TemporalFieldWrapper<T> expected, TemporalFieldAdapter<T> accessor) {
        this(expected, accessor, ZoneId.systemDefault());
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        if (!this.expected.isSame(actual)) {
            mismatchDescription.appendText("the date is on a " + DayOfWeek.of(this.accessor.asTemporalField(actual, this.zone)).name().toLowerCase());
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date is on a " + DayOfWeek.of(this.expected.unwrap()).name().toLowerCase());
    }

    @Override
    public DateMatcher<T> atZone(ZoneId zone) {
        return new IsDayOfWeek<T>(this.expected.withZone(zone), this.accessor);
    }
}

