/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.ZoneId;
import org.exparity.hamcrest.date.core.DateMatcher;
import org.exparity.hamcrest.date.core.TemporalFieldAdapter;
import org.exparity.hamcrest.date.core.TemporalFieldWrapper;
import org.hamcrest.Description;

public class IsMinute<T>
extends DateMatcher<T> {
    private final TemporalFieldWrapper<T> expected;
    private final TemporalFieldAdapter<T> accessor;
    private final ZoneId zone;

    private IsMinute(TemporalFieldWrapper<T> expected, TemporalFieldAdapter<T> accessor, ZoneId zone) {
        this.expected = expected;
        this.accessor = accessor;
        this.zone = zone;
    }

    public IsMinute(TemporalFieldWrapper<T> expected, TemporalFieldAdapter<T> accessor) {
        this(expected, accessor, ZoneId.systemDefault());
    }

    protected boolean matchesSafely(T actual, Description mismatchDescription) {
        if (!this.expected.isSame(actual)) {
            mismatchDescription.appendText("the date has the minute " + this.accessor.asTemporalField(actual, this.zone));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the date has the minute " + this.expected.unwrap());
    }

    @Override
    public DateMatcher<T> atZone(ZoneId zone) {
        return new IsMinute<T>(this.expected.withZone(zone), this.accessor);
    }
}

