/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core;

import java.time.ZoneId;
import org.exparity.hamcrest.date.core.DateMatcher;
import org.exparity.hamcrest.date.core.TemporalFormatter;
import org.exparity.hamcrest.date.core.TemporalWrapper;
import org.hamcrest.Description;

public class IsSameDay<T>
extends DateMatcher<T> {
    private final TemporalWrapper<T> expected;
    private final TemporalFormatter<T> describer;

    public IsSameDay(TemporalWrapper<T> expected, TemporalFormatter<T> describer) {
        this.expected = expected;
        this.describer = describer;
    }

    protected boolean matchesSafely(T actual, Description mismatchDesc) {
        if (!this.expected.isSame(actual)) {
            mismatchDesc.appendText("the day is " + this.describer.describeDate(actual));
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("the same day as " + this.describer.describeDate(this.expected.unwrap()));
    }

    @Override
    public DateMatcher<T> atZone(ZoneId zone) {
        return new IsSameDay<T>(this.expected.withZone(zone), this.describer);
    }
}

