/*
 * Decompiled with CFR 0.152.
 */
package org.exparity.hamcrest.date.core.wrapper;

import java.time.ZoneId;
import java.time.temporal.ChronoField;
import java.util.Date;
import java.util.function.ToIntFunction;
import org.exparity.hamcrest.date.core.TemporalFieldWrapper;

public class FieldDateWrapper
implements TemporalFieldWrapper<Date> {
    private final ToIntFunction<ZoneId> wrapped;
    private final ChronoField field;
    private final ZoneId zone;

    private FieldDateWrapper(ToIntFunction<ZoneId> wrapped, ChronoField field, ZoneId zone) {
        this.wrapped = wrapped;
        this.field = field;
        this.zone = zone;
    }

    public FieldDateWrapper(int value, ChronoField field) {
        this.wrapped = ignored -> value;
        this.field = field;
        this.zone = ZoneId.systemDefault();
    }

    public FieldDateWrapper(Date date, ChronoField field) {
        this.wrapped = z -> date.toInstant().atZone((ZoneId)z).get(field);
        this.field = field;
        this.zone = ZoneId.systemDefault();
    }

    @Override
    public boolean isAfter(Date other) {
        return this.wrapped.applyAsInt(this.zone) > other.toInstant().atZone(this.zone).get(this.field);
    }

    @Override
    public boolean isBefore(Date other) {
        return this.wrapped.applyAsInt(this.zone) < other.toInstant().atZone(this.zone).get(this.field);
    }

    @Override
    public boolean isSame(Date other) {
        return this.wrapped.applyAsInt(this.zone) == other.toInstant().atZone(this.zone).get(this.field);
    }

    @Override
    public int unwrap() {
        return this.wrapped.applyAsInt(this.zone);
    }

    @Override
    public TemporalFieldWrapper<Date> withZone(ZoneId zone) {
        return new FieldDateWrapper(this.wrapped, this.field, zone);
    }
}

