/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.client;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.Timeout;
import java.security.SecureRandom;
import java.util.List;
import org.fisco.bcos.channel.client.Service;
import org.fisco.bcos.channel.dto.ChannelMessage;
import org.fisco.bcos.channel.dto.ChannelResponse;
import org.fisco.bcos.channel.handler.ChannelConnections;
import org.fisco.bcos.channel.handler.ChannelHandlerContextHelper;
import org.fisco.bcos.channel.handler.ConnectionInfo;
import org.fisco.bcos.channel.protocol.ChannelMessageError;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ChannelResponseCallback {
    private static Logger logger = LoggerFactory.getLogger(ChannelResponseCallback.class);
    private ConnectionInfo fromConnection;
    private ConnectionInfo toConnection;
    private List<ConnectionInfo> fromConnectionInfos;
    private ChannelConnections fromChannelConnections;
    private List<ConnectionInfo> toConnectionInfos;
    private ChannelMessage message;
    private Service service;
    private Timeout timeout;

    public abstract void onResponseMessage(ChannelResponse var1);

    public final void onResponse(ChannelResponse response) {
        if (response.getErrorCode().intValue() == ChannelMessageError.NODES_UNREACHABLE.getError()) {
            logger.error("Local node error\uff0ctry the next local node");
            this.retrySendMessage(1);
        } else if (response.getErrorCode().intValue() == ChannelMessageError.MESSAGE_SEND_EXCEPTION.getError()) {
            logger.error("Remote node error\uff0ctry the next remote node");
            this.retrySendMessage(2);
        } else {
            try {
                this.onResponseMessage(response);
            }
            catch (Exception e) {
                logger.error("c:", (Throwable)e);
            }
            if (this.message.getSeq() != null) {
                this.service.getSeq2Callback().remove(this.message.getSeq());
            }
            if (this.timeout != null) {
                this.timeout.cancel();
            }
        }
    }

    public final void onTimeout() {
        logger.error("send message timeout:{}", (Object)this.message.getSeq());
        ChannelResponse response = new ChannelResponse();
        response.setErrorCode(ChannelMessageError.MESSAGE_TIMEOUT.getError());
        response.setMessageID(this.message.getSeq());
        response.setErrorMessage("send message timeout");
        response.setContent("");
        try {
            this.onResponseMessage(response);
        }
        catch (Exception e) {
            logger.error("timeout processing error:", (Throwable)e);
        }
        this.service.getSeq2Callback().remove(this.message.getSeq());
        this.timeout.cancel();
    }

    public void retrySendMessage(Integer errorType) {
        Integer errorCode = 0;
        try {
            Boolean res;
            Integer index;
            SecureRandom random;
            if (errorType == 1 || errorType == 0) {
                this.message.setFromNode("");
                logger.debug("Number of local nodes:{}", (Object)this.fromConnectionInfos.size());
                if (this.fromConnectionInfos.size() > 0) {
                    random = new SecureRandom();
                    index = random.nextInt(this.fromConnectionInfos.size());
                    logger.debug("selected:{}", (Object)index);
                    this.setFromConnection(this.fromConnectionInfos.get(index));
                    this.message.setFromNode(this.getFromConnection().getNodeID());
                    res = this.fromConnectionInfos.remove(this.fromConnectionInfos.get(index));
                    logger.debug("Number of local nodes after processing:{} {}", (Object)res, (Object)this.fromConnectionInfos.size());
                }
                if (this.message.getFromNode().isEmpty()) {
                    logger.error("All local nodes are unavailable");
                    errorCode = ChannelMessageError.NODES_UNREACHABLE.getError();
                    throw new Exception("All local nodes are unavailable");
                }
            }
            if (errorType == 2 || errorType == 0) {
                this.message.setToNode("");
                logger.debug("Number of peer nodes:{}", (Object)this.toConnectionInfos.size());
                if (this.toConnectionInfos.size() > 0) {
                    random = new SecureRandom();
                    index = random.nextInt(this.toConnectionInfos.size());
                    logger.debug("selected:{}", (Object)index);
                    this.setToConnection(this.toConnectionInfos.get(index));
                    this.message.setToNode(this.getToConnection().getNodeID());
                    res = this.toConnectionInfos.remove(this.toConnectionInfos.get(index));
                    logger.debug("Number of peer nodes after processing:{} {}", (Object)res, (Object)this.toConnectionInfos.size());
                }
                if (this.message.getToNode().isEmpty()) {
                    logger.error("All peer nodes are unavailable");
                    errorCode = 103;
                    throw new Exception("All peer nodes are unavailable");
                }
            }
            logger.debug("try from {} send to:{}", (Object)this.message.getFromNode(), (Object)this.message.getToNode());
            this.message.setFromNode(this.fromConnection.getNodeID());
            ChannelHandlerContext ctx = this.fromChannelConnections.getNetworkConnectionByHost(this.getFromConnection().getHost(), this.getFromConnection().getPort());
            if (ctx != null && ChannelHandlerContextHelper.isChannelAvailable(ctx)) {
                ByteBuf out = ctx.alloc().buffer();
                this.message.writeHeader(out);
                this.message.writeExtra(out);
                ctx.writeAndFlush((Object)out);
                logger.debug("send message to " + this.fromConnection.getHost() + ":" + String.valueOf(this.fromConnection.getPort()) + " success");
            } else {
                logger.error("sending node unavailable");
                this.retrySendMessage(1);
            }
        }
        catch (Exception e) {
            logger.error("send message exception ", (Throwable)e);
            ChannelResponse response = new ChannelResponse();
            response.setErrorCode(errorCode);
            response.setErrorMessage(e.getMessage());
            try {
                this.onResponseMessage(response);
            }
            catch (Exception ee) {
                logger.error("onResponseMessage error:", (Throwable)ee);
            }
            if (this.message.getSeq() != null) {
                this.service.getSeq2Callback().remove(this.message.getSeq());
            }
            if (this.timeout != null) {
                this.timeout.cancel();
            }
            return;
        }
    }

    public ConnectionInfo getFromConnection() {
        return this.fromConnection;
    }

    public void setFromConnection(ConnectionInfo fromConnection) {
        this.fromConnection = fromConnection;
    }

    public ConnectionInfo getToConnection() {
        return this.toConnection;
    }

    public void setToConnection(ConnectionInfo toConnection) {
        this.toConnection = toConnection;
    }

    public List<ConnectionInfo> getFromConnectionInfos() {
        return this.fromConnectionInfos;
    }

    public void setFromConnectionInfos(List<ConnectionInfo> fromConnectionInfos) {
        this.fromConnectionInfos = fromConnectionInfos;
    }

    public ChannelConnections getFromChannelConnections() {
        return this.fromChannelConnections;
    }

    public void setFromChannelConnections(ChannelConnections fromConnectionConnections) {
        this.fromChannelConnections = fromConnectionConnections;
    }

    public List<ConnectionInfo> getToConnectionInfos() {
        return this.toConnectionInfos;
    }

    public void setToConnectionInfos(List<ConnectionInfo> connectionInfos) {
        this.toConnectionInfos = connectionInfos;
    }

    public ChannelMessage getRequest() {
        return this.message;
    }

    public void setRequest(ChannelMessage message) {
        this.message = message;
    }

    public Service getService() {
        return this.service;
    }

    public void setService(Service service) {
        this.service = service;
    }

    public Timeout getTimeout() {
        return this.timeout;
    }

    public void setTimeout(Timeout timeout) {
        this.timeout = timeout;
    }
}

