/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.event.filter;

import io.netty.channel.ChannelHandlerContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.fisco.bcos.channel.client.Service;
import org.fisco.bcos.channel.event.filter.EventLogFilter;
import org.fisco.bcos.channel.event.filter.EventLogFilterStatus;
import org.fisco.bcos.channel.event.filter.EventLogPushCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLogFilterManager {
    private static final Logger logger = LoggerFactory.getLogger(EventLogFilterManager.class);
    private boolean running = false;
    private int sendThreadSleepMS = 10000;
    private Service channelService;
    private Map<String, EventLogFilter> registerIDToFilter = new ConcurrentHashMap<String, EventLogFilter>();
    private Map<String, Object> filterIDToCallback = new ConcurrentHashMap<String, Object>();

    public EventLogFilterManager(Service channelService) {
        this.channelService = channelService;
    }

    public EventLogPushCallback getFilterCallback(String filterID) {
        Object object = this.filterIDToCallback.get(filterID);
        return null == object ? null : (EventLogPushCallback)object;
    }

    public void removeCallback(String filterID) {
        this.filterIDToCallback.remove(filterID);
        logger.info("remove callback, filterID: {}", (Object)filterID);
    }

    public void addCallback(String filterID, EventLogPushCallback callback) {
        this.filterIDToCallback.put(filterID, callback);
        logger.info("add callback, filterID: {}", (Object)filterID);
    }

    public void addEventLogFilter(EventLogFilter filter) {
        this.registerIDToFilter.put(filter.getRegisterID(), filter);
        logger.info("add, registerID: {}, filter: {}", (Object)filter.getRegisterID(), (Object)filter);
    }

    public void removeFilterAndCallback(String registerID, String filterID) {
        this.registerIDToFilter.remove(registerID);
        this.filterIDToCallback.remove(filterID);
        logger.info("remove event log filter, registerID: {}, filterID: {}", (Object)registerID, (Object)filterID);
    }

    public void removeFilter(String registerID) {
        this.registerIDToFilter.remove(registerID);
        logger.info("remove event log filter, registerID: {}", (Object)registerID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEventLogFilter(EventLogFilter filter, EventLogFilterStatus status, ChannelHandlerContext ctx) {
        EventLogFilterManager eventLogFilterManager = this;
        synchronized (eventLogFilterManager) {
            filter.setStatus(status);
            filter.setCtx(ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateEventLogFilterStatus(ChannelHandlerContext ctx) {
        EventLogFilterManager eventLogFilterManager = this;
        synchronized (eventLogFilterManager) {
            for (EventLogFilter filter : this.registerIDToFilter.values()) {
                if (filter.getCtx() != ctx) continue;
                filter.setCtx(null);
                filter.setStatus(EventLogFilterStatus.WAITING_REQUEST);
                this.removeCallback(filter.getFilterID());
                logger.info(" disconnect, update event filter status, ctx: {}, status: {}, registerID: {}, filterID: {}, filter: {}", new Object[]{System.identityHashCode(ctx), filter.getStatus(), filter.getFilterID(), filter.getRegisterID(), filter});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<EventLogFilter> getSendFilter() {
        ArrayList<EventLogFilter> filters = new ArrayList<EventLogFilter>();
        EventLogFilterManager eventLogFilterManager = this;
        synchronized (eventLogFilterManager) {
            for (EventLogFilter filter : this.registerIDToFilter.values()) {
                if (filter.getStatus() != EventLogFilterStatus.WAITING_REQUEST) continue;
                logger.info(" resend filter, update event filter status: {}, registerID: {}, filter: {}", new Object[]{filter.getStatus(), filter.getRegisterID(), filter});
                filters.add(filter);
                filter.setStatus(EventLogFilterStatus.WAITING_RESPONSE);
            }
        }
        return filters;
    }

    public void stop() {
        this.running = false;
    }

    public void start() {
        if (this.running) {
            return;
        }
        this.running = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                while (EventLogFilterManager.this.running) {
                    int sendCount = EventLogFilterManager.this.sendFilter();
                    if (sendCount > 0) {
                        logger.info(" resend filter size, count: {}", (Object)sendCount);
                    }
                    try {
                        Thread.sleep(EventLogFilterManager.this.sendThreadSleepMS);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    logger.trace(" event filter manager, filter: {}, callback: {}", (Object)EventLogFilterManager.this.registerIDToFilter.size(), (Object)EventLogFilterManager.this.filterIDToCallback.size());
                }
                return;
            }
        }).start();
    }

    public int sendFilter() {
        List<EventLogFilter> filters = this.getSendFilter();
        for (EventLogFilter filter : filters) {
            this.channelService.asyncSendRegisterEventLogFilterMessage(filter);
        }
        return filters.size();
    }

    public Service getChannelService() {
        return this.channelService;
    }

    public void setChannelService(Service channelService) {
        this.channelService = channelService;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public Map<String, Object> getFilterIDToCallback() {
        return this.filterIDToCallback;
    }

    public void setFilterIDToCallback(Map<String, Object> filterIDToCallback) {
        this.filterIDToCallback = filterIDToCallback;
    }
}

