/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.channel.handler;

import io.netty.buffer.ByteBuf;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Message
implements Serializable {
    private static Logger logger = LoggerFactory.getLogger(Message.class);
    private static final long serialVersionUID = -7276897518418560354L;
    public static final int HEADER_LENGTH = 42;
    protected Integer length = 0;
    protected Short type = 0;
    protected String seq = "";
    protected Integer result = 0;
    protected byte[] data;

    public void readHeader(ByteBuf in) {
        this.length = in.readInt();
        this.type = in.readShort();
        byte[] dst = new byte[32];
        in.readBytes(dst);
        try {
            this.seq = new String(dst, "utf-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.result = in.readInt();
    }

    public void readExtra(ByteBuf in) {
        this.data = new byte[this.length - 42];
        in.readBytes(this.data, 0, this.length - 42);
    }

    public void writeHeader(ByteBuf out) {
        if (this.length.equals(0)) {
            this.length = 42 + this.data.length;
        }
        out.writeInt(this.length.intValue());
        out.writeShort((int)this.type.shortValue());
        out.writeBytes(this.seq.getBytes(), 0, 32);
        out.writeInt(this.result.intValue());
    }

    public void writeExtra(ByteBuf out) {
        out.writeBytes(this.data);
    }

    public Integer getLength() {
        return this.length;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public Short getType() {
        return this.type;
    }

    public void setType(Short type) {
        this.type = type;
    }

    public String getSeq() {
        return this.seq;
    }

    public void setSeq(String seq) {
        this.seq = seq;
    }

    public Integer getResult() {
        return this.result;
    }

    public void setResult(Integer result) {
        this.result = result;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setData(byte[] data) {
        this.data = data;
        this.length = data.length + 42;
    }
}

