/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.crypto.gm.sm2;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.digests.SM3Digest;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.params.ParametersWithID;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.RandomDSAKCalculator;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECMultiplier;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SM2Signer
implements Signer,
ECConstants {
    private static final Logger logger = LoggerFactory.getLogger(SM2Signer.class);
    private final DSAKCalculator kCalculator = new RandomDSAKCalculator();
    private final SM3Digest digest = new SM3Digest();
    private ECDomainParameters ecParams;
    private ECPoint pubPoint;
    private ECKeyParameters ecKey;
    private byte[] z;
    private static Map<BigInteger, byte[]> zValueCache = new ConcurrentHashMap<BigInteger, byte[]>();

    public void init(boolean forSigning, CipherParameters param) {
        byte[] userID;
        CipherParameters baseParam;
        if (param instanceof ParametersWithID) {
            baseParam = ((ParametersWithID)param).getParameters();
            userID = ((ParametersWithID)param).getID();
        } else {
            baseParam = param;
            userID = Hex.decode((String)"31323334353637383132333435363738");
        }
        if (forSigning) {
            if (baseParam instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)baseParam;
                this.ecKey = (ECKeyParameters)rParam.getParameters();
                this.ecParams = this.ecKey.getParameters();
                this.kCalculator.init(this.ecParams.getN(), rParam.getRandom());
            } else {
                this.ecKey = (ECKeyParameters)baseParam;
                this.ecParams = this.ecKey.getParameters();
                this.kCalculator.init(this.ecParams.getN(), CryptoServicesRegistrar.getSecureRandom());
            }
            this.pubPoint = SM2Signer.createBasePointMultiplier().multiply(this.ecParams.getG(), ((ECPrivateKeyParameters)this.ecKey).getD()).normalize();
        } else {
            this.ecKey = (ECKeyParameters)baseParam;
            this.ecParams = this.ecKey.getParameters();
            this.pubPoint = ((ECPublicKeyParameters)this.ecKey).getQ();
        }
        this.z = this.getZ(userID);
        this.digest.update(this.z, 0, this.z.length);
    }

    public void initWithCache(boolean forSigning, CipherParameters param) {
        byte[] userID;
        CipherParameters baseParam;
        if (param instanceof ParametersWithID) {
            baseParam = ((ParametersWithID)param).getParameters();
            userID = ((ParametersWithID)param).getID();
        } else {
            baseParam = param;
            userID = Hex.decode((String)"31323334353637383132333435363738");
        }
        if (forSigning) {
            if (baseParam instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)baseParam;
                this.ecKey = (ECKeyParameters)rParam.getParameters();
                this.ecParams = this.ecKey.getParameters();
                this.kCalculator.init(this.ecParams.getN(), rParam.getRandom());
            } else {
                this.ecKey = (ECKeyParameters)baseParam;
                this.ecParams = this.ecKey.getParameters();
                this.kCalculator.init(this.ecParams.getN(), CryptoServicesRegistrar.getSecureRandom());
            }
            BigInteger privateKey = ((ECPrivateKeyParameters)this.ecKey).getD();
            this.z = zValueCache.get(privateKey);
            if (Objects.isNull(this.z)) {
                this.pubPoint = SM2Signer.createBasePointMultiplier().multiply(this.ecParams.getG(), ((ECPrivateKeyParameters)this.ecKey).getD()).normalize();
                this.z = this.getZ(userID);
                zValueCache.put(privateKey, this.z);
                logger.info(" privateKey: {} z value not exist, caculate z: {}", (Object)privateKey, (Object)Hex.toHexString((byte[])this.z));
            } else if (logger.isDebugEnabled()) {
                logger.debug(" privateKey: {} z value, z: {}", (Object)privateKey, (Object)Hex.toHexString((byte[])this.z));
            }
            this.digest.update(this.z, 0, this.z.length);
        } else {
            this.ecKey = (ECKeyParameters)baseParam;
            this.ecParams = this.ecKey.getParameters();
            this.pubPoint = ((ECPublicKeyParameters)this.ecKey).getQ();
            this.z = this.getZ(userID);
            this.digest.update(this.z, 0, this.z.length);
        }
    }

    public void update(byte b) {
        this.digest.update(b);
    }

    public void update(byte[] in, int off, int len) {
        this.digest.update(in, off, len);
    }

    public void updateMessage(byte[] in, int off, int len) {
        this.digest.reset();
        this.digest.update(in, 0, in.length);
        byte[] md = this.digestDoFinal();
        this.digest.update(this.z, 0, this.z.length);
        this.digest.update(md, 0, md.length);
    }

    public boolean verifySignature(byte[] signature) {
        try {
            BigInteger[] rs = this.derDecode(signature);
            if (rs != null) {
                return this.verifySignature(rs[0], rs[1]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public void reset() {
        this.digest.reset();
        if (this.z != null) {
            this.digest.update(this.z, 0, this.z.length);
        }
    }

    public byte[] generateSignature() throws CryptoException {
        BigInteger s;
        BigInteger r;
        byte[] eHash = this.digestDoFinal();
        BigInteger n = this.ecParams.getN();
        BigInteger e = this.calculateE(eHash);
        BigInteger d = ((ECPrivateKeyParameters)this.ecKey).getD();
        ECMultiplier basePointMultiplier = SM2Signer.createBasePointMultiplier();
        while (true) {
            BigInteger k = this.kCalculator.nextK();
            ECPoint p = basePointMultiplier.multiply(this.ecParams.getG(), k).normalize();
            r = e.add(p.getAffineXCoord().toBigInteger()).mod(n);
            if (r.equals(ZERO) || r.add(k).equals(n)) continue;
            BigInteger dPlus1ModN = d.add(ONE).modInverse(n);
            s = k.subtract(r.multiply(d)).mod(n);
            if (!(s = dPlus1ModN.multiply(s).mod(n)).equals(ZERO)) break;
        }
        try {
            return this.derEncode(r, s);
        }
        catch (IOException ex) {
            throw new CryptoException("unable to encode signature: " + ex.getMessage(), (Throwable)ex);
        }
    }

    public BigInteger[] generateSignature2() throws CryptoException {
        BigInteger s;
        BigInteger r;
        byte[] eHash = this.digestDoFinal();
        BigInteger n = this.ecParams.getN();
        BigInteger e = this.calculateE(eHash);
        BigInteger d = ((ECPrivateKeyParameters)this.ecKey).getD();
        ECMultiplier basePointMultiplier = SM2Signer.createBasePointMultiplier();
        while (true) {
            BigInteger k = this.kCalculator.nextK();
            ECPoint p = basePointMultiplier.multiply(this.ecParams.getG(), k).normalize();
            r = e.add(p.getAffineXCoord().toBigInteger()).mod(n);
            if (r.equals(ZERO) || r.add(k).equals(n)) continue;
            BigInteger dPlus1ModN = d.add(ONE).modInverse(n);
            s = k.subtract(r.multiply(d)).mod(n);
            if (!(s = dPlus1ModN.multiply(s).mod(n)).equals(ZERO)) break;
        }
        return new BigInteger[]{r, s};
    }

    private boolean verifySignature(BigInteger r, BigInteger s) {
        BigInteger n = this.ecParams.getN();
        if (r.compareTo(ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        byte[] eHash = this.digestDoFinal();
        BigInteger e = this.calculateE(eHash);
        BigInteger t = r.add(s).mod(n);
        if (t.equals(ZERO)) {
            return false;
        }
        ECPoint q = ((ECPublicKeyParameters)this.ecKey).getQ();
        ECPoint x1y1 = ECAlgorithms.sumOfTwoMultiplies((ECPoint)this.ecParams.getG(), (BigInteger)s, (ECPoint)q, (BigInteger)t).normalize();
        if (x1y1.isInfinity()) {
            return false;
        }
        BigInteger expectedR = e.add(x1y1.getAffineXCoord().toBigInteger()).mod(n);
        return expectedR.equals(r);
    }

    private byte[] digestDoFinal() {
        byte[] result = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(result, 0);
        this.reset();
        return result;
    }

    private byte[] getZ(byte[] userID) {
        this.digest.reset();
        this.addUserID((Digest)this.digest, userID);
        this.addFieldElement((Digest)this.digest, this.ecParams.getCurve().getA());
        this.addFieldElement((Digest)this.digest, this.ecParams.getCurve().getB());
        this.addFieldElement((Digest)this.digest, this.ecParams.getG().getAffineXCoord());
        this.addFieldElement((Digest)this.digest, this.ecParams.getG().getAffineYCoord());
        this.addFieldElement((Digest)this.digest, this.pubPoint.getAffineXCoord());
        this.addFieldElement((Digest)this.digest, this.pubPoint.getAffineYCoord());
        byte[] result = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(result, 0);
        return result;
    }

    private void addUserID(Digest digest, byte[] userID) {
        int len = userID.length * 8;
        digest.update((byte)(len >> 8 & 0xFF));
        digest.update((byte)(len & 0xFF));
        digest.update(userID, 0, userID.length);
    }

    private void addFieldElement(Digest digest, ECFieldElement v) {
        byte[] p = v.getEncoded();
        digest.update(p, 0, p.length);
    }

    protected static ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    protected BigInteger calculateE(byte[] message) {
        return new BigInteger(1, message);
    }

    public BigInteger[] derDecode(byte[] encoding) throws IOException {
        BigInteger s;
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)ASN1Primitive.fromByteArray((byte[])encoding));
        if (seq.size() != 2) {
            return null;
        }
        BigInteger r = ASN1Integer.getInstance((Object)seq.getObjectAt(0)).getValue();
        byte[] expectedEncoding = this.derEncode(r, s = ASN1Integer.getInstance((Object)seq.getObjectAt(1)).getValue());
        if (!Arrays.constantTimeAreEqual((byte[])expectedEncoding, (byte[])encoding)) {
            return null;
        }
        return new BigInteger[]{r, s};
    }

    public byte[] derEncode(BigInteger r, BigInteger s) throws IOException {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)new ASN1Integer(r));
        v.add((ASN1Encodable)new ASN1Integer(s));
        return new DERSequence(v).getEncoded("DER");
    }
}

