/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.precompile.crud;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import org.fisco.bcos.channel.client.TransactionSucCallback;
import org.fisco.bcos.web3j.abi.TypeReference;
import org.fisco.bcos.web3j.abi.datatypes.Function;
import org.fisco.bcos.web3j.abi.datatypes.Utf8String;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.RemoteCall;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.tx.Contract;
import org.fisco.bcos.web3j.tx.TransactionManager;
import org.fisco.bcos.web3j.tx.gas.ContractGasProvider;

public class CRUD
extends Contract {
    private static final String BINARY = "";
    public static final String FUNC_UPDATE = "update";
    public static final String FUNC_SELECT = "select";
    public static final String FUNC_INSERT = "insert";
    public static final String FUNC_REMOVE = "remove";

    @Deprecated
    protected CRUD(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    protected CRUD(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, credentials, contractGasProvider);
    }

    @Deprecated
    protected CRUD(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        super(BINARY, contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    protected CRUD(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        super(BINARY, contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public RemoteCall<TransactionReceipt> update(String tableName, String key, String entry, String condition, String optional) {
        Function function = new Function(FUNC_UPDATE, Arrays.asList(new Utf8String(tableName), new Utf8String(key), new Utf8String(entry), new Utf8String(condition), new Utf8String(optional)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public void update(String tableName, String key, String entry, String condition, String optional, TransactionSucCallback callback) {
        Function function = new Function(FUNC_UPDATE, Arrays.asList(new Utf8String(tableName), new Utf8String(key), new Utf8String(entry), new Utf8String(condition), new Utf8String(optional)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public RemoteCall<String> select(String tableName, String key, String condition, String optional) {
        Function function = new Function(FUNC_SELECT, Arrays.asList(new Utf8String(tableName), new Utf8String(key), new Utf8String(condition), new Utf8String(optional)), Arrays.asList(new TypeReference<Utf8String>(){}));
        return this.executeRemoteCallSingleValueReturn(function, String.class);
    }

    public RemoteCall<TransactionReceipt> insert(String tableName, String key, String entry, String optional) {
        Function function = new Function(FUNC_INSERT, Arrays.asList(new Utf8String(tableName), new Utf8String(key), new Utf8String(entry), new Utf8String(optional)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public void insert(String tableName, String key, String entry, String optional, TransactionSucCallback callback) {
        Function function = new Function(FUNC_INSERT, Arrays.asList(new Utf8String(tableName), new Utf8String(key), new Utf8String(entry), new Utf8String(optional)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    public RemoteCall<TransactionReceipt> remove(String tableName, String key, String condition, String optional) {
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Utf8String(tableName), new Utf8String(key), new Utf8String(condition), new Utf8String(optional)), Collections.emptyList());
        return this.executeRemoteCallTransaction(function);
    }

    public void remove(String tableName, String key, String condition, String optional, TransactionSucCallback callback) {
        Function function = new Function(FUNC_REMOVE, Arrays.asList(new Utf8String(tableName), new Utf8String(key), new Utf8String(condition), new Utf8String(optional)), Collections.emptyList());
        this.asyncExecuteTransaction(function, callback);
    }

    @Deprecated
    public static CRUD load(String contractAddress, Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return new CRUD(contractAddress, web3j, credentials, gasPrice, gasLimit);
    }

    @Deprecated
    public static CRUD load(String contractAddress, Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return new CRUD(contractAddress, web3j, transactionManager, gasPrice, gasLimit);
    }

    public static CRUD load(String contractAddress, Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return new CRUD(contractAddress, web3j, credentials, contractGasProvider);
    }

    public static CRUD load(String contractAddress, Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return new CRUD(contractAddress, web3j, transactionManager, contractGasProvider);
    }

    public static RemoteCall<CRUD> deploy(Web3j web3j, Credentials credentials, ContractGasProvider contractGasProvider) {
        return CRUD.deployRemoteCall(CRUD.class, web3j, credentials, contractGasProvider, BINARY, BINARY);
    }

    @Deprecated
    public static RemoteCall<CRUD> deploy(Web3j web3j, Credentials credentials, BigInteger gasPrice, BigInteger gasLimit) {
        return CRUD.deployRemoteCall(CRUD.class, web3j, credentials, gasPrice, gasLimit, BINARY, BINARY);
    }

    public static RemoteCall<CRUD> deploy(Web3j web3j, TransactionManager transactionManager, ContractGasProvider contractGasProvider) {
        return CRUD.deployRemoteCall(CRUD.class, web3j, transactionManager, contractGasProvider, BINARY, BINARY);
    }

    @Deprecated
    public static RemoteCall<CRUD> deploy(Web3j web3j, TransactionManager transactionManager, BigInteger gasPrice, BigInteger gasLimit) {
        return CRUD.deployRemoteCall(CRUD.class, web3j, transactionManager, gasPrice, gasLimit, BINARY, BINARY);
    }
}

