/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.precompile.permission;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.math.BigInteger;
import java.util.List;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.precompile.common.PrecompiledCommon;
import org.fisco.bcos.web3j.precompile.crud.CRUDService;
import org.fisco.bcos.web3j.precompile.permission.Permission;
import org.fisco.bcos.web3j.precompile.permission.PermissionInfo;
import org.fisco.bcos.web3j.protocol.ObjectMapperFactory;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.tx.gas.ContractGasProvider;
import org.fisco.bcos.web3j.tx.gas.StaticGasProvider;

public class PermissionService {
    private static BigInteger gasPrice = new BigInteger("300000000");
    private static BigInteger gasLimit = new BigInteger("300000000");
    private static String PermissionPrecompileAddress = "0x0000000000000000000000000000000000001005";
    private Permission permission;
    private Web3j web3j;
    private Credentials credentials;

    public PermissionService(Web3j web3j, Credentials credentials) {
        StaticGasProvider contractGasProvider = new StaticGasProvider(gasPrice, gasLimit);
        this.permission = Permission.load(PermissionPrecompileAddress, web3j, credentials, (ContractGasProvider)contractGasProvider);
        this.web3j = web3j;
        this.credentials = credentials;
    }

    public List<PermissionInfo> queryPermission(String address) throws Exception {
        String permissionyInfo = this.permission.queryPermission(address).send();
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        return (List)objectMapper.readValue(permissionyInfo, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, PermissionInfo.class));
    }

    public String grantWrite(String address, String user) throws Exception {
        TransactionReceipt receipt = this.permission.grantWrite(address, user).send();
        return PrecompiledCommon.handleTransactionReceipt(receipt, this.web3j);
    }

    public String revokeWrite(String address, String user) throws Exception {
        TransactionReceipt receipt = this.permission.revokeWrite(address, user).send();
        return PrecompiledCommon.handleTransactionReceipt(receipt, this.web3j);
    }

    public String grantUserTableManager(String tableName, String grantress) throws Exception {
        CRUDService crudSerivce = new CRUDService(this.web3j, this.credentials);
        crudSerivce.desc(tableName);
        return this.grant(tableName, grantress);
    }

    public String revokeUserTableManager(String tableName, String grantress) throws Exception {
        return this.revoke(tableName, grantress);
    }

    public List<PermissionInfo> listUserTableManager(String tableName) throws Exception {
        return this.list(tableName);
    }

    public String grantDeployAndCreateManager(String grantress) throws Exception {
        return this.grant("_sys_tables_", grantress);
    }

    public String revokeDeployAndCreateManager(String grantress) throws Exception {
        return this.revoke("_sys_tables_", grantress);
    }

    public List<PermissionInfo> listDeployAndCreateManager() throws Exception {
        return this.list("_sys_tables_");
    }

    public String grantPermissionManager(String grantress) throws Exception {
        return this.grant("_sys_table_access_", grantress);
    }

    public String revokePermissionManager(String grantress) throws Exception {
        return this.revoke("_sys_table_access_", grantress);
    }

    public List<PermissionInfo> listPermissionManager() throws Exception {
        return this.list("_sys_table_access_");
    }

    public String grantNodeManager(String grantress) throws Exception {
        return this.grant("_sys_consensus_", grantress);
    }

    public String revokeNodeManager(String grantress) throws Exception {
        return this.revoke("_sys_consensus_", grantress);
    }

    public List<PermissionInfo> listNodeManager() throws Exception {
        return this.list("_sys_consensus_");
    }

    public String grantCNSManager(String grantress) throws Exception {
        return this.grant("_sys_cns_", grantress);
    }

    public String revokeCNSManager(String grantress) throws Exception {
        return this.revoke("_sys_cns_", grantress);
    }

    public List<PermissionInfo> listCNSManager() throws Exception {
        return this.list("_sys_cns_");
    }

    public String grantSysConfigManager(String grantress) throws Exception {
        return this.grant("_sys_config_", grantress);
    }

    public String revokeSysConfigManager(String grantress) throws Exception {
        return this.revoke("_sys_config_", grantress);
    }

    public List<PermissionInfo> listSysConfigManager() throws Exception {
        return this.list("_sys_config_");
    }

    private String grant(String tableName, String grantress) throws Exception {
        TransactionReceipt receipt = this.permission.insert(tableName, grantress).send();
        return PrecompiledCommon.handleTransactionReceipt(receipt, this.web3j);
    }

    private String revoke(String tableName, String address) throws Exception {
        TransactionReceipt receipt = this.permission.remove(tableName, address).send();
        return PrecompiledCommon.handleTransactionReceipt(receipt, this.web3j);
    }

    private List<PermissionInfo> list(String tableName) throws Exception {
        String permissionyInfo = this.permission.queryByName(tableName).send();
        ObjectMapper objectMapper = ObjectMapperFactory.getObjectMapper();
        return (List)objectMapper.readValue(permissionyInfo, (JavaType)objectMapper.getTypeFactory().constructCollectionType(List.class, PermissionInfo.class));
    }
}

