/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.protocol.core;

import io.reactivex.Flowable;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import org.fisco.bcos.channel.client.TransactionSucCallback;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.Web3jService;
import org.fisco.bcos.web3j.protocol.channel.ChannelEthereumService;
import org.fisco.bcos.web3j.protocol.core.DefaultBlockParameter;
import org.fisco.bcos.web3j.protocol.core.Request;
import org.fisco.bcos.web3j.protocol.core.methods.response.BcosBlock;
import org.fisco.bcos.web3j.protocol.core.methods.response.BcosFilter;
import org.fisco.bcos.web3j.protocol.core.methods.response.BcosLog;
import org.fisco.bcos.web3j.protocol.core.methods.response.BcosSubscribe;
import org.fisco.bcos.web3j.protocol.core.methods.response.BcosTransaction;
import org.fisco.bcos.web3j.protocol.core.methods.response.BcosTransactionReceipt;
import org.fisco.bcos.web3j.protocol.core.methods.response.BlockHash;
import org.fisco.bcos.web3j.protocol.core.methods.response.BlockNumber;
import org.fisco.bcos.web3j.protocol.core.methods.response.Call;
import org.fisco.bcos.web3j.protocol.core.methods.response.Code;
import org.fisco.bcos.web3j.protocol.core.methods.response.ConsensusStatus;
import org.fisco.bcos.web3j.protocol.core.methods.response.GenerateGroup;
import org.fisco.bcos.web3j.protocol.core.methods.response.GroupList;
import org.fisco.bcos.web3j.protocol.core.methods.response.GroupPeers;
import org.fisco.bcos.web3j.protocol.core.methods.response.Log;
import org.fisco.bcos.web3j.protocol.core.methods.response.NodeIDList;
import org.fisco.bcos.web3j.protocol.core.methods.response.NodeVersion;
import org.fisco.bcos.web3j.protocol.core.methods.response.ObserverList;
import org.fisco.bcos.web3j.protocol.core.methods.response.PbftView;
import org.fisco.bcos.web3j.protocol.core.methods.response.Peers;
import org.fisco.bcos.web3j.protocol.core.methods.response.PendingTransactions;
import org.fisco.bcos.web3j.protocol.core.methods.response.PendingTxSize;
import org.fisco.bcos.web3j.protocol.core.methods.response.SealerList;
import org.fisco.bcos.web3j.protocol.core.methods.response.SendTransaction;
import org.fisco.bcos.web3j.protocol.core.methods.response.StartGroup;
import org.fisco.bcos.web3j.protocol.core.methods.response.SyncStatus;
import org.fisco.bcos.web3j.protocol.core.methods.response.SystemConfig;
import org.fisco.bcos.web3j.protocol.core.methods.response.TotalTransactionCount;
import org.fisco.bcos.web3j.protocol.core.methods.response.Transaction;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceiptWithProof;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionWithProof;
import org.fisco.bcos.web3j.protocol.core.methods.response.UninstallFilter;
import org.fisco.bcos.web3j.protocol.rx.JsonRpc2_0Rx;
import org.fisco.bcos.web3j.protocol.websocket.events.LogNotification;
import org.fisco.bcos.web3j.protocol.websocket.events.NewHeadsNotification;
import org.fisco.bcos.web3j.utils.Async;
import org.fisco.bcos.web3j.utils.BlockLimit;
import org.fisco.bcos.web3j.utils.Numeric;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonRpc2_0Web3j
implements Web3j {
    static Logger logger = LoggerFactory.getLogger(JsonRpc2_0Web3j.class);
    protected static final long ID = 1L;
    public static final int BLOCK_TIME = 1500;
    public static final int DEFAULT_BLOCK_TIME = 15000;
    protected final Web3jService web3jService;
    private final JsonRpc2_0Rx web3jRx;
    private final long blockTime;
    private final ScheduledExecutorService scheduledExecutorService;
    private int groupId = 1;

    public Web3jService web3jService() {
        return this.web3jService;
    }

    public BigInteger getLocalBlockNumber() {
        return ((ChannelEthereumService)this.web3jService).getChannelService().getNumber();
    }

    public synchronized void setBlockNumber(BigInteger blockNumber) {
        if (blockNumber.compareTo(((ChannelEthereumService)this.web3jService).getChannelService().getNumber()) > 0) {
            ((ChannelEthereumService)this.web3jService).getChannelService().setNumber(blockNumber);
        }
    }

    public JsonRpc2_0Web3j(Web3jService web3jService) {
        this(web3jService, 15000L, Async.defaultExecutorService(), 1);
    }

    public JsonRpc2_0Web3j(Web3jService web3jService, int groupId) {
        this(web3jService, 15000L, Async.defaultExecutorService(), groupId);
        this.groupId = groupId;
    }

    public JsonRpc2_0Web3j(Web3jService web3jService, long pollingInterval, ScheduledExecutorService scheduledExecutorService, int groupId) {
        this.web3jService = web3jService;
        this.web3jRx = new JsonRpc2_0Rx(this, scheduledExecutorService);
        this.blockTime = pollingInterval;
        this.scheduledExecutorService = scheduledExecutorService;
        this.groupId = groupId;
    }

    @Override
    public Request<?, NodeVersion> getNodeVersion() {
        return new Request<Object, NodeVersion>("getClientVersion", Arrays.asList(new Object[0]), this.web3jService, NodeVersion.class);
    }

    @Override
    public synchronized Request<?, BlockNumber> getBlockNumber() {
        return new Request<Integer, BlockNumber>("getBlockNumber", Arrays.asList(this.groupId), this.web3jService, BlockNumber.class);
    }

    @Override
    public BigInteger getBlockNumberCache() {
        if (this.getLocalBlockNumber().intValue() == 1) {
            try {
                BlockNumber blockNumber = this.getBlockNumber().sendAsync().get();
                this.setBlockNumber(blockNumber.getBlockNumber());
            }
            catch (Exception e) {
                logger.error("Exception: " + e);
            }
        }
        return this.getLocalBlockNumber().add(new BigInteger(BlockLimit.blockLimit.toString()));
    }

    @Override
    public Request<?, GroupList> getGroupList() {
        return new Request<Object, GroupList>("getGroupList", Arrays.asList(new Object[0]), this.web3jService, GroupList.class);
    }

    @Override
    public Request<?, SealerList> getSealerList() {
        return new Request<Integer, SealerList>("getSealerList", Arrays.asList(this.groupId), this.web3jService, SealerList.class);
    }

    @Override
    public Request<?, ObserverList> getObserverList() {
        return new Request<Integer, ObserverList>("getObserverList", Arrays.asList(this.groupId), this.web3jService, ObserverList.class);
    }

    @Override
    public Request<?, Peers> getPeers() {
        return new Request<Integer, Peers>("getPeers", Arrays.asList(this.groupId), this.web3jService, Peers.class);
    }

    @Override
    public Request<?, NodeIDList> getNodeIDList() {
        return new Request<Integer, NodeIDList>("getNodeIDList", Arrays.asList(this.groupId), this.web3jService, NodeIDList.class);
    }

    @Override
    public Request<?, SystemConfig> getSystemConfigByKey(String key) {
        return new Request<Serializable, SystemConfig>("getSystemConfigByKey", Arrays.asList(this.groupId, key), this.web3jService, SystemConfig.class);
    }

    @Override
    public Request<?, SyncStatus> getSyncStatus() {
        return new Request<Integer, SyncStatus>("getSyncStatus", Arrays.asList(this.groupId), this.web3jService, SyncStatus.class);
    }

    @Override
    public Request<?, PbftView> getPbftView() {
        return new Request<Integer, PbftView>("getPbftView", Arrays.asList(this.groupId), this.web3jService, PbftView.class);
    }

    @Override
    public Request<?, ConsensusStatus> getConsensusStatus() {
        return new Request<Integer, ConsensusStatus>("getConsensusStatus", Arrays.asList(this.groupId), (ChannelEthereumService)this.web3jService, ConsensusStatus.class);
    }

    @Override
    public Request<?, Code> getCode(String address, DefaultBlockParameter defaultBlockParameter) {
        return new Request<Serializable, Code>("getCode", Arrays.asList(this.groupId, address), this.web3jService, Code.class);
    }

    @Override
    public Request<?, TotalTransactionCount> getTotalTransactionCount() {
        return new Request<Integer, TotalTransactionCount>("getTotalTransactionCount", Arrays.asList(this.groupId), this.web3jService, TotalTransactionCount.class);
    }

    @Override
    public Request<?, Call> call(org.fisco.bcos.web3j.protocol.core.methods.request.Transaction transaction, DefaultBlockParameter defaultBlockParameter) {
        return new Request<Object, Call>("call", Arrays.asList(this.groupId, transaction), this.web3jService, Call.class);
    }

    @Override
    public Request<?, BcosBlock> getBlockByHash(String blockHash, boolean returnFullTransactionObjects) {
        return new Request<Serializable, BcosBlock>("getBlockByHash", Arrays.asList(this.groupId, blockHash, returnFullTransactionObjects), this.web3jService, BcosBlock.class);
    }

    @Override
    public Request<?, BcosBlock> getBlockByNumber(DefaultBlockParameter defaultBlockParameter, boolean returnFullTransactionObjects) {
        return new Request<Serializable, BcosBlock>("getBlockByNumber", Arrays.asList(this.groupId, defaultBlockParameter.getValue(), returnFullTransactionObjects), this.web3jService, BcosBlock.class);
    }

    @Override
    public Request<?, BlockHash> getBlockHashByNumber(DefaultBlockParameter defaultBlockParameter) {
        return new Request<Serializable, BlockHash>("getBlockHashByNumber", Arrays.asList(this.groupId, defaultBlockParameter.getValue()), this.web3jService, BlockHash.class);
    }

    @Override
    public Request<?, BcosTransaction> getTransactionByHash(String transactionHash) {
        return new Request<Serializable, BcosTransaction>("getTransactionByHash", Arrays.asList(this.groupId, transactionHash), this.web3jService, BcosTransaction.class);
    }

    @Override
    public Request<?, TransactionWithProof> getTransactionByHashWithProof(String transactionHash) {
        return new Request<Serializable, TransactionWithProof>("getTransactionByHashWithProof", Arrays.asList(this.groupId, transactionHash), this.web3jService, TransactionWithProof.class);
    }

    @Override
    public Request<?, BcosTransaction> getTransactionByBlockHashAndIndex(String blockHash, BigInteger transactionIndex) {
        return new Request<Serializable, BcosTransaction>("getTransactionByBlockHashAndIndex", Arrays.asList(this.groupId, blockHash, Numeric.encodeQuantity(transactionIndex)), this.web3jService, BcosTransaction.class);
    }

    @Override
    public Request<?, BcosTransaction> getTransactionByBlockNumberAndIndex(DefaultBlockParameter defaultBlockParameter, BigInteger transactionIndex) {
        return new Request<Serializable, BcosTransaction>("getTransactionByBlockNumberAndIndex", Arrays.asList(this.groupId, defaultBlockParameter.getValue(), Numeric.encodeQuantity(transactionIndex)), this.web3jService, BcosTransaction.class);
    }

    @Override
    public Request<?, BcosTransactionReceipt> getTransactionReceipt(String transactionHash) {
        return new Request<Serializable, BcosTransactionReceipt>("getTransactionReceipt", Arrays.asList(this.groupId, transactionHash), this.web3jService, BcosTransactionReceipt.class);
    }

    @Override
    public Request<?, TransactionReceiptWithProof> getTransactionReceiptByHashWithProof(String transactionHash) {
        return new Request<Serializable, TransactionReceiptWithProof>("getTransactionReceiptByHashWithProof", Arrays.asList(this.groupId, transactionHash), this.web3jService, TransactionReceiptWithProof.class);
    }

    @Override
    public Request<?, PendingTransactions> getPendingTransaction() {
        return new Request<Integer, PendingTransactions>("getPendingTransactions", Arrays.asList(this.groupId), this.web3jService, PendingTransactions.class);
    }

    @Override
    public Request<?, PendingTxSize> getPendingTxSize() {
        return new Request<Integer, PendingTxSize>("getPendingTxSize", Arrays.asList(this.groupId), this.web3jService, PendingTxSize.class);
    }

    @Override
    public Request<?, SendTransaction> sendRawTransaction(String signedTransactionData) {
        return new Request<Serializable, SendTransaction>("sendRawTransaction", Arrays.asList(this.groupId, signedTransactionData), this.web3jService, SendTransaction.class);
    }

    @Override
    public void sendRawTransaction(String signedTransactionData, TransactionSucCallback callback) throws IOException {
        Request<?, SendTransaction> request = this.sendRawTransaction(signedTransactionData);
        request.setNeedTransCallback(true);
        request.setTransactionSucCallback(callback);
        request.sendOnly();
    }

    @Override
    public Request<?, GroupPeers> getGroupPeers() {
        return new Request<Integer, GroupPeers>("getGroupPeers", Arrays.asList(this.groupId), this.web3jService, GroupPeers.class);
    }

    @Override
    public Request<?, GenerateGroup> generateGroup(int groupID, int timestamp, List<String> nodeList) {
        return new Request<Object, GenerateGroup>("generateGroup", Arrays.asList(groupID, timestamp, nodeList), this.web3jService, GenerateGroup.class);
    }

    @Override
    public Request<?, StartGroup> startGroup(int groupID) {
        return new Request<Integer, StartGroup>("startGroup", Arrays.asList(groupID), this.web3jService, StartGroup.class);
    }

    @Override
    public Request<?, BcosFilter> newPendingTransactionFilter() {
        return new Request<Integer, BcosFilter>("newPendingTransactionFilter", Arrays.asList(this.groupId), this.web3jService, BcosFilter.class);
    }

    @Override
    public Request<?, BcosFilter> newBlockFilter() {
        return new Request<Integer, BcosFilter>("newBlockFilter", Arrays.asList(this.groupId), this.web3jService, BcosFilter.class);
    }

    @Override
    public Request<?, BcosLog> getFilterChanges(BigInteger filterId) {
        return new Request<Serializable, BcosLog>("getFilterChanges", Arrays.asList(this.groupId, Numeric.toHexStringWithPrefixSafe(filterId)), this.web3jService, BcosLog.class);
    }

    @Override
    public Request<?, UninstallFilter> getUninstallFilter(BigInteger filterId) {
        return new Request<Serializable, UninstallFilter>("getUninstallFilter", Arrays.asList(this.groupId, Numeric.toHexStringWithPrefixSafe(filterId)), this.web3jService, UninstallFilter.class);
    }

    @Override
    public Request<?, BcosFilter> newFilter(org.fisco.bcos.web3j.protocol.core.methods.request.BcosFilter filter) {
        return new Request<Object, BcosFilter>("newFilter", Arrays.asList(this.groupId, filter), this.web3jService, BcosFilter.class);
    }

    @Override
    public Flowable<NewHeadsNotification> newHeadsNotifications() {
        return this.web3jService.subscribe(new Request<String, BcosSubscribe>("subscribe", Collections.singletonList("newHeads"), this.web3jService, BcosSubscribe.class), "unsubscribe", NewHeadsNotification.class);
    }

    @Override
    public Flowable<LogNotification> logsNotifications(List<String> addresses, List<String> topics) {
        Map<String, Object> params = this.createLogsParams(addresses, topics);
        return this.web3jService.subscribe(new Request<Object, BcosSubscribe>("subscribe", Arrays.asList(this.groupId, "logs", params), this.web3jService, BcosSubscribe.class), "unsubscribe", LogNotification.class);
    }

    private Map<String, Object> createLogsParams(List<String> addresses, List<String> topics) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (!addresses.isEmpty()) {
            params.put("address", addresses);
        }
        if (!topics.isEmpty()) {
            params.put("topics", topics);
        }
        return params;
    }

    @Override
    public Flowable<String> blockHashFlowable() {
        return this.web3jRx.blockHashFlowable(this.blockTime);
    }

    @Override
    public Flowable<String> pendingTransactionHashFlowable() {
        return this.web3jRx.pendingTransactionHashFlowable(this.blockTime);
    }

    @Override
    public Flowable<Log> logFlowable(org.fisco.bcos.web3j.protocol.core.methods.request.BcosFilter filter) {
        return this.web3jRx.logFlowable(filter, this.blockTime);
    }

    @Override
    public Flowable<Transaction> transactionFlowable() {
        return this.web3jRx.transactionFlowable(this.blockTime);
    }

    @Override
    public Flowable<Transaction> pendingTransactionFlowable() {
        return this.web3jRx.pendingTransactionFlowable(this.blockTime);
    }

    @Override
    public Flowable<BcosBlock> blockFlowable(boolean fullTransactionObjects) {
        return this.web3jRx.blockFlowable(fullTransactionObjects, this.blockTime);
    }

    @Override
    public Flowable<BcosBlock> replayPastBlocksFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects) {
        return this.web3jRx.replayBlocksFlowable(startBlock, endBlock, fullTransactionObjects);
    }

    @Override
    public Flowable<BcosBlock> replayPastBlocksFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock, boolean fullTransactionObjects, boolean ascending) {
        return this.web3jRx.replayBlocksFlowable(startBlock, endBlock, fullTransactionObjects, ascending);
    }

    @Override
    public Flowable<BcosBlock> replayPastBlocksFlowable(DefaultBlockParameter startBlock, boolean fullTransactionObjects, Flowable<BcosBlock> onCompleteFlowable) {
        return this.web3jRx.replayPastBlocksFlowable(startBlock, fullTransactionObjects, onCompleteFlowable);
    }

    @Override
    public Flowable<BcosBlock> replayPastBlocksFlowable(DefaultBlockParameter startBlock, boolean fullTransactionObjects) {
        return this.web3jRx.replayPastBlocksFlowable(startBlock, fullTransactionObjects);
    }

    @Override
    public Flowable<Transaction> replayPastTransactionsFlowable(DefaultBlockParameter startBlock, DefaultBlockParameter endBlock) {
        return this.web3jRx.replayTransactionsFlowable(startBlock, endBlock);
    }

    @Override
    public Flowable<Transaction> replayPastTransactionsFlowable(DefaultBlockParameter startBlock) {
        return this.web3jRx.replayPastTransactionsFlowable(startBlock);
    }

    @Override
    public Flowable<BcosBlock> replayPastAndFutureBlocksFlowable(DefaultBlockParameter startBlock, boolean fullTransactionObjects) {
        return this.web3jRx.replayPastAndFutureBlocksFlowable(startBlock, fullTransactionObjects, this.blockTime);
    }

    @Override
    public Flowable<Transaction> replayPastAndFutureTransactionsFlowable(DefaultBlockParameter startBlock) {
        return this.web3jRx.replayPastAndFutureTransactionsFlowable(startBlock, this.blockTime);
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int groupId) {
        this.groupId = groupId;
    }

    public void shutdown() {
        this.scheduledExecutorService.shutdown();
        try {
            this.web3jService.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to close web3j service", e);
        }
    }
}

