/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.protocol.core.filters;

import java.io.IOException;
import java.math.BigInteger;
import java.util.List;
import java.util.Optional;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.Request;
import org.fisco.bcos.web3j.protocol.core.filters.Callback;
import org.fisco.bcos.web3j.protocol.core.filters.Filter;
import org.fisco.bcos.web3j.protocol.core.filters.FilterException;
import org.fisco.bcos.web3j.protocol.core.methods.request.BcosFilter;
import org.fisco.bcos.web3j.protocol.core.methods.response.BcosLog;
import org.fisco.bcos.web3j.protocol.core.methods.response.Log;

public class LogFilter
extends Filter<Log> {
    private final BcosFilter ethFilter;

    public LogFilter(Web3j web3j, Callback<Log> callback, BcosFilter ethFilter) {
        super(web3j, callback);
        this.ethFilter = ethFilter;
    }

    @Override
    org.fisco.bcos.web3j.protocol.core.methods.response.BcosFilter sendRequest() throws IOException {
        return this.web3j.newFilter(this.ethFilter).send();
    }

    @Override
    void process(List<BcosLog.LogResult> logResults) {
        for (BcosLog.LogResult logResult : logResults) {
            if (logResult instanceof BcosLog.LogObject) {
                Log log = ((BcosLog.LogObject)logResult).get();
                this.callback.onEvent(log);
                continue;
            }
            throw new FilterException("Unexpected result type: " + logResult.get() + " required LogObject");
        }
    }

    @Override
    protected Optional<Request<?, BcosLog>> getFilterLogs(BigInteger filterId) {
        return Optional.empty();
    }
}

