/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.protocol.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.fisco.bcos.web3j.protocol.Service;
import org.fisco.bcos.web3j.protocol.core.Request;
import org.fisco.bcos.web3j.protocol.core.Response;

public class HttpService
extends Service {
    public static final String DEFAULT_URL = "http://localhost:8545/";
    private CloseableHttpClient httpClient;
    private final String url;

    public HttpService(String url, CloseableHttpClient httpClient, boolean includeRawResponses) {
        super(includeRawResponses);
        this.url = url;
        this.httpClient = httpClient;
    }

    public HttpService(String url, CloseableHttpClient httpClient) {
        this(url, httpClient, false);
    }

    public HttpService(String url) {
        this(url, HttpClients.custom().setConnectionManagerShared(true).build());
    }

    public HttpService() {
        this(DEFAULT_URL);
    }

    protected void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Response> T send(Request request, Class<T> responseType) throws IOException {
        byte[] payload = this.objectMapper.writeValueAsBytes((Object)request);
        HttpPost httpPost = new HttpPost(this.url);
        httpPost.setEntity((HttpEntity)new ByteArrayEntity(payload));
        Header[] headers = this.buildHeaders();
        httpPost.setHeaders(headers);
        ResponseHandler<T> responseHandler = this.getResponseHandler(responseType);
        try {
            Response response = (Response)this.httpClient.execute((HttpUriRequest)httpPost, responseHandler);
            return (T)response;
        }
        finally {
            this.httpClient.close();
        }
    }

    @Override
    public void sendOnly(Request request) throws IOException {
    }

    private Header[] buildHeaders() {
        ArrayList<Header> headers = new ArrayList<Header>();
        headers.add((Header)new BasicHeader("Content-Type", "application/json; charset=UTF-8"));
        this.addHeaders(headers);
        return headers.toArray(new Header[0]);
    }

    protected void addHeaders(List<Header> headers) {
    }

    public <T extends Response> ResponseHandler<T> getResponseHandler(Class<T> type) {
        return response -> {
            int status = response.getStatusLine().getStatusCode();
            if (status >= 200 && status < 300) {
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    return (Response)this.objectMapper.readValue(response.getEntity().getContent(), type);
                }
                return null;
            }
            throw new ClientProtocolException("Unexpected response status: " + status);
        };
    }

    @Override
    public void close() throws IOException {
    }
}

