/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.solidity.compiler;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.fisco.bcos.web3j.protocol.ObjectMapperFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CompilationResult {
    @JsonProperty(value="contracts")
    private Map<String, ContractMetadata> contracts;
    @JsonProperty(value="version")
    public String version;

    @JsonIgnore
    public static CompilationResult parse(String rawJson) throws IOException {
        if (rawJson == null || rawJson.isEmpty()) {
            CompilationResult empty = new CompilationResult();
            empty.contracts = Collections.emptyMap();
            empty.version = "";
            return empty;
        }
        return (CompilationResult)ObjectMapperFactory.getObjectMapper().readValue(rawJson, CompilationResult.class);
    }

    @JsonIgnore
    public Path getContractPath() {
        if (this.contracts.size() > 1) {
            throw new UnsupportedOperationException("Source contains more than 1 contact. Please specify the contract name. Available keys (" + this.getContractKeys() + ").");
        }
        String key = this.contracts.keySet().iterator().next();
        return Paths.get(key.substring(0, key.lastIndexOf(58)), new String[0]);
    }

    @JsonIgnore
    public String getContractName() {
        if (this.contracts.size() > 1) {
            throw new UnsupportedOperationException("Source contains more than 1 contact. Please specify the contract name. Available keys (" + this.getContractKeys() + ").");
        }
        String key = this.contracts.keySet().iterator().next();
        return key.substring(key.lastIndexOf(58) + 1);
    }

    @JsonIgnore
    public ContractMetadata getContract(String contractName) {
        if (contractName == null && this.contracts.size() == 1) {
            return this.contracts.values().iterator().next();
        }
        if (contractName == null || contractName.isEmpty()) {
            throw new UnsupportedOperationException("Source contains more than 1 contact. Please specify the contract name. Available keys (" + this.getContractKeys() + ").");
        }
        for (Map.Entry<String, ContractMetadata> entry : this.contracts.entrySet()) {
            String key = entry.getKey();
            String name = key.substring(key.lastIndexOf(58) + 1);
            if (!contractName.equals(name)) continue;
            return entry.getValue();
        }
        throw new UnsupportedOperationException("No contract found with name '" + contractName + "'. Please specify a valid contract name. Available keys (" + this.getContractKeys() + ").");
    }

    @JsonIgnore
    public ContractMetadata getContract(Path contractPath, String contractName) {
        return this.contracts.get(contractPath.toAbsolutePath().toString() + ':' + contractName);
    }

    @JsonIgnore
    public List<ContractMetadata> getContracts() {
        return new ArrayList<ContractMetadata>(this.contracts.values());
    }

    @JsonIgnore
    public List<String> getContractKeys() {
        return new ArrayList<String>(this.contracts.keySet());
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class ContractMetadata {
        public String abi;
        public String bin;
        public String solInterface;
        public String metadata;

        public String getInterface() {
            return this.solInterface;
        }

        public void setInterface(String solInterface) {
            this.solInterface = solInterface;
        }
    }
}

