/*
 * Decompiled with CFR 0.152.
 */
package org.fisco.bcos.web3j.tx;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.fisco.bcos.web3j.crypto.Credentials;
import org.fisco.bcos.web3j.protocol.Web3j;
import org.fisco.bcos.web3j.protocol.core.methods.response.TransactionReceipt;
import org.fisco.bcos.web3j.protocol.exceptions.TransactionException;
import org.fisco.bcos.web3j.protocol.exceptions.TransactionTimeoutException;
import org.fisco.bcos.web3j.tx.ManagedTransaction;
import org.fisco.bcos.web3j.tx.RawTransactionManager;
import org.fisco.bcos.web3j.tx.TransactionManager;
import org.fisco.bcos.web3j.utils.Async;
import org.fisco.bcos.web3j.utils.Convert;
import org.fisco.bcos.web3j.utils.Numeric;

public class Transfer
extends ManagedTransaction {
    public static final BigInteger GAS_LIMIT = BigInteger.valueOf(21000L);
    public static final BigInteger GAS_PRICE = BigInteger.valueOf(1L);

    public Transfer(Web3j web3j, TransactionManager transactionManager) {
        super(web3j, transactionManager);
    }

    private TransactionReceipt send(String toAddress, BigDecimal value, Convert.Unit unit) throws IOException, TransactionException {
        return this.send(toAddress, value, unit, GAS_PRICE, GAS_LIMIT);
    }

    private TransactionReceipt send(String toAddress, BigDecimal value, Convert.Unit unit, BigInteger gasPrice, BigInteger gasLimit) throws IOException, TransactionException {
        BigDecimal weiValue = Convert.toWei(value, unit);
        if (!Numeric.isIntegerValue(weiValue)) {
            throw new UnsupportedOperationException("Non decimal Wei value provided: " + value + " " + unit.toString() + " = " + weiValue + " Wei");
        }
        String resolvedAddress = this.cnsService.getAddressByContractNameAndVersion(toAddress);
        return this.send(resolvedAddress, "", weiValue.toBigIntegerExact(), gasPrice, gasLimit);
    }

    public static TransactionReceipt sendFunds(Web3j web3j, Credentials credentials, String toAddress, BigDecimal value, Convert.Unit unit) throws IOException, TransactionException {
        RawTransactionManager transactionManager = new RawTransactionManager(web3j, credentials);
        return new Transfer(web3j, transactionManager).send(toAddress, value, unit);
    }

    public Future<TransactionReceipt> sendFundsAsync(String toAddress, BigDecimal value, Convert.Unit unit) {
        return Async.run(() -> this.send(toAddress, value, unit));
    }

    public Future<TransactionReceipt> sendFundsAsync(String toAddress, BigDecimal value, Convert.Unit unit, BigInteger gasPrice, BigInteger gasLimit) {
        return Async.run(() -> this.send(toAddress, value, unit, gasPrice, gasLimit));
    }

    public static Future<TransactionReceipt> sendFundsAsync(Web3j web3j, Credentials credentials, String toAddress, BigDecimal value, Convert.Unit unit) throws InterruptedException, ExecutionException, TransactionTimeoutException {
        RawTransactionManager transactionManager = new RawTransactionManager(web3j, credentials);
        return new Transfer(web3j, transactionManager).sendFundsAsync(toAddress, value, unit);
    }
}

