/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.bpmn.converter.parser;

import java.util.List;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.constants.BpmnXMLConstants;
import org.flowable.bpmn.converter.export.ProcessExport;
import org.flowable.bpmn.converter.util.BpmnXMLUtil;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Process;

public class ProcessParser
implements BpmnXMLConstants {
    public Process parse(XMLStreamReader xtr, BpmnModel model) throws Exception {
        Process process = null;
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "id"))) {
            String candidateGroupsString;
            String candidateUsersString;
            String processId = xtr.getAttributeValue(null, "id");
            process = new Process();
            process.setId(processId);
            BpmnXMLUtil.addXMLLocation((BaseElement)process, xtr);
            process.setName(xtr.getAttributeValue(null, "name"));
            if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "isExecutable"))) {
                process.setExecutable(Boolean.parseBoolean(xtr.getAttributeValue(null, "isExecutable")));
            }
            if (StringUtils.isNotEmpty((CharSequence)(candidateUsersString = BpmnXMLUtil.getAttributeValue("candidateStarterUsers", xtr)))) {
                List<String> candidateUsers = BpmnXMLUtil.parseDelimitedList(candidateUsersString);
                process.setCandidateStarterUsers(candidateUsers);
            }
            if (StringUtils.isNotEmpty((CharSequence)(candidateGroupsString = BpmnXMLUtil.getAttributeValue("candidateStarterGroups", xtr)))) {
                List<String> candidateGroups = BpmnXMLUtil.parseDelimitedList(candidateGroupsString);
                process.setCandidateStarterGroups(candidateGroups);
            }
            BpmnXMLUtil.addCustomAttributes(xtr, (BaseElement)process, ProcessExport.defaultProcessAttributes);
            model.getProcesses().add(process);
        }
        return process;
    }
}

