/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.agenda.operation;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.flowable.cmmn.api.runtime.PlanItemInstance;
import org.flowable.cmmn.api.runtime.PlanItemInstanceState;
import org.flowable.cmmn.converter.util.PlanItemDependencyUtil;
import org.flowable.cmmn.engine.impl.agenda.operation.CmmnOperation;
import org.flowable.cmmn.engine.impl.persistence.entity.CaseInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.SentryPartInstanceEntityManager;
import org.flowable.cmmn.engine.impl.util.CaseInstanceUtil;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.cmmn.model.EventListener;
import org.flowable.cmmn.model.PlanFragment;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.Stage;
import org.flowable.common.engine.impl.interceptor.CommandContext;

public abstract class AbstractPlanItemInstanceOperation
extends CmmnOperation {
    protected PlanItemInstanceEntity planItemInstanceEntity;

    public AbstractPlanItemInstanceOperation(CommandContext commandContext, PlanItemInstanceEntity planItemInstanceEntity) {
        super(commandContext);
        this.planItemInstanceEntity = planItemInstanceEntity;
    }

    public PlanItemInstanceEntity getPlanItemInstanceEntity() {
        return this.planItemInstanceEntity;
    }

    public void setPlanItemInstanceEntity(PlanItemInstanceEntity planItemInstanceEntity) {
        this.planItemInstanceEntity = planItemInstanceEntity;
    }

    protected void removeSentryRelatedData() {
        this.deleteSentryPartInstances();
        this.deleteOrphanEventListeners();
    }

    protected void deleteSentryPartInstances() {
        SentryPartInstanceEntityManager sentryPartInstanceEntityManager = CommandContextUtil.getSentryPartInstanceEntityManager(this.commandContext);
        if (!(this.planItemInstanceEntity.getPlanItem() == null || this.planItemInstanceEntity.getPlanItem().getEntryCriteria().isEmpty() && this.planItemInstanceEntity.getPlanItem().getExitCriteria().isEmpty() || this.planItemInstanceEntity.getSatisfiedSentryPartInstances() == null)) {
            for (SentryPartInstanceEntity sentryPartInstanceEntity : this.planItemInstanceEntity.getSatisfiedSentryPartInstances()) {
                sentryPartInstanceEntityManager.delete(sentryPartInstanceEntity);
            }
        }
    }

    protected void deleteOrphanEventListeners() {
        List<PlanItem> eventListenerDependencies;
        PlanItem planItem = this.planItemInstanceEntity.getPlanItem();
        if (planItem != null && !(eventListenerDependencies = this.gatherEventListenerDependencies(planItem)).isEmpty()) {
            this.terminateOrphanedEventListeners(eventListenerDependencies);
        }
    }

    protected List<PlanItem> gatherEventListenerDependencies(PlanItem planItem) {
        List<PlanItem> eventListenerDependencies = Stream.concat(planItem.getEntryDependencies().stream().filter(p -> p.getPlanItemDefinition() instanceof EventListener), planItem.getExitDependencies().stream().filter(p -> p.getPlanItemDefinition() instanceof EventListener)).collect(Collectors.toList());
        if (planItem.getPlanItemDefinition() instanceof PlanFragment && PlanItemInstanceState.isInTerminalState((PlanItemInstance)this.planItemInstanceEntity)) {
            List<PlanItem> childPlanItemsWithDependencies = this.getChildPlanItemsWithDependencies((PlanFragment)planItem.getPlanItemDefinition());
            CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(this.commandContext).findById(this.planItemInstanceEntity.getCaseInstanceId());
            Map<String, List<PlanItemInstanceEntity>> childPlanItemInstancesMap = CaseInstanceUtil.findChildPlanItemInstancesMap(caseInstanceEntity, childPlanItemsWithDependencies);
            for (PlanItem childPlanItemWithDependencies : childPlanItemsWithDependencies) {
                if (childPlanItemInstancesMap.containsKey(childPlanItemWithDependencies.getId())) continue;
                eventListenerDependencies.addAll(childPlanItemWithDependencies.getEntryDependencies().stream().filter(p -> p.getPlanItemDefinition() instanceof EventListener).collect(Collectors.toList()));
                eventListenerDependencies.addAll(childPlanItemWithDependencies.getExitDependencies().stream().filter(p -> p.getPlanItemDefinition() instanceof EventListener).collect(Collectors.toList()));
            }
        }
        return eventListenerDependencies;
    }

    protected void terminateOrphanedEventListeners(List<PlanItem> eventListenerDependencies) {
        CaseInstanceEntity caseInstanceEntity = (CaseInstanceEntity)CommandContextUtil.getCaseInstanceEntityManager(this.commandContext).findById(this.planItemInstanceEntity.getCaseInstanceId());
        for (PlanItem eventListenerPlanItem : eventListenerDependencies) {
            List<PlanItemInstanceEntity> eventListenerPlanItemInstance = CaseInstanceUtil.findNonTerminalChildPlanItemInstances(caseInstanceEntity, eventListenerPlanItem);
            if (eventListenerPlanItemInstance.isEmpty()) continue;
            List dependentPlanItems = eventListenerPlanItem.getAllDependentPlanItems();
            Map<String, List<PlanItemInstanceEntity>> dependentPlanItemInstancesMap = CaseInstanceUtil.findChildPlanItemInstancesMap(caseInstanceEntity, dependentPlanItems);
            boolean isOrphan = true;
            Iterator planItemIterator = dependentPlanItems.iterator();
            while (isOrphan && planItemIterator.hasNext()) {
                PlanItem dependentPlanItem = (PlanItem)planItemIterator.next();
                List<PlanItemInstanceEntity> dependentPlanItemInstances = dependentPlanItemInstancesMap.get(dependentPlanItem.getId());
                if (dependentPlanItemInstances != null && !dependentPlanItemInstances.isEmpty()) {
                    for (PlanItemInstanceEntity dependentPlanItemInstance : dependentPlanItemInstances) {
                        if (PlanItemDependencyUtil.isEntryDependency((PlanItem)dependentPlanItemInstance.getPlanItem(), (PlanItem)eventListenerPlanItem) && ("available".equals(dependentPlanItemInstance.getState()) || "wait_repetition".equals(dependentPlanItemInstance.getState()))) {
                            isOrphan = false;
                        }
                        if (!PlanItemDependencyUtil.isExitDependency((PlanItem)dependentPlanItemInstance.getPlanItem(), (PlanItem)eventListenerPlanItem) || PlanItemInstanceState.TERMINAL_STATES.contains(dependentPlanItemInstance.getState())) continue;
                        isOrphan = false;
                    }
                    continue;
                }
                Stage parentStage = dependentPlanItem.getParentStage();
                while (isOrphan && parentStage != null && !parentStage.isPlanModel()) {
                    List<PlanItemInstanceEntity> nonTerminalStagePlanItemInstances = CaseInstanceUtil.findNonTerminalChildPlanItemInstances(caseInstanceEntity, parentStage.getPlanItem());
                    if (!nonTerminalStagePlanItemInstances.isEmpty()) {
                        isOrphan = false;
                        continue;
                    }
                    parentStage = parentStage.getParentStage();
                }
            }
            if (!isOrphan) continue;
            for (PlanItemInstanceEntity eventListenerPlanItemInstanceEntity : eventListenerPlanItemInstance) {
                CommandContextUtil.getAgenda(this.commandContext).planTerminatePlanItemInstanceOperation(eventListenerPlanItemInstanceEntity);
            }
        }
    }

    protected boolean isPlanItemRepeatableOnComplete(PlanItem planItem) {
        return planItem != null && planItem.getEntryCriteria().isEmpty() && planItem.getItemControl() != null && planItem.getItemControl().getRepetitionRule() != null;
    }

    protected Date getCurrentTime(CommandContext commandContext) {
        return CommandContextUtil.getCmmnEngineConfiguration(commandContext).getClock().getCurrentTime();
    }

    protected List<PlanItem> getChildPlanItemsWithDependencies(PlanFragment planFragment) {
        ArrayList<PlanItem> childPlanItemsWithDependencies = new ArrayList<PlanItem>();
        this.internalGetChildPlanItemsWithDependencies(planFragment, childPlanItemsWithDependencies);
        return childPlanItemsWithDependencies;
    }

    protected void internalGetChildPlanItemsWithDependencies(PlanFragment planFragment, List<PlanItem> childPlanItemsWithDependencies) {
        for (PlanItem planItem : planFragment.getPlanItems()) {
            if (planItem.getEntryDependencies().isEmpty() && planItem.getExitDependencies().isEmpty()) continue;
            childPlanItemsWithDependencies.add(planItem);
            if (!(planItem.getPlanItemDefinition() instanceof PlanFragment)) continue;
            this.internalGetChildPlanItemsWithDependencies((PlanFragment)planItem.getPlanItemDefinition(), childPlanItemsWithDependencies);
        }
    }
}

