/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.parser.handler;

import java.util.Collection;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.flowable.cmmn.engine.impl.parser.CmmnActivityBehaviorFactory;
import org.flowable.cmmn.engine.impl.parser.CmmnParseResult;
import org.flowable.cmmn.engine.impl.parser.CmmnParserImpl;
import org.flowable.cmmn.engine.impl.parser.handler.AbstractPlanItemParseHandler;
import org.flowable.cmmn.model.BaseElement;
import org.flowable.cmmn.model.ImplementationType;
import org.flowable.cmmn.model.PlanItem;
import org.flowable.cmmn.model.ServiceTask;

public class ServiceTaskParseHandler
extends AbstractPlanItemParseHandler<ServiceTask> {
    @Override
    public Collection<Class<? extends BaseElement>> getHandledTypes() {
        return Collections.singletonList(ServiceTask.class);
    }

    @Override
    protected void executePlanItemParse(CmmnParserImpl cmmnParser, CmmnParseResult cmmnParseResult, PlanItem planItem, ServiceTask serviceTask) {
        CmmnActivityBehaviorFactory activityBehaviorFactory = cmmnParser.getActivityBehaviorFactory();
        switch (serviceTask.getType()) {
            case "http": {
                planItem.setBehavior((Object)activityBehaviorFactory.createHttpActivityBehavior(planItem, serviceTask));
                break;
            }
            default: {
                if (!StringUtils.isNotEmpty((CharSequence)serviceTask.getImplementation())) break;
                if (ImplementationType.IMPLEMENTATION_TYPE_CLASS.equals(serviceTask.getImplementationType())) {
                    planItem.setBehavior((Object)activityBehaviorFactory.createCmmnClassDelegate(planItem, serviceTask));
                    break;
                }
                if (ImplementationType.IMPLEMENTATION_TYPE_EXPRESSION.equals(serviceTask.getImplementationType())) {
                    planItem.setBehavior((Object)activityBehaviorFactory.createPlanItemExpressionActivityBehavior(planItem, serviceTask));
                    break;
                }
                if (!ImplementationType.IMPLEMENTATION_TYPE_DELEGATEEXPRESSION.equals(serviceTask.getImplementationType())) break;
                planItem.setBehavior((Object)activityBehaviorFactory.createPlanItemDelegateExpressionActivityBehavior(planItem, serviceTask));
            }
        }
    }
}

