/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.entitylink.api.EntityLink;
import org.flowable.entitylink.api.EntityLinkService;
import org.flowable.entitylink.service.impl.persistence.entity.EntityLinkEntity;

public class EntityLinkUtil {
    public static void copyExistingEntityLinks(String scopeId, String referenceScopeId, String referenceScopeType) {
        EntityLinkService entityLinkService = CommandContextUtil.getEntityLinkService();
        List entityLinks = entityLinkService.findEntityLinksByReferenceScopeIdAndType(scopeId, "cmmn", "child");
        ArrayList<String> parentIds = new ArrayList<String>();
        for (EntityLink entityLink : entityLinks) {
            if (parentIds.contains(entityLink.getScopeId())) continue;
            EntityLinkEntity newEntityLink = (EntityLinkEntity)entityLinkService.createEntityLink();
            newEntityLink.setLinkType("child");
            newEntityLink.setScopeId(entityLink.getScopeId());
            newEntityLink.setScopeType(entityLink.getScopeType());
            newEntityLink.setScopeDefinitionId(entityLink.getScopeDefinitionId());
            newEntityLink.setReferenceScopeId(referenceScopeId);
            newEntityLink.setReferenceScopeType(referenceScopeType);
            if ("root".equals(entityLink.getHierarchyType())) {
                newEntityLink.setHierarchyType(entityLink.getHierarchyType());
            }
            entityLinkService.insertEntityLink((EntityLink)newEntityLink);
            CommandContextUtil.getCmmnHistoryManager().recordEntityLinkCreated(newEntityLink);
            parentIds.add(entityLink.getScopeId());
        }
    }

    public static void createNewEntityLink(String scopeId, String referenceScopeId, String referenceScopeType) {
        EntityLinkService entityLinkService = CommandContextUtil.getEntityLinkService();
        Optional<EntityLink> entityLinkWithRoot = entityLinkService.findEntityLinksByReferenceScopeIdAndType(scopeId, "cmmn", "child").stream().filter(e -> "root".equals(e.getHierarchyType())).findFirst();
        EntityLinkEntity newEntityLink = (EntityLinkEntity)entityLinkService.createEntityLink();
        newEntityLink.setLinkType("child");
        newEntityLink.setScopeId(scopeId);
        newEntityLink.setScopeType("cmmn");
        newEntityLink.setReferenceScopeId(referenceScopeId);
        newEntityLink.setReferenceScopeType(referenceScopeType);
        if (!entityLinkWithRoot.isPresent()) {
            newEntityLink.setHierarchyType("root");
        } else {
            newEntityLink.setHierarchyType("parent");
        }
        entityLinkService.insertEntityLink((EntityLink)newEntityLink);
        CommandContextUtil.getCmmnHistoryManager().recordEntityLinkCreated(newEntityLink);
    }
}

